/*
**	Spiffy Calendar utility scripts on front end
**
**  Version 2.0
*/

jQuery(document).ready(function($){
	// Maintain scroll position
	if (sessionStorage.scrollTop != "undefined") {
		$(window).scrollTop(sessionStorage.scrollTop);
		sessionStorage.scrollTop = 0;
	}
	

	
	// Toggle grid/list on full calendar display
	$( ".calendar-toggle-button" ).click(function() {
		if ($(".calendar-toggle-button").text() == $(".calendar-toggle-button").attr('data-list')) {
			//
			// Toggling to list mode
			//
			$(".calendar-toggle-button").text($(".calendar-toggle-button").attr('data-grid'));
			$(".spiffy.bigcal").addClass("spiffy-listed");
			$("<span class='spiffy-month-name'></span>" ).insertBefore( ".spiffy.bigcal .day-number" );
			$(".spiffy-month-name").text($(".calendar-toggle-button").attr('data-month'));
			$("[name='grid-list-toggle']").val('list');
			$("a.spiffy-calendar-arrow").attr('href', function(i,a){ 
				return a.replace( /(grid-list-toggle=)[a-z]+/ig, '$1'+'list' );	
			});
		} else {
			//
			// Toggling to grid mode
			//
			$(".calendar-toggle-button").text($(".calendar-toggle-button").attr('data-list'));
			$(".spiffy-month-name").remove();
			$(".spiffy.bigcal").removeClass("spiffy-listed");			
			$("[name='grid-list-toggle']").val('grid');
			$("a.spiffy-calendar-arrow").attr('href', function(i,a){ 
				return a.replace( /(grid-list-toggle=)[a-z]+/ig, '$1'+'grid' );	
			});
		}
	});
	
	// Show custom field headings if followed by field data
	$('[class*="spiffy-custom-field-view-"]').prev().css( "display", "block" );
	
});


// Support hover/click on iOS
jQuery( document.body ).on( 'touchstart', function( e ) {
});