"use strict";

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

// This file was generated by modules-webmake (modules for web) project.
// See: https://github.com/medikoo/modules-webmake
(function (modules) {
  'use strict';

  var _resolve,
      getRequire,
      wmRequire,
      notFoundError,
      findFile,
      extensions = {
    ".js": [],
    ".json": [],
    ".css": [],
    ".html": []
  },
      envRequire = typeof require === 'function' ? require : null;

  notFoundError = function notFoundError(path) {
    var error = new Error("Could not find module '" + path + "'");
    error.code = 'MODULE_NOT_FOUND';
    return error;
  };

  findFile = function findFile(scope, name, extName) {
    var i, ext;
    if (typeof scope[name + extName] === 'function') return name + extName;

    for (i = 0; ext = extensions[extName][i]; ++i) {
      if (typeof scope[name + ext] === 'function') return name + ext;
    }

    return null;
  };

  _resolve = function resolve(scope, tree, path, fullPath, state, id) {
    var name, dir, exports, module, fn, found, ext;
    path = path.split('/');
    name = path.pop();

    if (name === '.' || name === '..') {
      path.push(name);
      name = '';
    }

    while ((dir = path.shift()) != null) {
      if (!dir || dir === '.') continue;

      if (dir === '..') {
        scope = tree.pop();
        id = id.slice(0, id.lastIndexOf('/'));
      } else {
        tree.push(scope);
        scope = scope[dir];
        id += '/' + dir;
      }

      if (!scope) throw notFoundError(fullPath);
    }

    if (name && typeof scope[name] !== 'function') {
      found = findFile(scope, name, '.js');
      if (!found) found = findFile(scope, name, '.json');
      if (!found) found = findFile(scope, name, '.css');
      if (!found) found = findFile(scope, name, '.html');

      if (found) {
        name = found;
      } else if (state !== 2 && _typeof(scope[name]) === 'object') {
        tree.push(scope);
        scope = scope[name];
        id += '/' + name;
        name = '';
      }
    }

    if (!name) {
      if (state !== 1 && scope[':mainpath:']) {
        return _resolve(scope, tree, scope[':mainpath:'], fullPath, 1, id);
      }

      return _resolve(scope, tree, 'index', fullPath, 2, id);
    }

    fn = scope[name];
    if (!fn) throw notFoundError(fullPath);
    if (fn.hasOwnProperty('module')) return fn.module.exports;
    exports = {};
    fn.module = module = {
      exports: exports,
      id: id + '/' + name
    };
    fn.call(exports, exports, module, getRequire(scope, tree, id));
    return module.exports;
  };

  wmRequire = function wmRequire(scope, tree, fullPath, id) {
    var name,
        path = fullPath,
        t = fullPath.charAt(0),
        state = 0;

    if (t === '/') {
      path = path.slice(1);
      scope = modules['/'];

      if (!scope) {
        if (envRequire) return envRequire(fullPath);
        throw notFoundError(fullPath);
      }

      id = '/';
      tree = [];
    } else if (t !== '.') {
      name = path.split('/', 1)[0];
      scope = modules[name];

      if (!scope) {
        if (envRequire) return envRequire(fullPath);
        throw notFoundError(fullPath);
      }

      id = name;
      tree = [];
      path = path.slice(name.length + 1);

      if (!path) {
        path = scope[':mainpath:'];

        if (path) {
          state = 1;
        } else {
          path = 'index';
          state = 2;
        }
      }
    }

    return _resolve(scope, tree, path, fullPath, state, id);
  };

  getRequire = function getRequire(scope, tree, id) {
    return function (path) {
      return wmRequire(scope, [].concat(tree), path, id);
    };
  };

  return getRequire(modules, [], '');
})({
  "workspace": {
    "inc": {
      "assets": {
        "js": {
          "architect": {
            "editor": {
              "section-hover.js": function sectionHoverJs(exports, module, require) {
                var Layout = require('../main/models/layout.js');

                var SectionHover =
                /*#__PURE__*/
                function () {
                  _createClass(SectionHover, null, [{
                    key: "hoverClass",
                    get: function get() {
                      return 'section-hover';
                    }
                  }]);

                  function SectionHover() {
                    _classCallCheck(this, SectionHover);

                    this.listenersInit();
                  }
                  /**
                   * When hovering an element that is inside a section, add outline to the section so we know the area we're working on.
                   */


                  _createClass(SectionHover, [{
                    key: "listenersInit",
                    value: function listenersInit(section) {
                      var _this = this;

                      var addListener = function addListener($section) {
                        $section.find(' > div').on('mouseenter', function (event) {
                          _this.showIcons(event.currentTarget);
                        }).on('mouseleave', function (event) {
                          _this.hideIcons(event.currentTarget);
                        });
                      };

                      if (typeof section === 'undefined') {
                        Object.values(TVE.Theme.$sections).forEach(addListener);
                      } else {
                        addListener(TVE.Theme.$sections[section]);
                      }
                    }
                    /**
                     * set element outline and position element name
                     * @param section
                     * @param forceHide
                     */

                  }, {
                    key: "showIcons",
                    value: function showIcons(section) {
                      var forceHide = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

                      /* hide the name and outline when resizing */
                      if (TVE.Theme.FLAGS.doingResize) {
                        this.hideIcons(section);
                        return;
                      }

                      if (section && !section.parentElement.classList.contains(SectionHover.hoverClass)) {
                        if (forceHide) {
                          SectionHover.clearHoverClass();
                        }

                        section.parentElement.classList.add(SectionHover.hoverClass);
                      }
                    }
                    /**
                     * remove the section outline and hide the name
                     * @param section
                     */

                  }, {
                    key: "hideIcons",
                    value: function hideIcons(section) {
                      if (section) {
                        section.parentElement.classList.remove(SectionHover.hoverClass);
                      } else {
                        SectionHover.clearHoverClass();
                      }
                    }
                    /**
                     * Remove the hover class from any element that previously had it
                     */

                  }], [{
                    key: "clearHoverClass",
                    value: function clearHoverClass() {
                      TVE.inner.$body.find('.' + SectionHover.hoverClass).removeClass(SectionHover.hoverClass);
                    }
                  }]);

                  return SectionHover;
                }();

                module.exports = SectionHover;
              }
            },
            "main": {
              "actions": {
                "common-section.js": function commonSectionJs(exports, module, require) {
                  (function ($) {
                    var Section = require('../models/section'),
                        LPSection = require('../../../landingpage/models/lp-section');
                    /**
                     * Here we will have actions that are common both for theme-sections and also for landing page sections
                     */


                    module.exports = {
                      /**
                       * Display overlay buttons on the section when it's a dynamic saved one.
                       *
                       * @param event
                       */
                      'tcb.element.click': function tcbElementClick(event) {
                        var $element = TVE.inner_$(event.currentTarget);
                        /* the sidebar trigger is inside the section, but we should be able to select it even if the section is dynamic */

                        if (!$element.is(TVE.identifier('sidebar-trigger'))) {
                          var section = TVE.Theme.utils.getSectionInstance($element);

                          if (section && section.isDynamic() && !section.inEditMode() && !section.$element.hasClass('section-no-overlay')) {
                            new TVE.Theme.views.SectionOverlay({
                              section: section
                            });
                          }
                        }
                      },

                      /**
                       * When exiting edit mode of a section, we focus that section.
                       *
                       * @param {jQuery} $element
                       */
                      'tcb.edit_mode.exit': function tcbEdit_modeExit($element) {
                        if ($element.is(Section.identifier + ', ' + LPSection.identifier)) {
                          var section = TVE.Theme.utils.getSectionInstance(TVE.inner_$($element));

                          if (section) {
                            section.update();
                            TVE.Editor_Page.focus_element($element);
                          }
                        }
                      },

                      /**
                       * After the request has been whitelisted, we try to save the section again.
                       *
                       * @param {String} url
                       * @param data
                       */
                      'tcb.wordfence.whitelist': function tcbWordfenceWhitelist(url, data) {
                        var match = url.match(/sections\/(\d*)/);

                        if (match && match.length === 2) {
                          var $section = TVE.Theme.$wrapper.find(".thrive-section-".concat(match[1]));

                          if ($section.length) {
                            TVE.Theme.utils.getSectionInstance($section).update(true);
                          }
                        }
                      },

                      /**
                       * After setting a fancy divider on a section, we remove the extra attributes and select the section after.
                       *
                       * @param {jQuery} $element
                       * @param {String} type
                       */
                      'tcb_after_cloud_template': function tcb_after_cloud_template($element, type) {
                        if (type === 'fancy-divider' && $element.hasClass('section-background')) {
                          $element.removeAttr('data-ct-name data-ct').attr('data-element-name', "".concat(TVE.ucFirst($element.attr('data-section')), " Section"));
                        }
                      },

                      /**
                       * When a section is loaded we need to fix the empty widgets and handle the post list
                       *
                       * @param {Object} data
                       * @param {Section} section
                       */
                      'theme.section.after_insert': function themeSectionAfter_insert(data, section) {
                        /* Fix empty widgets */
                        section.$element.find(".".concat(TVE.Models.Widget.elementClass)).each(function (index, element) {
                          var widget = new TVE.Models.Widget(TVE.inner_$(element));
                          widget.maybeAddEmptyPlaceholder();
                        });
                        /* Redo pagination, masonry layout and make sure all the new posts have data */

                        section.$element.find(TVE.identifier('post_list')).each(function (index, element) {
                          var $postList = TVE.inner_$(element),
                              type = $postList.attr('data-pagination-type');

                          if (type === 'numeric' || type === 'load_more') {
                            /* for each post list from this section, render the pagination again */
                            TVE.PostList.content.renderPaginationForPostList($postList);
                          }
                          /* Mostly done for the masonry layout */


                          TVE.PostList.layout.applyLayout($postList, true);
                          /* find all the post IDs that are used in the post lists from this page so we can bring their info through ajax */

                          var postsWithoutData = _.uniq(
                          /* read the id on each article */
                          $postList.find(TVE.identifier('article')).map(function (index, element) {
                            return parseInt(element.dataset.id);
                          })
                          /* we only need the posts that don't have data */
                          ).filter(function (postId) {
                            return typeof TVE.PostList.posts[postId] === 'undefined';
                          });

                          if (postsWithoutData.length) {
                            TVE.PostList.utils.fetchPosts({
                              'get_initial_posts': true,
                              'post_ids': postsWithoutData
                            });
                          }
                        });
                      },

                      /**
                       * When we start dragging elements, we save a flag if we drag an element from inside the article
                       *
                       * @param {jQuery} $element
                       */
                      'tcb.dragstart': function tcbDragstart($element) {
                        TVE.FLAGS.dragFromSectionInstance = TVE.Theme.utils.getSectionInstance($element);
                      },

                      /**
                       * Triggered when an image is changed in the canvas. If the image is inside an article, we trigger the template sync.
                       *
                       * @param {Object} image
                       */
                      'tcb.image.change': function tcbImageChange(image) {
                        /* If the image is larger than the section, we make it 100% */
                        var section = TVE.Theme.utils.getSectionInstance(TVE.ActiveElement);

                        if (section && section.$content.length && TVE.ActiveElement.width() > section.$content.width()) {
                          TVE.ActiveElement.head_css({
                            'width': '100%'
                          });
                        }
                      },

                      /**
                       * Action after the element was inserted ( this covers all the drop cases ). Change css prefix if we're moving element from one section to another
                       *
                       * @param {jQuery} $element
                       */
                      'tcb.after-insert': function tcbAfterInsert($element) {
                        var endSectionInstance = TVE.Theme.utils.getSectionInstance($element);
                        /* If the element it's not dropped in a theme section or the dragging wasn't started from a theme section we don't need to do anything */

                        if (!endSectionInstance || endSectionInstance.isDynamic() || !TVE.FLAGS.dragFromSectionInstance) {
                          return;
                        }

                        var startSectionInstance = TVE.FLAGS.dragFromSectionInstance;

                        if (endSectionInstance.type === 'sidebar') {
                          TVE.inner.window.ThriveTheme.sidebar.fixContentHeight();
                        }
                        /* We only change the rules if an element is moved from one section to another */


                        if (startSectionInstance.selector !== endSectionInstance.selector) {
                          var rules = TVE.stylesheet.cssRules,
                              escapeRegexFn = TVE.Theme.utils.escapedRegEx;

                          for (var i = 0; i < rules.length; i++) {
                            if (rules[i].type === CSSRule.MEDIA_RULE) {
                              for (var j = 0; j < rules[i].cssRules.length; j++) {
                                var rule = rules[i].cssRules[j];
                                /* exclude css that is from the layout */

                                if (rule.selectorText.includes(startSectionInstance.selector)) {
                                  var elementSelector = rule.selectorText.replace(TVE.Theme.utils.pseudoSelectorsRegex(), '').replace(escapeRegexFn(TVE.Theme.CONST.body_class, 'g'), '').replace(escapeRegexFn(startSectionInstance.selector, 'g'), '').replace(escapeRegexFn(startSectionInstance.constructor.backgroundSelector, 'g'), '').replace(escapeRegexFn(startSectionInstance.constructor.contentSelector, 'g'), '').replace(escapeRegexFn(TVE.CONST.global_css_prefix, 'g'), '').trim();

                                  if (elementSelector.length &&
                                  /* when we apply typography css on the section, after we remove the prefixes, we are left only with p, li, label, h1 and so on
                                  *  we have to make sure we don't copy this css and not confuse with content box cases  */
                                  elementSelector.split(',').map(function (s) {
                                    return s.trim();
                                  }).filter(function (s) {
                                    return Section.typographySuffix.includes(s);
                                  }).length === 0 && endSectionInstance.$element.find(elementSelector).length) {
                                    /* and the element exists */
                                    var cssText = rule.cssText.replace(escapeRegexFn(startSectionInstance.selector, 'g'), endSectionInstance.baseSelector);
                                    rules[i].deleteRule(j);
                                    rules[i].insertRule(TVE.remove_extra_spaces(cssText), j);
                                  }
                                }
                              }
                            }
                          }

                          if ($element.is(TVE.identifier('post_list'))) {
                            /* these styles have to be manually regenerated */
                            TVE.PostList.dynamicImage.regeneratePostListStyleNodes($element);
                          }
                        }

                        TVE.FLAGS.dragFromSectionInstance = null;
                      },

                      /**
                       * Toggle components when we select a section
                       *
                       * @param {jQuery} $section
                       */
                      'tcb.element.focus': function tcbElementFocus($section) {
                        var section = TVE.Theme.utils.getSectionInstance($section);

                        if (section && (section.constructor.is($section) || section.isContent($section) || section.isBackground($section))) {
                          setTimeout(function () {
                            return section.toggleComponents();
                          });
                        }
                      }
                    };
                  })(jQuery);
                }
              },
              "components": {
                "theme-section.js": function themeSectionJs(exports, module, require) {
                  var Layout = require('../models/layout'),
                      sidebar = function sidebar() {
                    return TVE.inner.window.ThriveTheme.sidebar;
                  },
                      SectionSelect = require('../controls/section-select');

                  var timer;
                  module.exports = TVE.Views.Base.component.extend({
                    after_init: function after_init() {
                      this.sectionSelect = new SectionSelect({
                        el: this.$('.section-select')
                      });
                    },

                    /**
                     * Before updating components, save an instance of the current section
                     */
                    before_update: function before_update() {
                      this.section = TVE.Theme.utils.getSectionInstance(TVE.ActiveElement);
                      this.sectionSelect.setSection(this.section).setSectionComponent(this);
                      return this;
                    },

                    /**
                     * Hides the tooltip when its corresponding section is hovered if the user stays there for more than 0.5 seconds. See also @mouseleave
                     */
                    mouseenter: function mouseenter() {
                      timer = setTimeout(function () {
                        if (TVE.Components.theme_section.tooltip) {
                          TVE.Components.theme_section.tooltip.dismiss();
                        }
                      }, 500);
                    },

                    /**
                     * Clears the timeout initiated by mouseenter
                     */
                    mouseleave: function mouseleave() {
                      clearTimeout(timer);
                    },
                    controls_init: function controls_init(controls) {
                      var initAll = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

                      var resizePageSection = _.throttle(TVE.inner.window.TCB_Front.resizePageSection, 10),
                          masonryRedo = _.throttle(TVE.PostList.layout.masonryRedo, 500),
                          self = this;

                      if (initAll) {
                        controls['Position'].change = function ($element, control) {
                          var position = control.value;
                          TVE.Theme.$main.toggleClass(TVE.Theme.constants.identifiers.FLIP_SECTIONS_CLASS, position === 'left');

                          if (self.section.type === 'sidebar') {
                            sidebar().offScreenRefresh(true);
                          }

                          TVE.Editor_Page.reposition_icons();
                          setTimeout(TVE.inner.window.TCB_Front.resizePageSection, 500);
                          controls.PageMap.update($element);
                        };

                        controls['Position'].update = function () {
                          var position = TVE.Theme.$main.hasClass(TVE.Theme.constants.identifiers.FLIP_SECTIONS_CLASS) ? 'left' : 'right';
                          this.setValue(position);
                          this.$el.toggleClass('tcb-disabled', self.section.type === 'sidebar' && !self.section.isVisible());
                        };

                        controls['MinWidth'].input = function ($element, control) {
                          this.applyElementCss({
                            'min-width': control.value + this.getUM()
                          });
                          masonryRedo();

                          if (sidebar().isOffScreen()) {
                            if (parseInt(TVE.inner.document.body.style.getPropertyValue('--off-screen-sidebar-size')) < control.value) {
                              sidebar()._get('off-screen').updateSidebarWidth(control.value);
                            } else {
                              sidebar()._get('off-screen').updateSidebarWidth();
                            }
                          }
                        };

                        controls['MinWidth'].change = function ($element, control) {
                          this.applyElementCss({
                            'min-width': control.value + this.getUM()
                          });
                          masonryRedo();
                        };

                        controls['MinWidth'].update = function ($element) {
                          var minWidth = parseInt($element.css('min-width'));
                          this.setValue(isNaN(minWidth) ? 0 : minWidth);
                          this.$el.toggleClass('tcb-disabled',
                          /* disable control for content when sidebar is off screen and for sidebar when it's not visible */
                          self.section.type === 'content' && sidebar().isOffScreen() || self.section.type === 'sidebar' && !self.section.isVisible());
                          this.originalConfig.max = TVE.Theme.$main.width();
                        };
                      }

                      controls['Visibility'].change = function ($element, control) {
                        self.section.toggle(control.checked);
                        /* this hides the 'Hide Sidebar' icon that hovers above the element */

                        TVE.ElementEditIcons.hide_icons();
                      };

                      controls['Visibility'].update = function () {
                        this.setChecked(self.section.isVisible());
                      };

                      controls['StretchBackground'].input = function ($element, control) {
                        var stretchToFull = control.checked;
                        self.section.setWidth(stretchToFull ? '100%' : '', 'background', true);
                        var newBackgroundWidth = self.section.$background.css('width');
                        /* when we un stretch, if the background width is smaller than the content one, we also lower the content */

                        if (!stretchToFull && parseInt(self.section.$content.css('width')) > parseInt(newBackgroundWidth)) {
                          var contentWidth = '';

                          if (!self.section.inheritsContent()) {
                            contentWidth = newBackgroundWidth;
                          }

                          self.section.setWidth(contentWidth, 'content', true);
                        }

                        if (self.section.type === 'top' || self.section.type === 'bottom') {
                          TVE.Theme.utils.toggleSectionFullWidth($element, stretchToFull);
                        }

                        controls.PageMap.update($element);
                        controls['ContentWidth'].update();
                        controls['StretchContent'].update();
                      };

                      controls['StretchBackground'].update = function () {
                        this.setChecked(self.section.hasFullWidthBackground());
                        this.$el.toggleClass('tcb-disabled', !self.section.isVisible());
                      };

                      controls['ContentWidth'].input = function ($element, control) {
                        self.section.setWidth(control.value + this.getUM(), 'content', false);
                        resizePageSection();
                        masonryRedo();
                      };

                      controls['ContentWidth'].change = function ($element, control) {
                        self.section.setWidth(control.value + this.getUM(), 'content', true);
                      };

                      controls['ContentWidth'].update = function () {
                        var contentWidth = self.section.$content.css('width'),
                            backgroundWidth = parseInt(self.section.$background.css('width'));
                        this.$el.toggleClass('tcb-disabled', self.section.hasFullWidthContent() || !self.section.isVisible());
                        this.originalConfig.max = backgroundWidth;
                        this.setValue(contentWidth);
                      };

                      controls['StretchContent'].input = function ($element, control) {
                        self.section.setWidth(control.checked ? '100%' : '', 'content', true);
                        resizePageSection();
                        masonryRedo();
                        controls['ContentWidth'].update();
                      };

                      controls['StretchContent'].update = function () {
                        this.setChecked(self.section.hasFullWidthContent());
                        this.$el.toggleClass('tcb-disabled', !self.section.isVisible() || !self.section.hasFullWidthBackground());
                      };

                      controls['InheritContentSize'].input = function ($element, control) {
                        var inherit = control.checked;
                        self.section.setWidth(inherit ? '' : Layout.getWidth('content'), 'content', true);

                        if (!inherit) {
                          controls['ContentWidth'].update();
                          controls['StretchContent'].update();
                        }

                        controls['ContentWidth'].$el.toggle(!inherit);
                        controls['StretchContent'].$el.toggle(!inherit);
                        resizePageSection();
                        masonryRedo();
                      };

                      controls['InheritContentSize'].update = function () {
                        this.setChecked(self.section.inheritsContent());
                        this.$el.toggleClass('tcb-disabled', !self.section.isVisible());
                      };

                      controls['SectionHeight'].input = function ($element, control) {
                        this.applyElementCss({
                          'min-height': "".concat(control.value).concat(this.getUM(), "!important")
                        });
                      };

                      controls['SectionHeight'].update = function ($element) {
                        var value = parseInt($element.css('min-height'));
                        this.setValue(value || 0);
                        this.$el.toggleClass('tcb-disabled', !self.section.isVisible() || self.section.type === 'sidebar' && sidebar().isOffScreen());
                      };

                      controls['VerticalPosition'].change = function ($element, control) {
                        var css = {
                          'justify-content': control.dataset.value,
                          'display': 'block',
                          'flex-direction': ''
                        };

                        if (control.dataset.value !== '') {
                          css['display'] = 'flex';
                          css['flex-direction'] = 'column';
                        }

                        this.applyElementCss(css);
                      };

                      controls['VerticalPosition'].update = function ($element) {
                        this.setActive($element.css('justify-content'));
                        this.$el.toggleClass('tcb-disabled', !self.section.isVisible());
                      };
                    },
                    after_update: function after_update() {
                      var isStatic = !this.section.isDynamic(),
                          inSectionEditMode = this.section.inEditMode(),
                          isSidebarOrContent = this.section.type === 'sidebar' || this.section.type === 'content';
                      this.controls['PageMap'].$el.toggle(!inSectionEditMode);
                      this.controls['LayoutVisibility'].$el.toggle(!inSectionEditMode);
                      /* only content and sidebar sections can be reversed and have min width */

                      this.controls['Position'].$el.toggle(this.section.type === 'sidebar');
                      this.controls['MinWidth'].$el.toggle(isSidebarOrContent && (inSectionEditMode || isStatic));
                      /* only top and bottom sections can control their content width */

                      this.controls['InheritContentSize'].$el.toggle(!isSidebarOrContent && !inSectionEditMode);
                      this.controls['ContentWidth'].$el.toggle(!isSidebarOrContent &&
                      /* only for top and bottom section */
                      !inSectionEditMode &&
                      /* show it always for static section, or in section edit mode for dynamic sections */
                      !this.section.inheritsContent()
                      /* show it only when we don't inherit content size */
                      );
                      this.controls['StretchContent'].$el.toggle(!inSectionEditMode && !isSidebarOrContent && (this.section.hasFullWidthBackground() || Layout.isFullWidth()) && !this.section.inheritsContent());
                      /* ony top and bottom sections can get outside of the container */

                      this.controls['StretchBackground'].$el.toggle(!isSidebarOrContent && !inSectionEditMode);
                      /* hide the visibility options for the content section */

                      this.controls['Visibility'].$el.toggle(!isSidebarOrContent && !inSectionEditMode || this.section.type === 'sidebar');
                      /*Display SectionHeight and VerticalPosition only for sections(while in edit mode or when the section is not saved as template) */

                      this.controls['SectionHeight'].$el.toggle(inSectionEditMode || isStatic);
                      this.controls['VerticalPosition'].$el.toggle(inSectionEditMode || isStatic);
                      this.sectionSelect.update();
                    }
                  });
                }
              },
              "constants.js": function constantsJs(exports, module, require) {
                var searchDynamicSelectors = ['.search-submit .thrv_icon', '.search-submit .tcb-button-text.thrv-inline-text'],
                    commentsDynamicSelectors = ['.comment-form-submit .thrv_icon', '.comment-form-submit .tcb-button-text.thrv-inline-text', '.comment-reply-link .thrv_icon', '.comment-reply-link .tcb-button-text.thrv-inline-text'],
                    textDynamicSelectors = ['.comment-form-reply-title', '.comment-form-comment-notes'],
                    dynamicVideo = {
                  placeholderTemplate: 'theme-main/video-overlay-placeholder',
                  RESPONSIVE_VIDEO_CONTAINER: '.tve_responsive_video_container',
                  THUMBNAIL_UPLOAD_BUTTON_CLASS: '.tve-video-thumbnail-control',
                  THUMBNAIL: {
                    STATIC: 'static',
                    DYNAMIC: 'dynamic',
                    NONE: 'none'
                  }
                },
                    identifiers = {
                  EDITOR_CLASS: 'ttb-editor-page',
                  FLIP_SECTIONS_CLASS: 'flip-sections',
                  HIDE_SECTION_CLASS: 'hide-section',
                  MAIN_COLUMNS_SEPARATOR: '.main-columns-separator'
                },
                    taxonomyShortcodes = ['thrive_archive_name', 'thrive_archive_description', 'thrive_archive_parent_name'];
                module.exports = {
                  identifiers: identifiers,
                  templates: {
                    error404: 'error404',
                    ARCHIVE: 'archive',
                    ARCHIVE_BASE: 'archive-base',
                    BLOG: 'blog',
                    PAGE: 'page',
                    POST: 'post',
                    SEARCH: 'search',
                    AUTHOR: 'author',
                    SINGULAR: 'singular',
                    HOME: 'home',
                    PRODUCT: 'product',
                    CART: 'cart',
                    CHECKOUT: 'checkout',
                    ACCOUNT: 'account'
                  },
                  theme_button: {
                    layout: 'button_layout'
                  },
                  blog_list: {
                    no_results: {
                      type: 'no_results',
                      selector: '.main-no-results',
                      affected_selectors: '.tcb-post-list#main,.tcb-pagination,.tcb-featured-list'
                    },
                    states: [{
                      value: 'blog_list',
                      label: 'Search results found'
                    }, {
                      value: 'no_results',
                      label: 'No results found'
                    }]
                  },
                  comments: {
                    /**
                     * Returns the Comments Element EDIT MODE states
                     */
                    states: [{
                      value: 'logged',
                      label: 'Logged In User View'
                    }, {
                      value: 'visitor',
                      label: 'Visitor View'
                    }, {
                      value: 'closed',
                      label: 'Comments are Closed'
                    }],

                    /**
                     * Returns the Comments Element EDIT MODE hidden elements
                     */
                    hiddenElements: ['thrive_author_box', 'thrive_author_links', 'thrive_breadcrumbs', 'thrive_calendar_widget', 'thrive_widget_area', 'thrive_comments', 'thrive_dynamic_list', 'post_author_picture', 'post_content', 'post_thumbnail', 'contentblock', 'symbol', 'post_list', 'ct_symbol', 'tl_shortcode', 'quiz', 'ultimatum_countdown', 'ovation_capture', 'ovation_display', 'tcb_post_author_bio', 'thrive_author_follow', 'tcb_post_author_name', 'tcb_post_author_picture', 'tcb_post_categories', 'tcb_post_content', 'tcb_post_published_date', 'tcb_post_comments_number', 'tcb_post_tags', 'tcb_post_featured_image', 'tcb_post_title', 'tcb_post_read_more', 'thrive_post_meta']
                  },
                  search_dynamic_selectors: searchDynamicSelectors,
                  text_dynamic_selectors: textDynamicSelectors,
                  dynamic_selectors: [].concat(searchDynamicSelectors, commentsDynamicSelectors),
                  dynamicVideo: dynamicVideo,
                  taxonomyShortcodes: taxonomyShortcodes,

                  /* 55 is the default number of words to be trimmed for the excerpt */
                  DEFAULT_EXCERPT_WORDS: 55,
                  DEFAULT_READ_MORE: '...',
                  content_switch: {
                    blog_index_text: 'Blog Index'
                  },
                  COMMENT_SUBMIT_TYPE: 'thrive_comments_form_submit',
                  COMMENT_REPLY_TYPE: 'thrive_comment_reply_button',
                  SIDEBAR_CROPPED_HEIGHT: 600,
                  SIDEBAR_MAXIMUM_PREVIEW_WIDTH: 298,
                  HORIZONTAL_LAYOUT_WIDTH: 700,
                  HORIZONTAL_LAYOUT_PADDING: 60,
                  VERTICAL_LAYOUT_WIDTH: 350,
                  VERTICAL_LAYOUT_PADDING: 52,
                  defaultPreviewOptions: {
                    'imageTypeCallback': 'toJpeg',
                    'quality': 1.0,
                    'fixWindowWidth': false,
                    'bgcolor': 'white',
                    'style': {
                      top: 0,
                      left: 0,
                      right: 0,
                      bottom: 0
                    }
                  },
                  PREVIEW_SECTION_WRAPPER_CLASS: 'preview-section-cloned-content',
                  PREVIEW_TEMPLATE_WRAPPER_CLASS: 'preview-template-cloned-content',
                  THEME_SKIN_COLOR_VARIABLE_PREFIX: '--tcb-skin-color-',
                  THEME_CONTEXT: 'ttb',
                  ARCHITECT_CONTEXT: 'tar',
                  WOO_ELEMENTS: ['shop', 'product', 'cart', 'checkout', 'account'],

                  /* Overlay changes when the section is smaller than the initial design */
                  NORMAL_OVERLAY_MIN_HEIGHT: 106,
                  SMALL_OVERLAY_MIN_HEIGHT: 52,
                  SMALL_OVERLAY_MIN_WIDTH: 236
                };
              },
              "content.js": function contentJs(exports, module, require) {
                (function ($) {
                  var Content = require('./models/content'),
                      Section = require('./models/section'),
                      HFSection = require('./models/hf-section');

                  var sectionsContent = {},
                      hfSectionsContent = {};
                  ['top', 'content', 'sidebar', 'bottom'].forEach(function (type) {
                    return sectionsContent[type] = "".concat(Section.identifier, ".").concat(type, "-section ").concat(Section.contentSelector);
                  });
                  ['header', 'footer'].forEach(function (type) {
                    return hfSectionsContent[type] = "".concat(type, ".thrv_symbol ").concat(HFSection.contentSelector);
                  });
                  module.exports = {
                    /**
                     * Save template content
                     *
                     * @param callback
                     * @param silent
                     * @param generatePreview
                     */
                    save: function save(callback) {
                      var silent = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
                      var generatePreview = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

                      if (!silent) {
                        TVE.main.overlay();
                      }

                      var content = new Content(TVE.Theme.$wrapper);
                      TVE.do_action('theme.update_template.before');
                      var xhr = $.ajax({
                        url: "".concat(TVE.CONST.theme.routes.templates, "/").concat(TVE.CONST.post.ID),
                        type: 'POST',
                        data: {
                          action: 'update_template',
                          template: JSON.stringify(TVE.apply_filters('theme.update_template', content.data()))
                        },
                        headers: {
                          'X-WP-Nonce': TVE.CONST.rest_nonce
                        }
                      }).done(function (response) {
                        if (!silent) {
                          TVE.page_message("Template <b>".concat(TVE.CONST.post.post_title, "</b> saved successfully!"), false, 5000);
                        }

                        window.onbeforeunload = null;

                        if (typeof callback === 'function') {
                          callback(response);
                        }
                      }).fail(function (response) {
                        if (!TVE.wordfenceResponse(response)) {
                          TVE.page_message('Template was not saved', true, 5000);
                        }
                      }).always(function () {
                        TVE.main.overlay('close');
                        TVE.Editor_Page.disableSaveWarning();
                        TVE.Editor_Page.enableSaveWarning();
                        TVE.do_action('theme.update_template.after', silent, generatePreview);
                      });

                      if (generatePreview) {
                        /* generate and save a preview for this template and this content */
                        setTimeout(this.previewSavedTemplate, 10);
                      }

                      return xhr;
                    },

                    /**
                     * Mark all shortcodes and set the selector for them
                     */
                    init_selectors: function init_selectors($wrapper) {
                      if (typeof $wrapper === 'undefined') {
                        $wrapper = TVE.Theme.$wrapper;
                      }
                      /**
                       * All the shortcodes receive the 'tcb-shortcode' class.
                       * If a shortcode is inside the post list, it also gets the 'tcb-post-list-shortcode' class.
                       * If a shortcode is outside the post list, it gets the 'thrive-shortcode' class, and other stuff for theme elements.
                       */


                      _.each(TVE.Theme.selectors.shortcodes, function (shortcode, identifier) {
                        $wrapper.find(identifier).addBack(identifier).each(function (index, element) {
                          var $element = $(element),
                              $postList = $element.closest(TVE.identifier('post_list'));

                          if ($postList.length) {
                            /* if this element is inside a post-list, add different classes */
                            TVE.PostList.content.initShortcode($postList, identifier, shortcode);
                          } else {
                            if ($element.parents('.thrv_text_element, .thrv_heading').length === 0) {
                              element.classList.add(TVE.PostList.constants.TCB_SHORTCODE_CLASS, 'thrive-shortcode', 'thrv_wrapper');
                              element.setAttribute('data-shortcode', shortcode);
                              /* unique shortcodes that are not the same everywhere */

                              if (TVE.Elements[shortcode] && TVE.Elements[shortcode].has_selector) {
                                element.setAttribute('data-selector', identifier);
                              }
                            }

                            if (TVE.Theme.template.isSingular() && TVE.Theme.CONST && $element.find('.theme-empty-post-content-placeholder').length === 0) {
                              TVE.PostList.content.replaceShortcodeWithData(shortcode, $element, TVE.Theme.CONST.ID);
                            }
                          }
                        });
                      });

                      if (TVE.CONST.symbol_type === '' && TVE.CONST.theme.is_theme_template) {
                        [TVE.Theme.$sections.header, TVE.Theme.$sections.footer].forEach(function ($element) {
                          var section = TVE.Theme.models.HFSection.getInstance($element),
                              classes = ['tcb-shortcode', 'thrive-shortcode', 'tve_no_icons'];
                          $element.addClass(classes.join(' ')).attr({
                            'draggable': false,
                            'data-tcb-elem-type': section.type,
                            'data-element-name': TVE.ucFirst(section.type)
                          });
                          section.updateAttr();
                        });
                      }
                      /**
                       * Custom Menu selectors need to be updated
                       */


                      TVE.Components.menu.setDataSelectors();

                      _.each(TVE.Theme.selectors.editor.have_selector, function (selector) {
                        $wrapper.find(selector).addBack(selector).addClass('thrv_wrapper').attr('data-selector', selector);
                      });

                      _.each(TVE.Theme.constants.text_dynamic_selectors, function (selector) {
                        $wrapper.find(selector).attr('data-selector', selector);
                      });

                      if (TVE.Theme.$wrapper) {
                        TVE.Theme.$wrapper.attr('data-selector', '#wrapper');
                      }

                      TVE.Theme.selectors.editor.no_drag.forEach(function (selector) {
                        return $wrapper.find(selector).addBack(selector).removeClass('tve-droppable');
                      });
                      TVE.do_action('theme.selectors.init', $wrapper);
                    },

                    /**
                     * Callback for the 'tcb.get_dropzone_target' and 'tcb.change_target' filters.
                     *
                     * Returns a changed dropzone target in these cases:
                     * - if we are in post list edit mode, nothing happens here - the case is treated somewhere else: components/post-list/utils.js
                     * - if a section or something inside a section is selected, return the last child;
                     * - if a section (or more) exist in the page, return the last child (priority order: content, top, sidebar, bottom)
                     * If none of the cases above match, return the $target parameter unchanged.
                     *
                     * @param $target
                     * @returns {*}
                     */
                    getSectionDropzoneTarget: function getSectionDropzoneTarget($target) {
                      /* check if we're on a theme template that is not 404 and if the element to be added was clicked in the sidebar */

                      /* if any of these conditions is not true, return without changes */
                      if (!TVE.CONST.theme.is_theme_template || typeof TVE.FLAGS.$dragged_element !== 'undefined') {
                        return $target;
                      }

                      var $targetSection,
                          $editModeElement = TVE.main.EditMode.element();

                      if ($editModeElement && $editModeElement.length) {
                        /* if we're editing a section, then we drop it there */
                        if (TVE.Theme.models.Section.is($editModeElement) || TVE.Theme.models.HFSection.is($editModeElement)) {
                          $targetSection = $editModeElement;
                        }
                      } else {
                        /* otherwise, we look for a section that is "available" */
                        $targetSection = TVE.Theme.utils.getDropTargetSection();
                      }

                      if ($targetSection && $targetSection.length) {
                        var section = TVE.Theme.utils.getSectionInstance($targetSection),
                            $sectionChildren = section.$content.children();
                        /* if the inner section is not empty, find the last child of the section and use it as the drop target */

                        if ($sectionChildren.length) {
                          $target = $sectionChildren.last();
                        } else {
                          /* add this div just so we can insert the element near it. destroy it after */
                          $target = TVE.inner_$('<div></div>').appendTo(section.$content);
                          setTimeout(function () {
                            $target.remove();
                          }, 100);
                        }
                      }

                      return $target;
                    },

                    /**
                     * Generate and save a preview for the given content and template.
                     * By default, the content is the entire template content, and the ID is the current template.
                     * @param $content
                     * @param templateId
                     */
                    previewSavedTemplate: function previewSavedTemplate() {
                      var $content = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : TVE.inner.$body;
                      var templateId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : TVE.CONST.post.ID;

                      var $contentToPreview = TVE.Theme.content.getTemplateContentToPreview(),
                          options = _objectSpread({}, TVE.Theme.constants.defaultPreviewOptions, {}, {
                        'quality': 0.1
                      });

                      TVE.generateElementPreview($contentToPreview, function (image) {
                        $contentToPreview.parent(".".concat(TVE.Theme.constants.PREVIEW_TEMPLATE_WRAPPER_CLASS)).remove();
                        var previewArgs = {
                          'url': "".concat(TVE.CONST.theme.routes.templates, "/").concat(templateId, "/preview"),
                          'action': 'template_preview',
                          'image': image,
                          'ID': TVE.CONST.post.ID
                        };
                        TVE.Theme.utils.savePreviewImage(previewArgs);
                      }, $.extend(true, {}, options), true);
                    },

                    /**
                     * Create a clone of the template and remove the elements that do not fit in the preview.
                     *
                     * @return {*}
                     */
                    getTemplateContentToPreview: function getTemplateContentToPreview() {
                      var $template = TVE.inner.$body,

                      /* keep the function locally since we'll call this lots of times */
                      filterContentFn = TVE.Theme.utils.filterContentByHeight;
                      var $filteredContent = $template.clone(),
                          maxHeight = this.getTemplatePreviewHeight();
                      /* clean filtered content at this point */

                      TVE.Theme.utils.filterContentToPreview($filteredContent);
                      $filteredContent.find('.section-overlay-actions').remove();
                      $filteredContent.children(':not(#wrapper):not(style)').remove().end();
                      TVE.Theme.utils.fixClonedImageHeights($filteredContent, $template);
                      /**
                       * Only insert it after all stuff has been removed from it - avoid any extra layout repaint, etc
                       */

                      $filteredContent.wrap("<div class=\"".concat(TVE.Theme.constants.PREVIEW_TEMPLATE_WRAPPER_CLASS, "\">")).parent().css({
                        position: 'absolute',
                        top: '-100000px',
                        left: 0,
                        right: 0,
                        'margin-left': 'auto',
                        'margin-right': 'auto'
                      }).insertAfter($template);
                      /* process the header and the top section together */

                      var $headerAndTop = $filteredContent.find("".concat(hfSectionsContent['header'], ", ").concat(sectionsContent['top']));
                      maxHeight = filterContentFn($headerAndTop, maxHeight);
                      /* the content + sidebar are usually parallel, so the height has to be reset after going through one 'column' */

                      var contentHeight = maxHeight,
                          sidebarHeight = maxHeight;
                      /* process the content section */

                      contentHeight = filterContentFn($filteredContent.find("".concat(sectionsContent['content'])), contentHeight);
                      /* if the content is wrapped ( the sidebar is under the content ), the height is not reset */

                      if (parseInt(TVE.Theme.$main.attr('data-wrap')) === 1) {
                        sidebarHeight = contentHeight;
                      }
                      /* process the sidebar section */


                      sidebarHeight = filterContentFn($filteredContent.find("".concat(sectionsContent['sidebar'])), sidebarHeight);
                      /* this is done in order to avoid the bottom section overlapping the content/sidebar */

                      maxHeight = Math.min(contentHeight, sidebarHeight);
                      /* process the bottom section */

                      maxHeight = filterContentFn($filteredContent.find("".concat(sectionsContent['bottom'])), maxHeight);
                      /* process the footer */

                      maxHeight = filterContentFn($filteredContent.find("".concat(sectionsContent['footer'])), maxHeight);
                      /* if clone height < clone width, give it the width value to make it 1 x 1 */

                      if (maxHeight > 0) {
                        $filteredContent.height($template.width());
                      }

                      return $filteredContent;
                    },

                    /**
                     * The template screenshot that we're generating is 1x1, so height = width
                     * @return {*}
                     */
                    getTemplatePreviewHeight: function getTemplatePreviewHeight() {
                      return TVE.inner.$body.width();
                    },
                    renderers: function renderers() {
                      var renderers = {
                        thrive_taxonomy_term_description: {
                          render_default: function render_default() {
                            return TVE.Theme.CONST.archive_description;
                          }
                        },
                        thrive_breadcrumbs: {
                          render_default: function render_default() {
                            var $breadcrumbs = TVE.inner_$("<div>".concat(TVE.inner_$('#tve-theme-thrive_breadcrumbs').html(), "</div>"));
                            Object.keys(TVE.CONST.theme.breadcrumbs_labels).filter(function (key) {
                              return TVE.Components.thrive_breadcrumbs.controls["".concat(key, "Label")];
                            }).forEach(function (key) {
                              /* sync breadcrumbs labels with the latest ones */
                              TVE.Components.thrive_breadcrumbs.controls["".concat(key, "Label")].onInput($breadcrumbs, {
                                value: TVE.CONST.theme.breadcrumbs_labels[key]
                              });
                            });
                            return $breadcrumbs.html();
                          }
                        }
                      };
                      ['thrive_comments', 'product-template', 'shop-template', 'account-template', 'cart-template', 'checkout-template'].forEach(function (renderer) {
                        renderers[renderer] = {
                          render_default: function render_default() {
                            return TVE.inner_$("#tve-theme-".concat(renderer)).html();
                          }
                        };
                      });
                      return renderers;
                    },

                    /**
                     * Set the resize handle at the middle of the gutter.
                     * Move the west one a little more to the left and the other one to right
                     * @param gutter
                     */
                    updateResizeHandlersPosition: _.debounce(function (gutter) {
                      if (typeof gutter === 'undefined') {
                        gutter = TVE.Theme.$wrapper.find(TVE.Theme.constants.identifiers.MAIN_COLUMNS_SEPARATOR).width();
                      }

                      gutter = parseInt(gutter);

                      if (gutter) {
                        TVE.Theme.$sections.sidebar.find('.ui-resizable-w').css('left', -(gutter / 2 + 3) + 'px');
                        TVE.Theme.$sections.sidebar.find('.ui-resizable-e').css('right', -(gutter / 2 + 3) + 'px');
                      }
                    }, 100)
                  };
                })(jQuery);
              },
              "controls": {
                "section-select.js": function sectionSelectJs(exports, module, require) {
                  module.exports = TVE.Views.Base.control.extend({
                    template: TVE.tpl('theme-main/controls/section-select'),

                    /**
                     * Update template html depending on the section
                     */
                    update: function update() {
                      if (this.section.inEditMode() || !this.section.isVisible()) {
                        this.$el.hide();
                      } else if (!this.section.generatingPreview()) {
                        this.$el.show().html(TVE.$(this.template({
                          section: this.section
                        })));
                      }
                    },
                    setSection: function setSection(section) {
                      this.section = section;
                      return this;
                    },

                    /**
                     * We can have different components for different sections
                     *
                     * @param component
                     * @returns {exports}
                     */
                    setSectionComponent: function setSectionComponent(component) {
                      this.sectionComponent = component;
                      return this;
                    },
                    change: function change() {
                      /* Everyone thinks of changing the world, but no one thinks of changing himself. */
                    },
                    unlinkSection: function unlinkSection() {
                      this.section.unlink();
                      this.update(this.section);
                    },
                    enterEditMode: function enterEditMode() {
                      if (this.section instanceof TVE.Theme.models.Section) {
                        TVE.main.EditMode.enter(false, {
                          can_insert_elements: true,
                          show_default_message: true,
                          show_overlay: true
                        });
                        this.sectionComponent.after_update();
                        this.section.toggleComponents();
                      } else {
                        var sectionType = this.section.type;

                        if (typeof TVE.Components[sectionType].editSection === 'function') {
                          TVE.Components[sectionType].editSection();
                        }

                        TVE.Components['theme-hf'].before_update().after_update();
                      }
                    },
                    getComponentColor: function getComponentColor() {
                      return this.el.closest('.tve-component').getAttribute('data-view') === 'LandingpageSection' ? 'green' : 'blue';
                    },

                    /**
                     * While the preview is being changed, display a loader over this container and disable the replace button.
                     * The 'Replace' is being disabled because the lightbox requires the section previews, so it has to wait for the new preview.
                     */
                    showPreviewLoader: function showPreviewLoader() {
                      this.$('.section-preview').addClass('ttd-loading medium-small');
                      this.$('[data-fn="replaceSection"]').prop('disabled', true);
                    },
                    openSaveModal: function openSaveModal() {
                      TVE.Theme.modals.sectionSave.open({
                        section: this.section
                      });
                    },
                    openSectionsModal: function openSectionsModal() {
                      if (TVE.Components.theme_section) {
                        TVE.Components.theme_section.tooltip.dismiss();
                      }

                      var promise = this.section.constructor.fetchListFromCloud(this.section.type).fail(console.warn);
                      TVE.Theme.modals.sectionTemplates.open({
                        section: this.section,
                        sectionsLoaded: promise
                      });
                    }
                  });
                }
              },
              "filters": {
                "common-section.js": function commonSectionJs(exports, module, require) {
                  var Section = require('../models/section'),
                      OffScreenSidebar = require('../../../frontend/models/sidebar/off-screen')(TVE.inner_$),
                      LPSection = require('../../../landingpage/models/lp-section');

                  (function ($) {
                    /**
                     * Here we will have filters that are common both for theme-sections and also for landing page sections
                     */
                    module.exports = {
                      /**
                       * When clicking an element inside a dynamic section that's not in edit mode, select the section
                       *
                       * @param {jQuery} $element
                       * @param event
                       * @return {*}
                       */
                      'tcb.selection.element': function tcbSelectionElement($element, event) {
                        /* the sidebar trigger is inside the section but we want to select it even if the section is not in edit mode */
                        if ((TVE.CONST.landing_page || TVE.CONST.theme.is_theme_template) && !$element.is(TVE.identifier('sidebar-trigger'))) {
                          var sectionInstance = TVE.Theme.utils.getSectionInstance($element);

                          if (sectionInstance && sectionInstance.isDynamic() && !sectionInstance.inEditMode()) {
                            $element = sectionInstance.$element;
                          }
                        }

                        return $element;
                      },

                      /**
                       * When selecting a section, show icons relative to the content
                       *
                       * @param {jQuery} $target
                       * @returns {this | void | *}
                       */
                      'tcb.show_icons.target': function tcbShow_iconsTarget($target) {
                        if ($target.is(Section.identifier + ', ' + LPSection.identifier)) {
                          $target = $target.addClass('edit_mode').find(' > div ').removeClass('edit_mode').filter('.section-background');
                        } else if ($target.hasClass('section-content')) {
                          $target = $target.removeClass('on_hover active_highlight ').siblings('.section-background').addClass('on_hover active_highlight ');
                        } else if ($target.hasClass('main-content-background') && $target.hasClass('edit_mode')) {
                          $target.removeClass('edit_mode').parents('#content').addClass('edit_mode');
                        } else if ($target.attr('id') === 'content') {
                          $target = $target.addClass('edit_mode').find('.main-content-background').removeClass('edit_mode');
                        }

                        return $target;
                      },

                      /**
                       * If the jumplink target is the section background or the section content, change the target to the main section container ( which contains the ID )
                       *
                       * @param {jQuery} $element
                       * @return {*}
                       */
                      'tcb.jumplinks.change_target': function tcbJumplinksChange_target($element) {
                        if ($element.is("".concat(Section.backgroundSelector, ", ").concat(Section.contentSelector))) {
                          $element = $element.parent();
                        }

                        return $element;
                      },

                      /**
                       * Block dragenter for certain types of elements.
                       *
                       * @param {Boolean} bubble
                       * @param event
                       * @returns {*}
                       */
                      'tcb.dragenter.bubble': function tcbDragenterBubble(bubble, event) {
                        var $target = $(event.target),
                            section = TVE.Theme.utils.getSectionInstance($target);
                        /* if the target is a section or section content / background, check if we should allow drag-enter */

                        if (section && (section.constructor.is($target) || section.isContent($target) || section.isBackground($target))) {
                          /* if the content is not empty the user has to DRAG-ENTER a specific element from that section */
                          if (section.$content.children(":not(".concat(OffScreenSidebar.closeIconSelector, ")")).length) {
                            bubble = false;
                          } else if (section.isDynamic() && !section.inEditMode()) {
                            /* if the content is empty and the section is dynamic and not in edit mode, prevent dragenter */
                            bubble = false;
                          }
                        }
                        /* we can't drag and drop elements near HFs or near the HF inner wrappers ( thrive-symbol-shortcode / thrive-shortcode-html ) */


                        if (TVE.Theme.models.HFSection.is($target) || TVE.Theme.models.HFSection.is($target.parent())) {
                          bubble = false;
                        }

                        return bubble;
                      },

                      /**
                       * Containers should allow elements to be inserted inside them
                       *
                       * @param {Boolean} allow
                       * @param {jQuery} $element
                       */
                      'tcb.allow_drop_near': function tcbAllow_drop_near(allow, $element) {
                        /* you can't drop things near the sections, only inside. */
                        if ($element.hasClass('section-content')) {
                          allow = false;
                        }

                        return allow;
                      },

                      /**
                       * This is checked when saving/updating a symbol that contains a post list ( see the post-list 'tcb_filter_html_before_save' ),
                       * We don't want to do this when saving sections
                       *
                       * @param {Boolean} allow
                       * @param {jQuery} $content
                       * @return {*}
                       */
                      'tcb.post_list.add_linked_elements': function tcbPost_listAdd_linked_elements(allow, $content) {
                        if ($content.is(TVE.Theme.models.Section.contentSelector)) {
                          allow = false;
                        }

                        return allow;
                      },

                      /**
                       * Change css variable prefix on write to make sure that new value is properly add
                       * Default is [data-css] for custom cases: symbols/sections/global styles we need to prefix it to properly work on all pages
                       *
                       * @param {String} selector
                       * @param {jQuery} $element
                       * @returns {String}
                       */
                      'tve.css_variable.selector|20': function tveCss_variableSelector20(selector, $element) {
                        var section = TVE.Theme.utils.getSectionInstance($element);

                        if (section && $element.closest(section.$element).length && !selector.includes(section.selector)) {
                          /**
                           * For saved sections use their selector
                           */
                          if (section.ID) {
                            selector = "".concat(section.selector, " ").concat(selector);
                          } else {
                            selector = "".concat(TVE.Theme.CONST.body_class, " ").concat(section.baseSelector, " ").concat(selector);
                          }
                        }

                        return selector;
                      }
                    };
                  })(jQuery);
                }
              },
              "modals": {
                "section-save.js": function sectionSaveJs(exports, module, require) {
                  module.exports = TVE.modal.base.extend({
                    after_initialize: function after_initialize() {
                      this.$sectionName = this.$('.new-section-name');
                      this.$sectionType = this.$('.new-section-type');
                      this.$imageContainer = this.$('.section-preview-image');
                      this.$image = this.$imageContainer.find('img');
                    },
                    before_open: function before_open(args) {
                      this.section = args.section;
                      var sectionType = TVE.ucFirst(this.section.type);
                      this.$section = this.section.$element;
                      this.$sectionName.val("Custom ".concat(TVE.ucFirst(this.section.type), " Section")).trigger('focus');
                      this.$sectionType.html(sectionType);
                      /* add an extra class if this section is sidebar / content, so we can style it differently */

                      this.$el.toggleClass('vertical-sections', this.section.isVertical());
                      this.beforeImageLoad();
                    },

                    /**
                     * Generate a preview for the content of this section without sending a request to the backend
                     */
                    after_open: function after_open() {
                      var _this2 = this;

                      setTimeout(function () {
                        var $contentToPreview = _this2.section.getContentToPreview();

                        TVE.generateElementPreview($contentToPreview, function (image) {
                          $contentToPreview.parent(".".concat(TVE.Theme.constants.PREVIEW_SECTION_WRAPPER_CLASS)).remove();

                          _this2.afterImageLoad(image);
                        }, TVE.Theme.constants.defaultPreviewOptions, true);
                      }, 10);
                    },

                    /**
                     * Add a loading spinner before the image is loaded.
                     * Calculate the dimensions of the image and apply them to the container to simulate lazy loading.
                     */
                    beforeImageLoad: function beforeImageLoad() {
                      var width = this.$section.outerWidth(true);
                      var lazyLoadWidth, lazyLoadHeight;

                      if (this.section.isHorizontal()) {
                        lazyLoadWidth = TVE.Theme.constants.HORIZONTAL_LAYOUT_WIDTH - TVE.Theme.constants.HORIZONTAL_LAYOUT_PADDING;
                        /* calculate the height of the image relative to the image ratio ( H/W ) */

                        lazyLoadHeight = this.$section.outerHeight(true) * lazyLoadWidth / width;
                      } else {
                        lazyLoadWidth = TVE.Theme.constants.VERTICAL_LAYOUT_WIDTH - TVE.Theme.constants.VERTICAL_LAYOUT_PADDING;
                        lazyLoadHeight = TVE.Theme.constants.SIDEBAR_CROPPED_HEIGHT;
                      }

                      this.$imageContainer.addClass('ttd-loading-spinner')
                      /* temporarily add the width and height that we calculated in order to simulate the lazy load */
                      .css({
                        'height': lazyLoadHeight + 'px',
                        'width': lazyLoadWidth + 'px'
                      });
                      this.$image.attr('src', this.$image.attr('data-loading-src'));
                    },

                    /**
                     * After the load finished, remove the loading spinner and the css that we added for the lazy loading.
                     *
                     * @param src
                     */
                    afterImageLoad: function afterImageLoad(src) {
                      this.$imageContainer.removeClass('ttd-loading-spinner')
                      /* remove the width and height since the image has dimensions now */
                      .css({
                        'height': '',
                        'width': ''
                      });
                      this.$image.attr('src', src);
                      /* save this so we don't have to generate it again */

                      this.section.previewImage = src;
                    },
                    save: function save() {
                      var _this3 = this;

                      /* only save if there isn't a save (ajax) event already happening */
                      if (!this.duringAjax) {
                        var title = this.$sectionName.val();

                        if (title) {
                          this.duringAjax = true;
                          this.section.save(title, function (response) {
                            _this3.close();
                          }).always(function () {
                            _this3.duringAjax = false;
                          });
                        } else {
                          TVE.page_message('Please enter the section title!', true, 3000);
                        }
                      }
                    }
                  });
                },
                "section-templates-block.js": function sectionTemplatesBlockJs(exports, module, require) {
                  (function ($) {
                    if (!TVE.BlockModal) {
                      /**
                       * Backwards compatibility. To ensure the compatibility with the latest version of TAR. Should be removed after some time
                       * @since 09.06.2020
                       */
                      return;
                    }

                    module.exports = TVE.BlockModal.extend({
                      blocksCollection: new Backbone.Collection({}),
                      item_template: TVE.tpl('theme-main/template-item'),
                      itemClass: '.section-template-item ',
                      filters: {
                        category: [],
                        group: [],
                        search: []
                      },
                      groupMap: {},
                      tooltipOpen: false,
                      renameInProgress: false,

                      /**
                       * Store DOM references
                       */
                      after_initialize: function after_initialize() {
                        var _this4 = this;

                        this.$content = this.$el;
                        this.$cloudMenu = this.$('#cb-cloud-menu');
                        this.$packTitle = this.$('#lp-blk-pack-title');
                        this.$packDescription = this.$('#lp-blk-pack-description');
                        this.$packContent = this.$('#cb-pack-content');
                        this.$packGroupsWrapper = this.$('#lp-groups-wrapper');
                        this.$error = this.$('.error-container').hide();
                        window.addEventListener('resize', function () {
                          _this4.windowResized = true;
                        });
                        this.initClickHandler();
                      },

                      /**
                       * Before Modal Open Function.
                       */
                      before_open: function before_open(args) {
                        this.resetFilters();
                        this.section = args.section;
                        this.$el.attr('data-columns', this.section.isHorizontal() ? 2 : 4);
                        /* clear the content */

                        this.$packContent.empty();
                        this.$section = args.section.$element;
                        this.displayName = TVE.ucFirst(this.section.type);
                        this.groupMap = {
                          cloud: {
                            /* the keys are used for filtering */
                            key: "Theme ".concat(this.displayName, " Sections")
                          },
                          local: {
                            key: "My Saved ".concat(this.displayName, " Sections")
                          }
                        };
                        this.$packTitle.text("".concat(this.displayName, " Sections"));
                        this.$packDescription.text("".concat(this.displayName, " Sections available for the current theme."));
                        this.$el.addClass('loading');
                        this.$('.tve-modal-content').attr('class', "tve-modal-content tpl-".concat(this.section.type));
                      },

                      /**
                       * Close the options tooltip when clicking outside it.
                       */
                      initClickHandler: function initClickHandler() {
                        var _this5 = this;

                        this.$el.on('click', function (event) {
                          var $target = $(event.target);

                          if (_this5.tooltipOpen && $target.closest('.tcb-template-options-tooltip, .ttd-dropdown-dots').length === 0) {
                            _this5.closeOptionsTooltip();
                          } else if (_this5.renameInProgress && $target.closest('.template-name-section-edit, .tcb-template-options-tooltip').length === 0) {
                            /* if we click outside the rename input field while it's open, trigger a section name save */
                            _this5.triggerRename();
                          }
                        });
                      },

                      /**
                       * If we find a section that is being edited, trigger the renameSection() on it by doing a click
                       */
                      triggerRename: function triggerRename() {
                        var $editedSection = this.$packContent.find('.section-template-edit');

                        if ($editedSection.length > 0) {
                          $editedSection.find('.template-name-check').click();
                        }
                      },

                      /**
                       * When a rename input is open and we press enter, trigger a save.
                       *
                       * @param event
                       */
                      handle_keyup: function handle_keyup(event) {
                        if (this.renameInProgress) {
                          switch (event.which) {
                            case 13:
                              this.triggerRename();
                              break;

                            case 27:
                              this.closeRename();
                              break;
                          }
                        }

                        return false;
                      },

                      /**
                       * Render after processing all the section templates.
                       */
                      after_open: function after_open(args) {
                        var _this6 = this;

                        $.when(args.sectionsLoaded).always(function () {
                          return setTimeout(function () {
                            return _this6.$el.removeClass('loading');
                          }, 80);
                        }).then(function () {
                          _this6.setSections();

                          _this6.activateFirstTab();
                          /* after we finished processing the section templates, call the original after_open which renders the templates in the modal */


                          TVE.BlockModal.prototype.after_open.call(_this6);
                        });
                      },

                      /**
                       * Reset the blocks collection with the local and cloud sections
                       */
                      setSections: function setSections() {
                        var _this$groups,
                            _this7 = this;

                        var allSections = [].concat(_toConsumableArray(this.addSourceToTemplates(TVE.Theme.data.cloud[this.section.type], 'cloud')), _toConsumableArray(this.addSourceToTemplates(TVE.Theme.data.local[this.section.type], 'local')));
                        allSections = TVE.apply_filters('theme.sections_modal.available_sections', allSections, this.section.type);
                        /* calculate the thumbnail ratio for each section */

                        allSections = this.addThumbnailRatios(allSections);
                        this.blocksCollection.reset(allSections);
                        this.groups = (_this$groups = {}, _defineProperty(_this$groups, this.groupMap['cloud']['key'], {
                          counter: _.filter(allSections, function (section) {
                            return section.source === 'cloud';
                          }).length
                        }), _defineProperty(_this$groups, this.groupMap['local']['key'], {
                          counter: _.filter(allSections, function (section) {
                            return section.source === 'local';
                          }).length
                        }), _this$groups);
                        /* re-render the groups */

                        this.$packGroupsWrapper.empty();

                        _.each(this.groups, function (group, groupKey) {
                          _this7.$packGroupsWrapper.append(_this7.group_item({
                            group: groupKey,
                            counter: group.counter
                          }));
                        });
                      },

                      /**
                       * Open the first tab ( the cloud group )
                       */
                      activateFirstTab: function activateFirstTab() {
                        /* add the cloud group to the filters so the cloud tab is automatically selected first */
                        this.filters['group'].push(this.groupMap['cloud']['key']);
                        /* add the active class to the first ( cloud ) tab */

                        this.$packGroupsWrapper.find('.lp-group').first().addClass('active');
                      },

                      /**
                       * Load a selected section and insert it into the page
                       */
                      load: function load(event, sectionEl) {
                        /* close the lightbox and show the loading directly in the content */
                        this.close();
                        var sectionId = sectionEl.dataset.id.replace(sectionEl.dataset.source[0], '');
                        this.section.load(sectionId, sectionEl.dataset.source, sectionEl.dataset.version);
                      },

                      /**
                       * @param event
                       */
                      openRename: function openRename(event) {
                        var $template = $(event.target).closest(this.itemClass);
                        $template.addClass('section-template-edit').find('.template-rename-input').focus().select();
                        this.closeOptionsTooltip();
                        this.renameInProgress = $template.attr('data-id');
                      },

                      /**
                       * Close rename template state
                       *
                       * @param {Boolean} [reset] whether or not to reset input value to current template name
                       */
                      closeRename: function closeRename() {
                        var reset = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
                        var $template = this.$(this.itemClass.trim() + "[data-id=\"".concat(this.renameInProgress, "\"]"));
                        var $input = $template.find('.template-rename-input');
                        var $name = $template.find('.template-name');
                        $template.removeClass('section-template-edit').find('.template-name-check').removeClass('ttd-loading small');

                        if (reset) {
                          $input.val($name.text());
                        } else {
                          $name.text($input.val());
                        }
                      },

                      /**
                       * @param event
                       */
                      renameSection: function renameSection(event) {
                        var _this8 = this;

                        var $target = $(event.target).closest('.template-name-check'),
                            $template = $target.closest(this.itemClass),
                            newTitle = $target.prev('.template-rename-input').val();
                        $target.addClass('ttd-loading small');

                        if (newTitle) {
                          if (!this.duringAjax) {
                            this.duringAjax = true;
                            /* we need to call something like this.section.rename(newTitle) */

                            TVE.$.ajax({
                              url: "".concat(TVE.CONST.theme.routes.sections, "/").concat($template.attr('data-id').substring(1)),
                              type: 'POST',
                              data: {
                                title: newTitle
                              },
                              headers: {
                                'X-WP-Nonce': TVE.CONST.rest_nonce
                              }
                            }).done(function (sectionId) {
                              TVE.Theme.utils.loadingMessage('Section renamed successfully!');
                              setTimeout(function () {
                                return TVE.Theme.utils.loadingMessage(false);
                              }, 1000);

                              _this8.closeRename(false);
                              /* update inside the object too */


                              var tpl = _.findWhere(TVE.Theme.data.local[_this8.section.type], {
                                id: parseInt(sectionId)
                              });

                              if (tpl) {
                                tpl.name = newTitle;
                              }
                              /* Update the name also in the component html */


                              TVE.Components.theme_section.sectionSelect.update();
                            }).always(function () {
                              _this8.duringAjax = false;
                              _this8.renameInProgress = false;
                            });
                          }
                        } else {
                          TVE.page_message('Please enter a section title!', true, 3000);
                        }
                      },

                      /**
                       * @param event
                       */
                      openDelete: function openDelete(event) {
                        var $template = $(event.target).closest(this.itemClass);
                        $template.addClass('section-template-delete')
                        /* temporarily disable clicks elsewhere on the overlay */
                        .find('.cb-template-wrapper').removeClass('click');
                        this.closeOptionsTooltip();
                      },

                      /**
                       * @param event
                       */
                      hideDelete: function hideDelete(event) {
                        $(event.target).closest(this.itemClass).removeClass('section-template-delete');
                      },

                      /**
                       * @param event
                       */
                      "delete": function _delete(event) {
                        var _this9 = this;

                        var removeButton = event.target,
                            ID = parseInt(removeButton.dataset.id.substring(1));

                        if (ID && !this.duringAjax) {
                          this.duringAjax = true;
                          this.section["delete"](ID)
                          /* add the done() and always() callbacks directly on the ajax call */
                          .done(function (sectionId) {
                            _this9.blocksCollection.remove(_this9.blocksCollection.get(ID));

                            $(removeButton).closest(_this9.itemClass).remove();
                            /* get the local template counter and update it */

                            var $counter = _this9.$packGroupsWrapper.find('.active .lp-group-count'),
                                count = parseInt($counter.text()) - 1;

                            $counter.text(count);
                            /* if the count didn't reach 0, re-apply masonry, else render the No Templates screen */

                            if (count > 0) {
                              _this9.applyMasonry();
                            } else {
                              _this9.$packContent.html(_this9.no_templates());
                            }
                          }).always(function () {
                            _this9.duringAjax = false;
                          });
                        }
                      },

                      /**
                       * @param event
                       */
                      openOptionsTooltip: function openOptionsTooltip(event) {
                        /* show the tooltip by adding a class to the row; this class is removed when clicking elsewhere in the page => the tooltip is hidden */
                        $(event.target).closest('.template-name-section').toggleClass('tooltip-open');
                        this.tooltipOpen = true;
                      },

                      /* Remove any tooltip-open classes */
                      closeOptionsTooltip: function closeOptionsTooltip() {
                        if (this.tooltipOpen) {
                          this.$packContent.find('.tooltip-open').removeClass('tooltip-open');
                          this.tooltipOpen = false;
                        }
                      },

                      /**
                       * For each template, add a source field that shows that it comes from the cloud or it's local.
                       * Also add a group field that allows the page-block filtering functionality to show the right templates in the right tabs.
                       *
                       * @param templates
                       * @param source
                       * @return {*}
                       */
                      addSourceToTemplates: function addSourceToTemplates(templates, source) {
                        var _this10 = this;

                        /* Sort templates before render */
                        templates = _.map(_.sortBy(templates, function (template) {
                          return template.order;
                        }), function (section) {
                          return _objectSpread({}, section, {
                            id: "".concat(source[0]).concat(section.id),
                            source: source,
                            group: [_this10.groupMap[source]['key']],
                            name: section.name || section.post_title // makes sure they are all treated in the same way

                          });
                        });
                        return templates;
                      },

                      /**
                       * For each template, add a ratio ( height / width ) that is used for the lazy loading.
                       * The height and width used here are the ones native to the image.
                       * Later, when the template images are displayed in the modal, the width changes, so the height is re-calculated using this ratio.
                       *
                       * @param items
                       *
                       * @return {*}
                       */
                      addThumbnailRatios: function addThumbnailRatios(items) {
                        return items.map(function (item) {
                          /* use 1 as a default value */
                          var ratio = 1;

                          if (item.thumb && item.thumb.w && item.thumb.h) {
                            var width = parseInt(item.thumb.w),
                                height = parseInt(item.thumb.h);
                            ratio = parseFloat(height / width).toFixed(3);
                          }

                          item['ratio'] = ratio;
                          return item;
                        });
                      },

                      /**
                       * Show a text in the page when no sections are found.
                       *
                       * @return {string}
                       */
                      no_templates: function no_templates() {
                        return TVE.tpl('theme-main/no-sections-available')({
                          modal: this
                        });
                      },

                      /**
                       * Activate and render the cloud tab.
                       */
                      renderFirstTab: function renderFirstTab() {
                        this.resetFilters();
                        this.activateFirstTab();
                        this.build_preview();
                      },

                      /**
                       * Get masonry options. Allows overriding
                       *
                       * @return {{gutter: string|number, columnWidth: string, isAnimated: boolean}}
                       */
                      getMasonryOptions: function getMasonryOptions() {
                        return {
                          gutter: '.tpl-gutter-sizer',
                          columnWidth: this.itemClass,
                          isAnimated: true // animate from javascript rather than CSS, because it looks messy on resize

                        };
                      }
                    });
                  })(jQuery);
                }
              },
              "models": {
                "_includes.js": function _includesJs(exports, module, require) {
                  module.exports = {
                    Content: require('./content'),
                    Layout: require('./layout'),
                    Section: require('./section'),
                    HFSection: require('./hf-section'),
                    Template: require('./template')
                  };
                },
                "abstract-section.js": function abstractSectionJs(exports, module, require) {
                  var AbstractSection =
                  /*#__PURE__*/
                  function () {
                    _createClass(AbstractSection, [{
                      key: "isHorizontal",
                      value: function isHorizontal() {
                        throw Error('Class should implement the isHorizontal function');
                      }
                    }, {
                      key: "isVertical",
                      value: function isVertical() {
                        throw Error('Class should implement the isVertical function');
                      }
                    }, {
                      key: "selector",
                      get: function get() {
                        return '';
                      }
                    }, {
                      key: "baseSelector",
                      get: function get() {
                        return '';
                      }
                    }], [{
                      key: "identifier",
                      get: function get() {
                        return '';
                      }
                    }, {
                      key: "component",
                      get: function get() {
                        throw Error('Class should implement component function');
                      }
                    }, {
                      key: "contentSelector",
                      get: function get() {
                        return '';
                      }
                    }, {
                      key: "backgroundSelector",
                      get: function get() {
                        return '';
                      }
                    }]);

                    function AbstractSection($section) {
                      _classCallCheck(this, AbstractSection);

                      this.$element = $section;
                      this.ID = parseInt(this.attr('data-id') || 0);
                      this.type = this.attr('data-section') || TVE._type($section);

                      if (TVE.Theme.data.local[this.type] && TVE.Theme.data.local[this.type][this.ID]) {
                        this.sectionData = TVE.Theme.data.local[this.type][this.ID];
                      }

                      this.setElements();
                    }
                    /**
                     * Set elements specific to the section
                     */


                    _createClass(AbstractSection, [{
                      key: "setElements",
                      value: function setElements() {
                        this.$content = this.$element.find(this.constructor.contentSelector);
                        this.$background = this.$element.find(this.constructor.backgroundSelector);
                      }
                      /**
                       * Update element attributes here
                       */

                    }, {
                      key: "updateAttr",
                      value: function updateAttr() {
                        this.$element.attr('data-selector', this.selector);

                        if (this.isDynamic()) {
                          this.$content.attr('data-selector', "".concat(this.constructor.contentSelector));
                          this.$background.attr('data-selector', "".concat(this.constructor.backgroundSelector));
                        } else {
                          this.$content.attr('data-selector', "".concat(this.baseSelector, " ").concat(this.constructor.contentSelector));
                          this.$background.attr('data-selector', "".concat(this.baseSelector, " ").concat(this.constructor.backgroundSelector));
                        }
                      }
                      /**
                       * Performed before unlinking a section
                       */

                    }, {
                      key: "beforeUnlink",
                      value: function beforeUnlink() {
                        /*
                         * Remove `data-settings-id` attribute for forms within the section that gets unlinked
                         * When saving the page/template, the IDs for form settings will get regenerated and saved.
                         */
                        if (typeof TVE.Components.lead_generation.removeSettingsId === 'function') {
                          TVE.Components.lead_generation.removeSettingsId(this.$element);
                        }
                      }
                      /**
                       * Actions to be done after unlinking a section
                       */

                    }, {
                      key: "afterUnlink",
                      value: function afterUnlink() {
                        TVE.do_action('theme.section.after_unlink', this);
                      }
                      /**
                       * Check if the current section is a saved one or not
                       * @returns {boolean}
                       */

                    }, {
                      key: "isDynamic",
                      value: function isDynamic() {
                        return !!this.ID;
                      }
                      /**
                       * Check if the current section is visible or not
                       * @returns {boolean}
                       */

                    }, {
                      key: "isVisible",
                      value: function isVisible() {
                        return !this.$element.hasClass(TVE.Theme.constants.identifiers.HIDE_SECTION_CLASS);
                      }
                      /**
                       * Toggle visibility for the section
                       * @param show
                       */

                    }, {
                      key: "toggle",
                      value: function toggle() {
                        var show = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
                        this.$element.toggleClass(TVE.Theme.constants.identifiers.HIDE_SECTION_CLASS, !show);

                        if (this.type === 'sidebar') {
                          var Sidebar = TVE.inner.window.ThriveTheme.sidebar;

                          if (Sidebar.isOffScreen()) {
                            if (show) {
                              Sidebar.offScreenRefresh();
                            } else {
                              Sidebar._get('off-screen').destroy();
                            }
                          }

                          TVE.Theme.content.updateResizeHandlersPosition();
                          TVE.PostList.layout.masonryRedo();
                        }
                        /* update the sections map */


                        this.constructor.component.controls.PageMap.update(this.$element);

                        if (this.constructor.is(TVE.ActiveElement)) {
                          /* when the active element is a section, update also the compoenent because it's visible */
                          this.constructor.component.update(TVE.ActiveElement);
                        }
                      }
                      /**
                       * Check if an element is the the content of the section
                       * @param $element
                       * @returns {boolean|*}
                       */

                    }, {
                      key: "isContent",
                      value: function isContent($element) {
                        return $element.is(this.$content);
                      }
                      /**
                       * Check if an element is the background of the section
                       * @param $element
                       * @returns {boolean|*}
                       */

                    }, {
                      key: "isBackground",
                      value: function isBackground($element) {
                        return $element.is(this.$background);
                      }
                      /**
                       * Check if the current $section is in edit mode
                       * @returns {boolean | *}
                       */

                    }, {
                      key: "inEditMode",
                      value: function inEditMode() {
                        return this.$element.hasClass('tcb-compact-edit-mode');
                      }
                      /**
                       * Checks if the sections inherits the content from the layout
                       * @returns {*|boolean}
                       */

                    }, {
                      key: "inheritsContent",
                      value: function inheritsContent() {
                        return TVE.Theme.$wrapper.tcbCss("--".concat(this.type, "-content-width")).length === 0;
                      }
                      /**
                       * Set content or background width on the css variable that will automatically be used
                       * @param width
                       * @param area {String} background or content
                       * @param writeHeadCss {Boolean} write inline or in head css
                       */

                    }, {
                      key: "setWidth",
                      value: function setWidth(width) {
                        var area = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
                        var writeHeadCss = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
                        var prop = "--".concat(this.type, "-").concat(area, "-width");

                        if (writeHeadCss) {
                          TVE.Theme.$wrapper.head_css(_defineProperty({}, prop, width));
                          TVE.Theme.$wrapper.tcbCss(prop, '');
                        } else {
                          TVE.Theme.$wrapper.tcbCss(prop, width);
                        }
                      }
                      /**
                       * Get the width of content or background
                       * @param area
                       * @returns {*|void}
                       */

                    }, {
                      key: "getWidth",
                      value: function getWidth() {
                        var area = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'content';
                        return TVE.Theme.$wrapper.tcbCss("--".concat(this.type, "-").concat(area, "-width"));
                      }
                      /**
                       * Check if the content is set to 100%
                       * @returns {boolean}
                       */

                    }, {
                      key: "hasFullWidthContent",
                      value: function hasFullWidthContent() {
                        return this.getWidth('content') === '100%';
                      }
                      /**
                       * Check if the content is set to 100%
                       * @returns {boolean}
                       */

                    }, {
                      key: "hasFullWidthBackground",
                      value: function hasFullWidthBackground() {
                        return this.getWidth('background') === '100%';
                      }
                      /**
                       * When the section starts generating a preview, add a loader until it finishes.
                       */

                    }, {
                      key: "startPreview",
                      value: function startPreview() {
                        /* add a class on the section so we can detect from elsewhere that a preview is being generated */
                        this.$element.addClass('tcb-generating-preview');
                        this.constructor.component.sectionSelect.showPreviewLoader();
                      }
                      /**
                       * When the section finished generating the preview, remove the loader and apply the URL.
                       *
                       * @param previewData
                       */

                    }, {
                      key: "applyPreview",
                      value: function applyPreview(previewData) {
                        this.$element.removeClass('tcb-generating-preview section-no-overlay');
                        /* generate and append a random string to the url to stop it from being cached */

                        previewData.url = previewData.url + '?v=' + Math.random().toString(16).slice(2);

                        if (TVE.Theme.data.local[this.type] && TVE.Theme.data.local[this.type][this.ID]) {
                          TVE.Theme.data.local[this.type][this.ID].thumb = previewData;
                        }

                        if (this.sectionData && this.sectionData.thumb) {
                          this.sectionData.thumb = previewData;
                        }
                        /* refresh the section select UI after the preview image was received */


                        this.constructor.component.sectionSelect.setSection(this).update();
                      }
                      /**
                       * Check if the current section is generating a preview.
                       * @returns {boolean | *}
                       */

                    }, {
                      key: "generatingPreview",
                      value: function generatingPreview() {
                        return this.$element.hasClass('tcb-generating-preview');
                      }
                      /**
                       * Return attr from the section element
                       * @param key
                       * @returns {*}
                       */

                    }, {
                      key: "attr",
                      value: function attr(key) {
                        return this.$element.attr(key);
                      }
                      /**
                       * Return the name of the section template or custom if it's not dynamic
                       * @returns {string}
                       */

                    }, {
                      key: "name",
                      value: function name() {
                        var name = "Unlinked ".concat(this.type);

                        if (this.sectionData) {
                          name = this.sectionData.name;
                        } else {
                          name = this.attr('data-section-name') || name;
                        }

                        return name;
                      }
                      /**
                       * For dynamic sections, return preview
                       * @returns {string}
                       */

                    }, {
                      key: "preview",
                      value: function preview() {
                        var preview = '';

                        if (this.sectionData && this.sectionData.thumb) {
                          preview = this.sectionData.thumb.url;
                        }

                        return preview;
                      }
                      /**
                       * Actions to be done after we have the id of the section and we prepare to save things
                       * @param sectionId
                       */

                    }, {
                      key: "beforeSave",
                      value: function beforeSave(sectionId) {
                        this.ID = parseInt(sectionId);
                        this.updateAttr();
                        /* convert template css into one specific for the section */

                        this.convertCssToSection();
                      }
                      /**
                       * Actions done after the section has been saved and the css and content has been updated.
                       */

                    }, {
                      key: "afterSave",
                      value: function afterSave() {
                        this.focus();
                        TVE.Theme.utils.loadingMessage(false, 'save-section');
                        this.constructor.saveTemplate(true, false);
                      }
                      /**
                       * Actions done before actually inserting the section
                       * @param section
                       */

                    }, {
                      key: "beforeInsert",
                      value: function beforeInsert(section) {
                        TVE.do_action('theme.section.before_insert', section, this);
                        TVE.do_action("theme.section.before_insert.".concat(this.type), section, this);
                        /* for static section we add the body class so we won't match css from layout */

                        var selector = (this.isDynamic() ? '' : TVE.Theme.CONST.body_class + ' ') + this.selector;
                        TVE.head_css_remove(TVE.Theme.utils.escapedRegEx(selector, 'g'), '_ALL');
                        this.ID = parseInt(section.id);
                        TVE.Theme.FLAGS.duringImport = true;
                      }
                      /**
                       * Actions done after the section has been added to the page
                       *
                       * @param section
                       */

                    }, {
                      key: "afterInsert",
                      value: function afterInsert(section) {
                        TVE.Theme.FLAGS.duringImport = false;
                        /* re-initialize the inline shortcodes */

                        TVE.froala.init();
                        this.focus();
                        TVE.Theme.content.init_selectors(this.$element);
                        this.constructor.saveTemplate(true);
                        TVE.do_action('theme.section.after_insert', section, this);
                        TVE.do_action("theme.section.after_insert.".concat(this.type), section, this);
                        TVE.Theme.utils.loadingMessage(false);
                        this.bindElementActions();
                        /* Migrate any possible old-style (font) icons from the template to the svg version */

                        TVE.inner.window.TCB_Front.icons.migrate(this.$element);
                      }
                      /**
                       * Convert specific css to general template one. Usually used when we unlink a section
                       *
                       * @param {Object | undefined } rules
                       */

                    }, {
                      key: "convertCssToTemplate",
                      value: function convertCssToTemplate(rules) {
                        if (typeof rules === 'undefined') {
                          rules = TVE.stylesheet.cssRules;
                        }

                        for (var i = 0; i < rules.length; i++) {
                          var media = TVE.compat.conditionText(rules[i]);
                          var newRules = {};

                          if (rules[i].type === CSSRule.MEDIA_RULE && media && media.length) {
                            for (var j = 0; j < rules[i].cssRules.length; j++) {
                              var currentSelector = rules[i].cssRules[j].selectorText;

                              if (currentSelector.includes(this.selector)) {
                                currentSelector = currentSelector.replace(TVE.Theme.utils.escapedRegEx("".concat(this.selector), 'g'), "".concat(TVE.Theme.CONST.body_class, " ").concat(this.baseSelector));
                                /* Give others the possibility to change the section selector */

                                currentSelector = TVE.apply_filters('theme.convert_section_selector', currentSelector);

                                if (typeof newRules[currentSelector] === 'undefined') {
                                  newRules[currentSelector] = {};
                                }

                                newRules[currentSelector] = _objectSpread({}, newRules[currentSelector], {}, TVE.CSS_Rule_Cache.cssToObject(rules[i].cssRules[j].cssText));
                                rules[i].deleteRule(j--);
                              }
                            }

                            for (var selector in newRules) {
                              TVE.head_css(selector, newRules[selector], media);
                            }
                          }
                        }
                      }
                      /**
                       * Convert general CSS to specific section one. Usually called when we create a new section from content.
                       * @param rules
                       */

                    }, {
                      key: "convertCssToSection",
                      value: function convertCssToSection(rules) {
                        if (typeof rules === 'undefined') {
                          rules = TVE.stylesheet.cssRules;
                        }

                        for (var i = 0; i < rules.length; i++) {
                          if (rules[i].type === CSSRule.MEDIA_RULE) {
                            for (var j = 0; j < rules[i].cssRules.length; j++) {
                              var rule = rules[i].cssRules[j];
                              /* exclude css that is from the layout and select only ones from the current section */

                              if (rule.selectorText.includes(this.baseSelector)) {
                                var cssText = rule.cssText.replace(TVE.Theme.utils.escapedRegEx("".concat(TVE.Theme.CONST.body_class, " ").concat(this.baseSelector), 'g'), this.selector);
                                rules[i].deleteRule(j);
                                rules[i].insertRule(TVE.remove_extra_spaces(cssText), j);
                              }
                            }
                          }
                        }
                      }
                      /**
                       * Create a clone of the section that we want to preview, and remove the elements that do not fit inside the preview.
                       *
                       * @return {*}
                       */

                    }, {
                      key: "getContentToPreview",
                      value: function getContentToPreview() {
                        var $filteredContentClone = this.$element.clone(),
                            width = this.$element.width(),
                            maxHeight = width * (this.isHorizontal() ? 1 : 2);
                        var innerWidth = width;
                        TVE.Theme.utils.fixClonedImageHeights($filteredContentClone, this.$element);
                        /* if we're previewing an off-screen sidebar that is wider than the maximum preview-able width, don't exceed it because the preview will look bad */

                        if (this.type === 'sidebar' && TVE.inner.window.ThriveTheme.sidebar.isOffScreen() && innerWidth >= TVE.Theme.constants.SIDEBAR_MAXIMUM_PREVIEW_WIDTH) {
                          innerWidth = TVE.Theme.constants.SIDEBAR_MAXIMUM_PREVIEW_WIDTH;
                        }

                        $filteredContentClone.attr('style', "display:block !important; position:absolute !important; width: ".concat(innerWidth, "px !important;")).wrap("<div class=\"".concat(TVE.Theme.constants.PREVIEW_SECTION_WRAPPER_CLASS, "\"></div>")).parent().attr('style', "position: absolute !important; top: -100000px !important; width: ".concat(width, "px !important")).insertAfter(this.$element);
                        $filteredContentClone.removeClass('edit_mode layout-highlight');
                        /* remove the resize lines because they're not needed and they can also mess up the layout */

                        $filteredContentClone.children('.ui-resizable-handle').remove();
                        TVE.Theme.utils.filterContentToPreview($filteredContentClone);
                        TVE.Theme.utils.filterContentByHeight($filteredContentClone.find(this.constructor.contentSelector), maxHeight);
                        return $filteredContentClone;
                      }
                    }, {
                      key: "toggleComponents",
                      value: function toggleComponents() {}
                      /* nothing for the moment */

                      /**
                       * Focus the section again.
                       */

                    }, {
                      key: "focus",
                      value: function focus() {
                        TVE.Editor_Page.focus_element(this.$element.removeClass('edit_mode'));
                      }
                      /**
                       * Save the template and display a message sometimes
                       * @param silent
                       * @param generatePreview
                       */

                    }, {
                      key: "delete",

                      /**
                       * Delete the section with the given ID.
                       * Returns the ajax call, so you can attach additional done(), error(), always() callbacks externally.
                       *
                       * @param ID
                       * @return {*}
                       */
                      value: function _delete(ID) {
                        var _this11 = this;

                        return TVE.$.ajax({
                          url: TVE.CONST.theme.routes.sections + '/' + ID,
                          type: 'DELETE',
                          headers: {
                            'X-WP-Nonce': TVE.CONST.rest_nonce
                          },
                          data: {
                            type: this.type
                          }
                        }).done(function () {
                          /* remove the section from the list of sections, from the collection, and from the modal */
                          delete TVE.Theme.data.local[_this11.type][ID];
                          /* if the current section is the one that is being deleted, unlink it from the template */

                          if (parseInt(_this11.ID) === parseInt(ID)) {
                            _this11.unlink(true);
                          }

                          TVE.StorageManager.set('theme_section.remove', {
                            id: ID,
                            type: _this11.type
                          });
                          TVE.Theme.utils.loadingMessage('Section deleted successfully!');
                          setTimeout(function () {
                            return TVE.Theme.utils.loadingMessage(false);
                          }, 1000);
                        }).fail(function (response) {
                          if (!TVE.wordfenceResponse(response)) {
                            TVE.page_message('Error deleting the section!', true, 3000);
                          }
                        });
                      }
                      /**
                       * Transform section into static content. Remove id and class convert the css into general template one
                       */

                    }, {
                      key: "unlink",
                      value: function unlink() {
                        throw Error('Class should implement the unlink function');
                      }
                      /**
                       * Bind all actions needed on an element on the editor page
                       *
                       * @param {JQuery} [$element] optional, element to rebind
                       */

                    }, {
                      key: "bindElementActions",
                      value: function bindElementActions() {
                        var $element = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.$element;

                        /* ensure users can drop stuff in the unlinked section */
                        TVE.drag.bind_element($element);
                      }
                    }], [{
                      key: "saveTemplate",
                      value: function saveTemplate() {
                        var silent = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
                        var generatePreview = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

                        if (!silent) {
                          TVE.Theme.utils.loadingMessage('Updating also the template!', 'save-template');
                        }

                        TVE.Theme.content.save(function () {
                          TVE.Theme.utils.loadingMessage(false, 'save-template');
                        }, true, generatePreview);
                      }
                      /**
                       * Check if a certain element is a theme section or not
                       * @param $element
                       * @returns {boolean | *}
                       */

                    }, {
                      key: "is",
                      value: function is($element) {
                        return $element.is(this.identifier);
                      }
                      /**
                       * Return the section that contains the element sent as a parameter
                       * @param $element
                       * @returns {this | any | Element}
                       */

                    }, {
                      key: "parentSection",
                      value: function parentSection($element) {
                        return $element && $element.closest(this.identifier);
                      }
                      /**
                       * Return instance of current class.
                       * When creating an instance, we can send either the exact section, or a child from that section.
                       * @param $element
                       * @returns {null|Section}
                       */

                    }, {
                      key: "getInstance",
                      value: function getInstance($element) {
                        var instance = null;

                        if (typeof $element === 'undefined') {
                          $element = TVE.ActiveElement;
                        }
                        /* we check if the element we've sent is either a section or a child of one */


                        if (this.is($element)) {
                          instance = new this($element);
                        } else {
                          $element = this.parentSection($element);

                          if ($element.length) {
                            instance = new this($element);
                          }
                        }

                        if (instance === null) {
                          throw Error("Those are not the sections you're looking for!");
                        }

                        return instance;
                      }
                      /**
                       * Return id from the template where the section is on
                       *
                       * @returns {Number}
                       */

                    }, {
                      key: "getTemplateId",
                      value: function getTemplateId() {
                        return 0;
                      }
                      /**
                       * Get all the sections from cloud
                       *
                       * @param sectionType
                       */

                    }, {
                      key: "fetchListFromCloud",
                      value: function fetchListFromCloud(sectionType) {
                        var dfd = TVE.$.Deferred();

                        if (TVE.Theme.data.cloud[sectionType]) {
                          setTimeout(function () {
                            /* cache cloud results so we don't have to get them all the time */
                            dfd.resolve(TVE.Theme.data.cloud[sectionType]);
                          }, 1);
                        } else {
                          TVE.$.ajax({
                            url: "".concat(TVE.CONST.theme.routes.sections, "/cloud"),
                            type: 'GET',
                            data: {
                              'type': sectionType,
                              'template_id': this.getTemplateId()
                            },
                            headers: {
                              'X-WP-Nonce': TVE.CONST.rest_nonce
                            }
                          }).done(function (response) {
                            if (response.success) {
                              TVE.Theme.data.cloud[sectionType] = response.data;
                              dfd.resolve(response.data);
                            } else {
                              dfd.reject('The sections could not be retrieved');
                            }
                          }).fail(function (response) {
                            if (response.responseJSON) {
                              dfd.reject(response.responseJSON.message);
                            }
                          });
                        }
                        /* This is resolved or rejected in the ajax success or error functions */


                        return dfd.promise();
                      }
                    }]);

                    return AbstractSection;
                  }();

                  module.exports = AbstractSection;
                },
                "content.js": function contentJs(exports, module, require) {
                  var Content =
                  /*#__PURE__*/
                  function () {
                    /**
                     * Save the jQuery reference of the object
                     * @param $content
                     */
                    function Content($content) {
                      _classCallCheck(this, Content);

                      this.$content = $content;
                    }
                    /**
                     * Get all info related to the template
                     * @returns {{layout: *, comments: *, extra: {class: {}}, style: *}}
                     */


                    _createClass(Content, [{
                      key: "data",
                      value: function data() {
                        var style = TVE.Theme.utils.getSpecificStyle(function (selector) {
                          return !selector.includes(TVE.identifier('symbol')) &&
                          /* css from templates that has the body class and is not a symbol */
                          selector.includes(TVE.Theme.CONST.body_class);
                        }),
                            icons = Content.icons(this.$content),
                            $content = Content.clean(this.$content);
                        Content.elementClasses($content);
                        TVE.apply_filters('theme.parse_content', $content, 'template');
                        return _objectSpread({
                          icons: icons,
                          style: style,
                          layout: Content.getLayoutId(),
                          layout_data: TVE.Theme.template.getLayoutDataToSave(),
                          structure: this.structure($content),
                          tve_globals: Content.getGlobals()
                        }, Content.extraData(this.$content), {
                          sections: this.saveSections($content)
                        });
                      }
                      /**
                       * Clean code of extra classes and/or content
                       * @param $content
                       */

                    }, {
                      key: "structure",

                      /**
                       * Return page layout structure
                       * @param $content
                       * @returns {string}
                       */
                      value: function structure($content) {
                        if (typeof $content === 'undefined') {
                          $content = TVE.Theme.$wrapper.clone();
                        }

                        $content = Content.clean($content);
                        $content.find(".main-content-background, ".concat(TVE.Theme.constants.identifiers.MAIN_COLUMNS_SEPARATOR)).remove();
                        $content.find("".concat(TVE.Theme.models.Section.identifier)).each(function (index, section) {
                          var $section = TVE.inner_$(section),
                              sectionId = parseInt(section.dataset.id);
                          var shortcodeAttr = {
                            'type': $section.attr('data-section')
                          };
                          var shortcodeText = ['[thrive_template_section'];

                          if (sectionId) {
                            shortcodeText.push("id=\"".concat(sectionId, "\""));
                          }

                          _.each(shortcodeAttr, function (v, k) {
                            shortcodeText.push("".concat(k, "=\"").concat(v, "\""));
                          });

                          shortcodeText.push(']');
                          $section.replaceWith(shortcodeText.join(' '));
                        });
                        /* wrap the columns into a shortcode so we can have better control over it. */

                        $content.find(TVE.identifier('main-container')).each(function (index, element) {
                          TVE.inner_$(element).replaceWith("[thrive_main_container]".concat(element.innerHTML, "[/thrive_main_container]"));
                        });
                        $content.find('#content').each(function (index, element) {
                          TVE.inner_$(element).replaceWith("[thrive_template_content]".concat(element.innerHTML, "[/thrive_template_content]"));
                        });
                        return $content.html();
                      }
                      /**
                       * Detect elements that have events or responsive on them so we can save the custom classes
                       * @param $content
                       */

                    }, {
                      key: "saveSections",

                      /**
                       * Return static sections.
                       * Dynamic sections will have only the ID, the rest will have full html
                       * @param $content
                       * @returns {{ sections: *, labels: *}}
                       */
                      value: function saveSections($content) {
                        var sections = {};
                        $content.find(TVE.Theme.models.Section.identifier).each(function (index, section) {
                          var $section = TVE.inner_$(section),
                              sectionInstance = TVE.Theme.models.Section.getInstance($section),
                              type = sectionInstance.type;
                          /**
                           * To know type of section saved
                           * e.g used for toc element refresh functionality
                           */

                          TVE.Theme.savedSection = type;

                          if (sectionInstance.isDynamic()) {
                            sections[type] = {
                              id: sectionInstance.ID
                            };
                          } else {
                            sections[type] = _objectSpread({
                              id: 0,
                              content: sectionInstance.getContent()
                            }, sectionInstance.getExtra());
                          }
                          /* this is always saved on the template */


                          sections[type].hide = section.classList.contains('hide-section') ? 1 : 0;
                        });
                        [TVE.Theme.$sections.header, TVE.Theme.$sections.footer].forEach(function ($section) {
                          var section = TVE.Theme.models.HFSection.getInstance($section),
                              data = {
                            id: section.ID,
                            hide: $section.hasClass(TVE.Theme.constants.identifiers.HIDE_SECTION_CLASS) ? 1 : 0
                          };
                          TVE.Theme.savedSection = section.type;

                          if (!section.isDynamic()) {
                            data.content = section.getContent();
                            data.sticky = section.$html.attr('data-tve-scroll') || '';
                            /* TODO: integrate extra stuff - icons, decorations, responsive #lateraligator */
                          }

                          sections[section.type] = data;
                        });
                        delete TVE.Theme.savedSection;
                        return sections;
                      }
                      /**
                       * Some other stuff that we need to save. mostly custom things
                       * @return {{'sticky-sidebar': (*|string), 'off-screen-sidebar': (*|string)}}
                       */

                    }], [{
                      key: "clean",
                      value: function clean($content) {
                        /* this has to be done before calling get_clean_content */
                        TVE.Components.pagination.cleanFroalaContent($content);
                        $content = TVE.inner_$("<div>".concat(TVE.Editor_Page.content_manager.get_clean_content({}, $content), "</div>"));
                        var removeClasses = ['edit_mode', 'on_hover', 'active_highlight', 'tve-droppable', 'tve-draggable', 'tcb_similar_edit', 'tcb-compact-edit-mode'],
                            removeAttributes = ['data-selector', 'draggable'];
                        removeAttributes.forEach(function (attr) {
                          return $content.find("[".concat(attr, "]")).removeAttr(attr);
                        });
                        $content.find('.' + removeClasses.join(',.')).removeClass(removeClasses.join(' '));
                        $content.find('.thrv_widget').children(':not(.widget-config)').remove();
                        $content.find(TVE.Theme.selectors.removeOnSave.join(',')).remove();
                        return $content;
                      }
                      /**
                       * Replace each shortcode selector with it's specific shortcode
                       * @param $content
                       */

                    }, {
                      key: "shortcodes",
                      value: function shortcodes($content) {
                        /* handle elements that dynamically load other elements */
                        $content = TVE.apply_filters('theme.save_shortcodes', $content);
                        /* replace dynamic content with shortcodes */

                        $content.find('.thrive-shortcode').each(function (index, element) {
                          var shortcode = element.dataset.shortcode;

                          if (shortcode) {
                            var attributes = TVE.Theme.utils.element_attributes(element, ['data-shortcode', 'data-selector'], true, true);

                            _.each(attributes, function (value, key) {
                              /* we have to replace single quote from values so it won't break the attribute */
                              value = value.replace(/\'/g, '__SHORTCODE_SINGLE_QUOTE__');
                              shortcode += " ".concat(key, "='").concat(value, "'");
                            });

                            TVE.inner_$(element).replaceWith("[".concat(shortcode, "]"));
                          }
                        });
                        /* these are the TTB-only dynamic links from Animations, not the newly added dynamic links ( which have .tve-dynamic-link )*/

                        $content.find('[data-dynamic-link!=""][data-dynamic-link]:not(.tve-dynamic-link)').each(function (index, element) {
                          element.href = TVE.Theme.utils.applyBrackets(element.getAttribute('data-dynamic-link'));
                        });
                        TVE.PostList.dynamicImage.saveDynamicImageSources($content);
                        /* look for elements that have the 'wrapper-shortcode' class and wrap them in shortcode tags */

                        $content.find('.wrapper-shortcode').each(function (index, element) {
                          var shortcodeTag = element.dataset.shortcode,
                              attr = element.dataset.css ? " data-css=".concat(element.dataset.css) : '';

                          if (shortcodeTag.length) {
                            TVE.inner_$(element).replaceWith("[".concat(shortcodeTag).concat(attr, "]").concat(element.innerHTML, "[/").concat(shortcodeTag, "]"));
                          }
                        });
                      }
                    }, {
                      key: "elementClasses",
                      value: function elementClasses($content) {
                        $content.find('.thrive-shortcode.tve_evt_manager_listen, .thrive-shortcode .tve_evt_manager_listen').each(function (index, element) {
                          element.setAttribute('data-class', TVE.PostList.utils.getEventClasses(element.className));
                          /* encode [ and ] so the shortcodes won't read them in a wrong way. */

                          var events = element.getAttribute('data-tcb-events');

                          if (events) {
                            element.setAttribute('data-tcb-events', events.replace(/\[/g, '|{|').replace(/\]/g, '|}|'));
                          }
                        });
                        $content.find('.tcb-desktop-hidden, .tcb-tablet-hidden, .tcb-mobile-hidden').each(function (index, element) {
                          var responsiveClasses = TVE.Theme.utils.getElementResponsiveClasses(element);
                          var elementClasses = element.dataset["class"] ? element.dataset["class"] : '';
                          responsiveClasses.forEach(function (responsiveClass) {
                            if (!elementClasses.includes(responsiveClass)) {
                              elementClasses += " ".concat(responsiveClass);
                            }
                          });
                          element.setAttribute('data-class', elementClasses);
                        });
                        /* search elements that have the hidden class */

                        $content.find('[data-class*="-hidden"]').each(function (index, element) {
                          var dataClass = element.dataset["class"];
                          var match = dataClass.match(/(tcb-\w*-hidden)/g);
                          /* and make sure what they have in data-class is also in the class */

                          if (match) {
                            match.forEach(function (m) {
                              if (!element.classList.contains(m)) {
                                dataClass = dataClass.replace(m, '');
                              }
                            });
                          }

                          element.setAttribute('data-class', dataClass.trim());
                        });
                      }
                    }, {
                      key: "extraData",
                      value: function extraData($content) {
                        var extra = {
                          'sidebar-type': TVE.Theme.$sections.sidebar.attr('data-display-type') || '',
                          'sticky-sidebar': TVE.Theme.$sections.sidebar.attr('data-sticky') || '',
                          'off-screen-sidebar': TVE.Theme.$sections.sidebar.attr('data-off-screen') || ''
                        },
                            $noSearchResults = $content.find(TVE.Theme.constants.blog_list.no_results.selector);

                        if (TVE.Theme.template.isSearch() && $noSearchResults.length > 0) {
                          var _$content = TVE.inner_$("<div>".concat($noSearchResults[0].outerHTML.replace('tcb-permanently-hidden', ''), "</div>"));

                          extra['no_search_results'] = TVE.Editor_Page.content_manager.get_clean_content({}, _$content);
                        }

                        return extra;
                      }
                      /**
                       * Get global info for the template - similar with what we have on posts/pages in Architect
                       * @returns {{js_sdk: *[], fb_comment_admins: string}}
                       */

                    }, {
                      key: "getGlobals",
                      value: function getGlobals() {
                        var $content = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : TVE.Editor_Page.editor;
                        return {
                          js_sdk: TVE.Editor_Page.content_manager.getUsedSDKs($content),
                          fb_comment_admins: TVE.Editor_Page.content_manager.getFacebookCommentsModerators($content),
                          progress_bar: Content.getProgressBarPosition()
                        };
                      }
                      /**
                       * Search for icons in the content and return the svg content
                       *
                       * @param $content
                       * @returns {Object}
                       */

                    }, {
                      key: "icons",
                      value: function icons() {
                        var $content = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : TVE.Theme.$wrapper;
                        var icons = {};
                        var _iteratorNormalCompletion = true;
                        var _didIteratorError = false;
                        var _iteratorError = undefined;

                        try {
                          for (var _iterator = TVE.Theme.selectors.icons[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                            var selector = _step.value;
                            $content.find(selector + ' svg.tcb-icon').each(function (index, svg) {
                              icons[typeof svg.dataset.id === 'undefined' ? svg.dataset.name : svg.dataset.id] = svg.outerHTML;
                            });
                          }
                        } catch (err) {
                          _didIteratorError = true;
                          _iteratorError = err;
                        } finally {
                          try {
                            if (!_iteratorNormalCompletion && _iterator["return"] != null) {
                              _iterator["return"]();
                            }
                          } finally {
                            if (_didIteratorError) {
                              throw _iteratorError;
                            }
                          }
                        }

                        return icons;
                      }
                      /**
                       * Parse the content after it was stringified.
                       * Certain modifications can only be applied on the content only in this state, such as adding dynamic image sources.
                       *
                       * @param content
                       * @return {*}
                       */

                    }, {
                      key: "parseContentString",
                      value: function parseContentString(content) {
                        content = TVE.PostList.dynamicImage.replaceImageShortcodeSrc(content);
                        return content;
                      }
                      /**
                       * @return {number}
                       */

                    }, {
                      key: "getLayoutId",
                      value: function getLayoutId() {
                        var match = /thrive-layout-(\d*)/.exec(TVE.inner.$body.attr('class'));
                        return match ? parseInt(match.pop()) : 0;
                      }
                      /**
                       * @param {jQuery} $content
                       * @returns {String}
                       */

                    }, {
                      key: "getProgressBarPosition",
                      value: function getProgressBarPosition() {
                        var $content = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : TVE.Editor_Page.editor;
                        var $progressBar = $content.find('.thrive-progress-bar'),
                            dataPosition = $progressBar.attr('data-position');
                        var position = '';

                        if ($progressBar.length && dataPosition !== 'undefined') {
                          position = dataPosition;
                        }

                        return position;
                      }
                    }]);

                    return Content;
                  }();

                  module.exports = Content;
                },
                "hf-section.js": function hfSectionJs(exports, module, require) {
                  var AbstractSection = require('./abstract-section');

                  var HFSection =
                  /*#__PURE__*/
                  function (_AbstractSection) {
                    _inherits(HFSection, _AbstractSection);

                    function HFSection() {
                      _classCallCheck(this, HFSection);

                      return _possibleConstructorReturn(this, _getPrototypeOf(HFSection).apply(this, arguments));
                    }

                    _createClass(HFSection, [{
                      key: "setElements",

                      /**
                       * Set elements specific to header/footer
                       */
                      value: function setElements() {
                        this.$content = this.$element.find(this.constructor.contentSelector);
                        this.$html = this.$element.find('.thrive-symbol-shortcode:first');
                        this.$style = this.$element.find('.tve-symbol-custom-style');
                        this.$background = this.$element.find('.symbol-section-out');
                      }
                    }, {
                      key: "isHorizontal",
                      value: function isHorizontal() {
                        return true;
                      }
                    }, {
                      key: "isVertical",
                      value: function isVertical() {
                        return false;
                      }
                      /**
                       * Save section with specific title
                       * @param title {string}
                       * @param callback {function}
                       */

                    }, {
                      key: "save",
                      value: function save(title, callback) {
                        var _this12 = this;

                        return TVE.ajax('save_symbol', 'post', {
                          symbol_title: title,
                          tcb_symbols_tax: this.getSectionTermId()
                        }).done(function (response) {
                          _this12.beforeSave(response.data.id);
                          /* update the newly created section with the new css and on success update the template with the new section */


                          _this12.update(function () {
                            _this12.afterSave();
                          });

                          if (typeof TVE.Theme.data.local[_this12.type] === 'undefined') {
                            TVE.Theme.data.local[_this12.type] = {};
                          }

                          TVE.Theme.data.local[_this12.type][_this12.ID] = _this12.sectionData = {
                            id: _this12.ID,
                            name: title,
                            type: _this12.type,
                            thumb: {
                              url: response.data.thumb_url,

                              /* todo: implement this in architect */
                              w: 2,
                              h: 1
                            }
                          };

                          if (typeof callback === 'function') {
                            callback(response);
                          }
                        }).fail(console.warn);
                      }
                      /**
                       * Update section data
                       * @param {Function} callback to execute on the success of an update
                       */

                    }, {
                      key: "update",
                      value: function update() {
                        var _this13 = this;

                        var callback = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
                        var data = {
                          'id': this.ID,
                          'symbol_content': this.getContent(),
                          'symbol_css': this.getStyle()
                        };
                        data = TVE.apply_filters('tcb.symbol.before_save', data);
                        TVE.ajax('save_symbol', 'post', data).done(function (response) {
                          /* todo: maybe we should load symbols also from ajax request */
                          TVE.Theme.data.local[_this13.type][_this13.ID].content = data.symbol_content;
                          TVE.Theme.data.local[_this13.type][_this13.ID].style = data.symbol_css;
                          /* call the generate preview function implemented for symbols */

                          TVE.Components.symbol.content_preview.generate_preview(_this13.$element, {
                            'post_id': response.data.symbol.ID,
                            'file_name': response.data.symbol.ID + '.png'
                          });

                          if (typeof callback === 'function') {
                            callback(response);
                          }
                        }).fail(console.warn);
                      }
                      /**
                       * Transform section into static content. Remove id and class convert the css into general template one
                       */

                    }, {
                      key: "unlink",
                      value: function unlink() {
                        var _this14 = this;

                        var silent = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
                        this.beforeUnlink();
                        this.convertCssToTemplate();
                        this.ID = 0;
                        this.updateAttr();
                        var innerStyle = '';

                        if (this.$style && this.$style.length) {
                          innerStyle = this.$style.html();
                        }

                        TVE.Editor_Page.content_manager.insert_head_css(this.convertStyle(innerStyle)).done(function () {
                          _this14.focus();

                          _this14.constructor.saveTemplate(silent, false);

                          _this14.bindElementActions();

                          _this14.afterUnlink();
                        });
                      }
                      /**
                       * Import new section
                       *
                       * @param sectionId
                       * @param source
                       * @param version
                       */

                    }, {
                      key: "load",
                      value: function load(sectionId) {
                        var _this15 = this;

                        var source = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'local';
                        var version = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
                        this.$element.addClass('element-loading');
                        var args = {
                          id: sectionId,
                          type: this.type
                        };
                        var route = source === 'local' ? 'get_symbol' : 'cloud_content_template_download';
                        TVE.ajax(route, 'get', args).done(function (response) {
                          var symbol = response.data;
                          /* local header/footers are loaded dynamic, with their own id that need to go in edit mode */

                          if (source === 'local') {
                            symbol.id = sectionId;
                            symbol.style = response.data.css;
                          } else {
                            /* cloud header/footers are loaded unlinked so we have to convert the css and have no id */
                            symbol.id = 0;
                            symbol.style = _this15.convertStyle(response.data.head_css);
                          }

                          _this15.insert(symbol);
                        }).fail(console.warn);
                      }
                      /**
                       * Insert section in the page
                       *
                       * @param section
                       */

                    }, {
                      key: "insert",
                      value: function insert(section) {
                        var _this16 = this;

                        this.beforeInsert(section);
                        this.$html.html(section.content);
                        TVE.Editor_Page.content_manager.insert_head_css(section.style).done(function () {
                          _this16.$element.removeClass('element-loading');

                          _this16.afterInsert(section);
                        });
                        this.setElements();
                        this.updateAttr();
                      }
                      /**
                       * @inheritDoc
                       *
                       * @param {Object} section
                       */

                    }, {
                      key: "beforeInsert",
                      value: function beforeInsert(section) {
                        _get(_getPrototypeOf(HFSection.prototype), "beforeInsert", this).call(this, section);
                        /* make sure we remove all css related to header/footer before inserting a new one. */


                        TVE.head_css_remove(TVE.Theme.utils.escapedRegEx(this.baseSelector, 'g'), '_ALL');
                        /**
                         * When inserting a header / footer template into the content, make sure [data-css] CSS rules are replaced with the equivalent theme version
                         * This needs to be done for `.symbol-section-out` and `.symbol-section-in`
                         * (Directly modifies the `section` object passed as parameter)
                         */

                        section.content = TVE.inner_$(section.content);
                        section.content.filter('.symbol-section-out[data-css], .symbol-section-in[data-css]').each(function (index, element) {
                          var dataCss = TVE.escapedRegEx("[data-css=\"".concat(element.dataset.css, "\"]"), 'g');
                          section.style = section.style.replace(dataCss, '.' + TVE.getClassThatContains(element, 'symbol-section-'));
                          delete element.dataset.css;
                        });
                      }
                      /**
                       * Actions done after the section has been added to the page
                       *
                       * @param section
                       */

                    }, {
                      key: "afterInsert",
                      value: function afterInsert(section) {
                        _get(_getPrototypeOf(HFSection.prototype), "afterInsert", this).call(this, section);
                        /* We need to remove the extra classes used to prevent glitches when this section is inserted because the menu won't be displayed */


                        this.$element.find('.thrv_widget_menu').removeClass('tve-custom-menu-switch-icon-tablet tve-custom-menu-switch-icon-mobile');
                      }
                      /**
                       * Convert css from cloud to static css
                       * @param style
                       * @returns {string}
                       */

                    }, {
                      key: "convertStyle",
                      value: function convertStyle(style) {
                        var placeholder = '__TEMP_SELECTOR__';
                        style = style.replace(/\.thrv_symbol_\|TEMPLATE_ID\|*/g, placeholder);
                        style = style.replace(/\.thrv_symbol_\d*/g, placeholder);
                        style = style.replace(/\.thrv_symbol\.thrv_\S*/g, placeholder);
                        style = style.replace(new RegExp(placeholder, 'g'), "".concat(TVE.Theme.CONST.body_class, " ").concat(this.baseSelector));
                        return style;
                      }
                      /**
                       * Update attributes on the element depending on section being dynamic or not
                       */

                    }, {
                      key: "updateAttr",
                      value: function updateAttr() {
                        this.$element.attr('data-selector', this.selector);
                        var classAttr = this.$element.attr('class').replace(/thrv_symbol_\d*/, '');
                        /* remove old symbol class so we can maybe add the new one */

                        this.$element.attr('class', classAttr);

                        if (this.isDynamic()) {
                          this.$element.addClass(this.selector.replace('.', '')).attr('data-id', this.ID);
                          this.$html.attr('data-symbol-id', this.ID);
                          this.$content.attr('data-selector', "".concat(this.constructor.contentSelector));
                          this.$background.attr('data-selector', "".concat(this.constructor.backgroundSelector));
                        } else {
                          /**
                           * tve-default-state is used to write header's normal state css for both content & background
                           * on unlink we need to make sure that default css still can be changed
                           */
                          var suffix = this.type === 'header' ? '.tve-default-state' : '';
                          this.$content.attr('data-selector', "".concat(this.baseSelector).concat(suffix, " ").concat(this.constructor.contentSelector).concat(suffix));
                          this.$background.attr('data-selector', "".concat(this.baseSelector).concat(suffix, " ").concat(this.constructor.backgroundSelector).concat(suffix));

                          if (this.type === 'header') {
                            this.$content.addClass('tve-default-state');
                            this.$background.addClass('tve-default-state');
                          }

                          this.$element.removeAttr('data-id').removeAttr('data-section-name');
                          this.$html.removeAttr('data-symbol-id');
                        }

                        this.$element.toggleClass('symbol-edit-mode', !this.isDynamic() || this.inEditMode());
                        this.$html.attr('data-selector', "".concat(this.selector, " .thrive-symbol-shortcode")).toggleClass('thrive-shortcode-html', this.isDynamic() && !this.inEditMode());
                      }
                      /**
                       * Get section specific style
                       * @returns {*|{css, fonts: string, dynamic}}
                       */

                    }, {
                      key: "getStyle",
                      value: function getStyle() {
                        var _this17 = this;

                        var style = TVE.Theme.utils.getSpecificStyle(function (selector) {
                          var isDynamic = _this17.isDynamic(),
                              hasBodyClass = selector.includes(TVE.Theme.CONST.body_class),
                              keepStylesForSelector = (isDynamic && !hasBodyClass || !isDynamic && hasBodyClass) && selector.includes(_this17.selector);
                          /**
                           * Filter for additional scenarios where we want to keep the styles
                           *
                           * @param {Boolean} includeStyle
                           * @param {String} selector
                           * @param {jQuery} $content
                           */


                          return TVE.apply_filters('theme.section.keep_styles_for_selector', keepStylesForSelector, selector, _this17.$content);
                        });
                        var css = style.fonts.join('');

                        _.each(style.css, function (_css, media) {
                          css += "@media ".concat(media, " {").concat(_css, "}");
                        });

                        return css;
                      }
                      /**
                       * Clean and return the html content of the section
                       * @returns {*}
                       */

                    }, {
                      key: "getContent",
                      value: function getContent() {
                        var $content = TVE.Theme.models.Content.clean(this.$html);
                        $content.find('.tve-symbol-custom-style').remove();
                        TVE.Theme.models.Content.elementClasses($content);
                        TVE.Theme.models.Content.shortcodes($content);
                        TVE.apply_filters('theme.parse_content', $content, 'section');
                        return $content.html();
                      }
                      /**
                       * Get term id for the taxonomy of the header/footer
                       * @returns {number}
                       */

                    }, {
                      key: "getSectionTermId",
                      value: function getSectionTermId() {
                        var _this18 = this;

                        var term = TVE.CONST.sections_tax_terms.find(function (tax) {
                          return tax.slug === "".concat(_this18.type, "s");
                        });
                        return term && term.term_id ? term.term_id : 0;
                      }
                      /**
                       * Return block target location when the user wants to insert below / above the header or footer
                       *
                       * @returns {*}
                       */

                    }, {
                      key: "getBlockTarget",
                      value: function getBlockTarget() {
                        var $target;
                        /* If the target is header, we actually want to insert the block after the landing page section ( which is hidden in the page ) */

                        if (this.type === 'header') {
                          var $nextElement = this.$element.next();

                          if (TVE.Theme.models.LPSection.isLPSection($nextElement)) {
                            $target = $nextElement;
                          }
                        } else {
                          /* If the target is footer, we actually want to insert the block before the landing page section ( which is hidden in the page ) */
                          var $prevElement = this.$element.prev();

                          if (TVE.Theme.models.LPSection.isLPSection($prevElement)) {
                            $target = $prevElement;
                          }
                        }

                        return $target;
                      }
                      /**
                       * Check if we can add blocks below the section
                       *
                       * @returns {Boolean}
                       */

                    }, {
                      key: "allowBlockControlsBelow",
                      value: function allowBlockControlsBelow(allow) {
                        var $target = this.getBlockTarget();
                        /* We are allowing block inserts only if the top / bottom section is hidden */

                        if ($target && $target.length) {
                          allow = $target.css('display') === 'none';
                        }
                        /* We cannot add blocks below the footer */


                        if (this.type === 'footer') {
                          allow = false;
                        }

                        return allow;
                      }
                    }, {
                      key: "baseSelector",
                      get: function get() {
                        return ".thrv_".concat(this.type);
                      }
                    }, {
                      key: "selector",
                      get: function get() {
                        return this.ID ? ".thrv_symbol_".concat(this.ID) : this.baseSelector;
                      }
                    }], [{
                      key: "getTemplateId",

                      /**
                       * Get template id from where the section is on
                       *
                       * @returns {Number}
                       */
                      value: function getTemplateId() {
                        return TVE.Theme.template.ID;
                      }
                    }, {
                      key: "identifier",
                      get: function get() {
                        return '.thrv_header,.thrv_footer';
                      }
                    }, {
                      key: "component",
                      get: function get() {
                        return TVE.Components['theme-hf'];
                      }
                    }, {
                      key: "contentSelector",
                      get: function get() {
                        return '.symbol-section-in';
                      }
                    }, {
                      key: "backgroundSelector",
                      get: function get() {
                        return '.symbol-section-out';
                      }
                    }]);

                    return HFSection;
                  }(AbstractSection);

                  module.exports = HFSection;
                },
                "layout.js": function layoutJs(exports, module, require) {
                  var sidebar = function sidebar() {
                    return TVE.inner.window.ThriveTheme.sidebar;
                  };

                  var Layout =
                  /*#__PURE__*/
                  function () {
                    _createClass(Layout, [{
                      key: "selector",

                      /**
                       * Selector for the current layout
                       * @returns {string}
                       */
                      get: function get() {
                        return ".thrive-layout-".concat(this.ID);
                      }
                      /**
                       * Save the ID of the layout if available
                       * Also store the current meta data
                       * @param {int} ID
                       * @param {Object} data
                       */

                    }], [{
                      key: "prefix",

                      /**
                       * Prefix used to identify css specific to the layout
                       * @returns {string}
                       */
                      get: function get() {
                        return ':not(#layout)';
                      }
                    }]);

                    function Layout() {
                      var ID = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
                      var data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

                      _classCallCheck(this, Layout);

                      this.ID = ID;
                      this.setMeta(data);
                    }
                    /**
                     * @param key
                     * @return {*}
                     */


                    _createClass(Layout, [{
                      key: "getMeta",
                      value: function getMeta() {
                        var key = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
                        return key ? this.meta[key] : this.meta;
                      }
                      /**
                       * @param data
                       */

                    }, {
                      key: "setMeta",
                      value: function setMeta(data) {
                        /* if we don't have a value in the content width, we set the current value from the page */
                        if (data && data.meta_input && !data.meta_input['content_width']) {
                          data.meta_input['content_width'] = Layout.getContentWidth();
                        }

                        this.meta = data.meta_input;
                      }
                      /**
                       * Return the name of the layout template or custom if not found
                       * @returns {string}
                       */

                    }, {
                      key: "name",
                      value: function name() {
                        var _this19 = this;

                        var name = 'Custom';

                        if (this.ID) {
                          var layout = TVE.CONST.theme.layouts.find(function (l) {
                            return l.ID === _this19.ID;
                          });

                          if (layout) {
                            name = layout.post_title;
                          }
                        }

                        return name;
                      }
                      /**
                       * Save new layout
                       * @param title {string}
                       * @param callback {function}
                       */

                    }, {
                      key: "save",
                      value: function save(title, callback) {
                        var _this20 = this;

                        TVE.Theme.utils.loadingMessage('Saving Layout');
                        TVE.$.ajax({
                          url: TVE.CONST.theme.routes.layouts,
                          type: 'POST',
                          data: {
                            post_title: title
                          },
                          headers: {
                            'X-WP-Nonce': TVE.CONST.rest_nonce
                          }
                        }).done(function (layoutId) {
                          _this20.convertCss(layoutId);

                          TVE.CONST.theme.layouts.push({
                            ID: layoutId,
                            post_title: title
                          });

                          _this20.update(true);

                          if (typeof callback === 'function') {
                            callback(layoutId);
                          }
                        }).fail(function () {
                          TVE.page_message('Error saving the layout!', true, 3000);
                        }).always(function () {
                          TVE.Theme.utils.loadingMessage(false);
                        });
                      }
                      /**
                       * Save layout style changes
                       * @param silent
                       * @return {Object}
                       */

                    }, {
                      key: "update",
                      value: function update() {
                        var silent = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;

                        if (!this.ID) {
                          TVE.page_message('Unknown layout to save!', true, 300);
                          return;
                        }

                        !silent && TVE.Theme.utils.loadingMessage('Updating layout');
                        return TVE.$.ajax({
                          url: "".concat(TVE.CONST.theme.routes.layouts, "/").concat(this.ID),
                          type: 'POST',
                          data: {
                            meta_input: _objectSpread({
                              template_id: TVE.Theme.template.ID,
                              style: {
                                css: this.getStyle()
                              }
                            }, Layout.getDataFromPage())
                          },
                          headers: {
                            'X-WP-Nonce': TVE.CONST.rest_nonce
                          }
                        }).done(function (response) {
                          var layoutToUpdate = TVE.CONST.theme.layouts.findIndex(function (layout) {
                            return layout.ID === response.data.ID;
                          });

                          if (layoutToUpdate === -1) {
                            TVE.CONST.theme.layouts.push(response.data);
                          } else {
                            TVE.CONST.theme.layouts[layoutToUpdate] = response.data;
                          }

                          Layout.getStyleNode().html(response.style);
                          TVE.head_css_remove(TVE.Theme.utils.escapedRegEx(Layout.prefix, 'g'), '_ALL');
                          TVE.do_action('theme.layout.after_update');
                        }).fail(function (response) {
                          TVE.page_message('Error saving the layout!', true, 3000);
                        }).always(function (response) {
                          setTimeout(function () {
                            /* show the message a little longer. */
                            TVE.Theme.utils.loadingMessage(false);
                          }, 2000);
                        });
                      }
                      /**
                       * Load a new layout
                       * @param layoutId
                       * @param oldLayout
                       * @param callback {function}
                       */

                    }, {
                      key: "getStyle",

                      /**
                       * Get layout style
                       * @returns {*}
                       */
                      value: function getStyle() {
                        var defaultStylesheet = TVE.stylesheet;
                        TVE.stylesheet = Layout.getStyleNode()[0].sheet;
                        var layoutStyle = this.convertSelector(TVE.CSS_Rule_Cache.getCssForSelector(this.selector), this.selector);
                        TVE.stylesheet = defaultStylesheet;
                        var style = TVE.$.extend(true, {}, layoutStyle, this.convertSelector(TVE.CSS_Rule_Cache.getCssForSelector(Layout.prefix), TVE.Theme.CONST.body_class));

                        for (var media in style) {
                          if (style.hasOwnProperty(media)) {
                            /* initially we have an object with key-value for each css property and I want to concatenate all properties from one selector into one string */
                            style[media] = _.map(style[media], function (properties, selector) {
                              return selector + '{' + _.map(properties, function (v, k) {
                                return "".concat(k, ":").concat(v);
                              }).join('; ') + '}';
                            }).join('');
                          }
                        }

                        return style;
                      }
                      /**
                       * Convert selector for the current selector
                       * @param style
                       * @param toReplace
                       * @returns {{}}
                       */

                    }, {
                      key: "convertSelector",
                      value: function convertSelector(style) {
                        var toReplace = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
                        var newStyle = {};

                        for (var media in style) {
                          if (style.hasOwnProperty(media) && media !== '@imports') {
                            newStyle[media] = {};

                            for (var selector in style[media]) {
                              if (style[media].hasOwnProperty(selector)) {
                                var newSelector = selector.replace(Layout.prefix, '').replace(toReplace, this.selector).trim();
                                newStyle[media][newSelector] = style[media][selector];
                              }
                            }
                          }
                        }

                        return newStyle;
                      }
                      /**
                       * Convert current css to a new layout css
                       * @param layoutId
                       */

                    }, {
                      key: "convertCss",
                      value: function convertCss(layoutId) {
                        /* add the new layout class */
                        TVE.inner.$body.addClass("thrive-layout-".concat(layoutId));
                        var $styleNode = Layout.getStyleNode(),

                        /* replace the old class with the new class */
                        layoutCss = $styleNode.html().replace(TVE.Theme.utils.escapedRegEx("thrive-layout-".concat(this.ID), 'g'), "thrive-layout-".concat(layoutId));
                        /* replace the old css with the new one */

                        $styleNode.html(layoutCss);
                        TVE.inner.$body.removeClass("thrive-layout-".concat(this.ID));
                        this.ID = layoutId;
                      }
                      /**
                       * Check if we have changes in the template ( data + css ) that haven't been saved to the layout
                       * @returns {*|boolean}
                       */

                    }], [{
                      key: "load",
                      value: function load(layoutId) {
                        var oldLayout = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
                        var callback = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : TVE.$.noop;
                        layoutId = parseInt(layoutId);
                        oldLayout = parseInt(oldLayout);

                        if (layoutId === oldLayout) {
                          return;
                        }

                        TVE.Theme.utils.loadingMessage('Loading layout');
                        TVE.$.ajax({
                          url: "".concat(TVE.CONST.theme.routes.layouts, "/").concat(layoutId),
                          type: 'GET',
                          headers: {
                            'X-WP-Nonce': TVE.CONST.rest_nonce
                          }
                        }).done(function (layout) {
                          if (oldLayout) {
                            TVE.inner.$body.removeClass("thrive-layout-".concat(oldLayout));
                          }

                          TVE.inner.$body.addClass("thrive-layout-".concat(layoutId));
                          Layout.getStyleNode().html(layout.style);
                          Layout.fixLayoutStructure(layout);
                          /* when we change to a new layout, we remove custom layout css from the template */

                          TVE.head_css_remove(TVE.Theme.utils.escapedRegEx(Layout.prefix, 'g'), '_ALL');
                          setTimeout(function () {
                            TVE.Theme.utils.loadingMessage(false);
                            TVE.Theme.content.updateResizeHandlersPosition();
                            TVE.PostList.layout.masonryRedo();
                            TVE.Theme.utils.loadingMessage('Updating also the template!', 'save-template');
                            TVE.Theme.content.save(function () {
                              TVE.Theme.utils.loadingMessage(false, 'save-template');

                              if (typeof callback === 'function') {
                                callback(layoutId);
                              }
                            }, true, true);
                          }, 42);
                        }).fail(function () {
                          TVE.page_message('Error loading layout!', true, 3000);
                          TVE.Theme.utils.loadingMessage(false);
                        });
                      }
                      /**
                       * Returns the style node for the layout css. If it doesn't exist, it will be created.
                       * @returns {jQuery}
                       */

                    }, {
                      key: "getStyleNode",
                      value: function getStyleNode() {
                        var $layoutSheet = TVE.inner.jQuery('#thrive-theme-layout-css');

                        if ($layoutSheet.length === 0) {
                          $layoutSheet = TVE.inner.jQuery('<style id="thrive-theme-layout-css" type="text/css"></style>');
                          $layoutSheet.insertBefore(TVE.inner.jQuery('#thrive-template-css'));
                        }

                        return $layoutSheet;
                      }
                    }, {
                      key: "hasUnsavedChanges",
                      value: function hasUnsavedChanges() {
                        var lastSavedData = Layout.getInstance().getMeta();
                        /* look for changes in the layout meta compared to what's in the page right now */

                        var hasUnsavedChanges = typeof _.find(Layout.getDataFromPage(), function (value, key) {
                          return lastSavedData[key] !== value;
                        }) !== 'undefined';

                        if (!hasUnsavedChanges) {
                          /* look for changes in the css */
                          hasUnsavedChanges = _.some(TVE.CSS_Rule_Cache.getCssForSelector(Layout.prefix), function (styles) {
                            return Object.values(styles).length > 0;
                          });
                        }

                        return hasUnsavedChanges;
                      }
                      /**
                       * Make top/bottom sections full width or not, and put sidebar on left or right depending on the layout
                       * If sidebar is off sceen but hidden, destroy it !!!
                       * @param layout
                       */

                    }, {
                      key: "fixLayoutStructure",
                      value: function fixLayoutStructure(layout) {
                        var hideSidebar = !!parseInt(layout.meta_input.hide_sidebar);
                        TVE.Theme.$main.toggleClass(TVE.Theme.constants.identifiers.FLIP_SECTIONS_CLASS, !!parseInt(layout.meta_input.sidebar_on_left));
                        TVE.Theme.$sections.sidebar.toggleClass(TVE.Theme.constants.identifiers.HIDE_SECTION_CLASS, hideSidebar);

                        if (sidebar().isOffScreen()) {
                          if (hideSidebar) {
                            sidebar()._get('off-screen').destroy();
                          } else {
                            sidebar().offScreenRefresh();
                          }
                        }
                      }
                      /**
                       * Extra data for layout - mostly so we can modify it from outside.
                       *      - on what side we have the sidebar
                       *      - what is the page content width
                       *      - if we hide the sidebar
                       *
                       * @return {Object}
                       */

                    }, {
                      key: "getDataFromPage",
                      value: function getDataFromPage() {
                        return {
                          sidebar_on_left: TVE.Theme.$main.hasClass(TVE.Theme.constants.identifiers.FLIP_SECTIONS_CLASS) ? 1 : 0,
                          content_width: this.getContentWidth(),
                          hide_sidebar: this.isSidebarHidden()
                        };
                      }
                      /**
                       * @return {number}
                       */

                    }, {
                      key: "isSidebarHidden",
                      value: function isSidebarHidden() {
                        return TVE.Theme.$sections.sidebar.hasClass(TVE.Theme.constants.identifiers.HIDE_SECTION_CLASS) ? 1 : 0;
                      }
                      /**
                       * @return {string}
                       */

                    }, {
                      key: "getContentWidth",
                      value: function getContentWidth() {
                        return Layout.isFullWidth() ? '100%' : Layout.getWidth('content');
                      }
                      /**
                       * Set the width of the layout on the content width class so it can be used by both container and sections
                       * @param width
                       * @param area {String} background or content
                       * @param inline {Boolean} write inline or in head css
                       * @return {Layout}
                       */

                    }, {
                      key: "setWidth",
                      value: function setWidth(width) {
                        var area = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
                        var inline = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

                        if (inline) {
                          TVE.Theme.$wrapper.tcbCss("--layout-".concat(area, "-width"), width);
                        } else {
                          TVE.Theme.FLAGS.LAYOUT_CSS_WRITE = true;
                          TVE.Theme.$wrapper.head_css(_defineProperty({}, "--layout-".concat(area, "-width"), width));
                          TVE.Theme.FLAGS.LAYOUT_CSS_WRITE = false;
                          TVE.Theme.$wrapper.tcbCss("--layout-".concat(area, "-width"), '');
                        }

                        return Layout;
                      }
                      /**
                       * Return layout width for the wanted area - content or background
                       * @param area
                       */

                    }, {
                      key: "getWidth",
                      value: function getWidth() {
                        var area = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
                        return TVE.Theme.$wrapper.tcbCss("--layout-".concat(area, "-width"));
                      }
                      /**
                       * Check if the layout is full width
                       * @returns {boolean}
                       */

                    }, {
                      key: "isFullWidth",
                      value: function isFullWidth() {
                        return Layout.getWidth('background') === '100%';
                      }
                      /**
                       * Return the instance of the current layout
                       * @returns {Layout}
                       */

                    }, {
                      key: "getInstance",
                      value: function getInstance() {
                        var layoutID = TVE.Theme.models.Content.getLayoutId();
                        /* create a layout instance using the ID and the layout data found in localize */

                        return new Layout(layoutID, TVE.CONST.theme.layouts.find(function (l) {
                          return l.ID === layoutID;
                        }));
                      }
                    }]);

                    return Layout;
                  }();

                  module.exports = Layout;
                },
                "section.js": function sectionJs(exports, module, require) {
                  var AbstractSection = require('./abstract-section');

                  var Section =
                  /*#__PURE__*/
                  function (_AbstractSection2) {
                    _inherits(Section, _AbstractSection2);

                    function Section() {
                      _classCallCheck(this, Section);

                      return _possibleConstructorReturn(this, _getPrototypeOf(Section).apply(this, arguments));
                    }

                    _createClass(Section, [{
                      key: "setElements",
                      value: function setElements() {
                        this.$content = this.$element.find(this.constructor.contentSelector);
                        this.$background = this.$element.find('.section-background');
                      }
                      /**
                       * Get template id from where the section is on
                       *
                       * @returns {Number}
                       */

                    }, {
                      key: "save",

                      /**
                       * Save section with specific title
                       *
                       * @param {String} title
                       * @param {Function} callback
                       */
                      value: function save(title, callback) {
                        var _this21 = this;

                        if (this.ID) {
                          console.warn("Section already saved with ID: ".concat(this.ID));
                          return;
                        }

                        this.removeOverlay();
                        TVE.Theme.utils.loadingMessage('Saving Section', 'save-section');
                        return TVE.$.ajax({
                          url: TVE.CONST.theme.routes.sections,
                          type: 'POST',
                          data: {
                            post_title: title,
                            meta_input: {
                              type: this.type,
                              singular: this.constructor.isOnSingularTemplate() ? 1 : 0
                            }
                          },
                          headers: {
                            'X-WP-Nonce': TVE.CONST.rest_nonce
                          }
                        }).done(function (sectionId) {
                          _this21.beforeSave(sectionId);
                          /* update the newly created section with the new css and on success update the template with the new section */


                          _this21.update(true, function () {
                            _this21.afterSave();
                          });

                          if (typeof TVE.Theme.data.local[_this21.type] === 'undefined') {
                            TVE.Theme.data.local[_this21.type] = {};
                          }

                          TVE.Theme.data.local[_this21.type][sectionId] = _this21.sectionData = {
                            id: sectionId,
                            name: title,
                            type: _this21.type
                          };

                          if (typeof callback === 'function') {
                            callback(sectionId);
                          }
                        }).fail(console.warn).always(function () {
                          setTimeout(function () {
                            TVE.Theme.utils.loadingMessage(false);
                          }, 4200);
                        });
                      }
                      /**
                       * Update section data
                       *
                       * @param {Boolean} silent
                       * @param {Function} callback to execute on the success of an update
                       */

                    }, {
                      key: "update",
                      value: function update() {
                        var _this22 = this;

                        var silent = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
                        var callback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

                        if (!this.ID) {
                          if (this.isDynamic()) {
                            /* it's bad only if the section is dynamic and doesn't have an id */
                            console.warn('Error saving dynamic section!');
                          }

                          return;
                        }

                        this.removeOverlay();

                        if (!silent) {
                          TVE.Theme.utils.loadingMessage('Updating Section');
                        }
                        /**
                         * Update handler function
                         *
                         * @private
                         */


                        var _doUpdate = function _doUpdate() {
                          var meta = _objectSpread({
                            style: _this22.getStyle(),
                            icons: TVE.Theme.models.Content.icons(_this22.$content),
                            content: _this22.getContent(),
                            tve_globals: TVE.Theme.models.Content.getGlobals(_this22.$content)
                          }, _this22.getExtra());

                          TVE.$.ajax({
                            url: "".concat(TVE.CONST.theme.routes.sections, "/").concat(_this22.ID),
                            type: 'POST',
                            data: {
                              meta_input: JSON.stringify(meta)
                            },
                            headers: {
                              'X-WP-Nonce': TVE.CONST.rest_nonce
                            }
                          }).done(function (sectionId) {
                            _this22.generatePreview();
                            /**
                             * Trigger a action after the section was updated
                             *
                             * @param {jQuery} this.$element Section element
                             * @param {Number} sectionId The id of the section just updated
                             */


                            TVE.do_action('theme.after_section_update', _this22.$element, sectionId);

                            if (typeof callback === 'function') {
                              callback(sectionId);
                            }
                          }).fail(function (response) {
                            if (TVE.wordfenceResponse(response)) {
                              TVE.Editor_Page.blur();
                            } else {
                              TVE.page_message('Error saving the section!', true, 3000);
                            }
                          }).always(function () {
                            TVE.Theme.utils.loadingMessage(false);
                          });
                        };
                        /**
                         * Before saving the html content, pre-process anything that's needed (e.g. LG and registration forms)
                         */


                        if (typeof TVE.Editor_Page.processPreSave === 'function') {
                          TVE.Editor_Page.processPreSave(this.$content, {
                            forms_filter: function forms_filter(index, element) {
                              /* ignore forms that are part of rendered shortcodes or symbols */
                              return !element.closest('.thrive-shortcode-html');
                            },
                            post_id: this.ID // use section ID as post_parent

                          }).then(_doUpdate);
                        } else {
                          _doUpdate();
                        }
                      }
                      /**
                       * Transform section into static content. Remove id and class convert the css into general template one
                       *
                       * @param {Boolean} silent
                       */

                    }, {
                      key: "unlink",
                      value: function unlink() {
                        var silent = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
                        this.beforeUnlink();
                        this.convertCssToTemplate();
                        this.ID = 0;
                        this.updateAttr();
                        this.focus();
                        /* re-do the dynamic styles of each post list after unlinking, since the 'thrive-section-X' class has to be removed from each rule */

                        this.$element.find(TVE.identifier('post_list')).each(function (index, element) {
                          TVE.PostList.dynamicImage.regeneratePostListStyleNodes(TVE.inner_$(element));
                        });
                        this.constructor.saveTemplate(silent, false);
                        this.bindElementActions();
                        this.afterUnlink();
                      }
                      /**
                       * Return arguments used when loading a section
                       *
                       * @returns {{query_vars: {page_id: *, post_type: string}, template_id: *}}
                       */

                    }, {
                      key: "load",

                      /**
                       * Import new section
                       *
                       * @param sectionId
                       * @param source
                       * @param version
                       */
                      value: function load(sectionId) {
                        var source = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'local';
                        var version = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
                        var routeSource = source === 'cloud' ? '/cloud' : '',
                            args = this.constructor.getLoadArguments();

                        if (!_.isEmpty(version)) {
                          args['version'] = version;
                        }

                        this.$element.removeClass('hide-section');
                        this.$background.addClass('section-loading');

                        if (this.$background.outerHeight() > 600) {
                          this.$background.addClass('long-content');
                        }

                        return TVE.$.ajax({
                          url: "".concat(TVE.CONST.theme.routes.sections).concat(routeSource, "/").concat(sectionId),
                          type: 'GET',
                          data: args,
                          headers: {
                            'X-WP-Nonce': TVE.CONST.rest_nonce
                          }
                        }).done(this.insert.bind(this)).fail(function (response) {
                          TVE.Theme.utils.loadingMessage(false);
                        });
                      }
                      /**
                       * Insert section in the page
                       *
                       * @param section
                       */

                    }, {
                      key: "insert",
                      value: function insert(section) {
                        var _this23 = this;

                        this.beforeInsert(section);
                        this.$element.replaceWith(TVE.inner_$(section.content));
                        TVE.Theme.$sections[this.type] = TVE.ActiveElement = this.$element = TVE.inner_$(this.selector);
                        /* remove any post list content loading classes inside the section */

                        this.$element.find('.tcb-post-content-placeholder').removeClass('tcb-post-content-placeholder');
                        TVE.Theme.sectionHover.listenersInit(this.type);
                        /* scroll to element after we insert the section */

                        TVE.inner_$('html').animate({
                          scrollTop: this.$element.offset().top - 24
                        }, 1000);
                        TVE.Editor_Page.content_manager.insert_head_css(section.style).done(function () {
                          _this23.$background.removeClass('section-loading long-content');

                          _this23.afterInsert(section);
                        });
                      }
                      /**
                       * Get section specific style
                       * @returns {*|{css, fonts: string, dynamic}}
                       */

                    }, {
                      key: "getStyle",
                      value: function getStyle() {
                        var _this24 = this;

                        return TVE.Theme.utils.getSpecificStyle(function (selector) {
                          var hasBodyClass = selector.includes(TVE.Theme.CONST.body_class),
                              hasSectionSelector = selector.includes(_this24.selector),
                              hasSymbolSelector = selector.includes(TVE.identifier('symbol')),

                          /**
                           * Keep the selector if:
                           * - it has a section selector ( thrive-section-X )
                           * - it doesn't have the body class ( no tve-theme-X )
                           * - it doesn't have a symbol selector ( no thrv_symbol_X )
                           */
                          keepStylesForSelector = hasSectionSelector && !hasBodyClass && !hasSymbolSelector;
                          /**
                           * Filter for additional scenarios where we want to keep the styles
                           *
                           * @param {Boolean} includeStyle
                           * @param {String} selector
                           * @param {jQuery} $content
                           */

                          return TVE.apply_filters('theme.section.keep_styles_for_selector', keepStylesForSelector, selector, _this24.$content);
                        });
                      }
                      /**
                       * Clean and return the html content of the section
                       * @returns {*}
                       */

                    }, {
                      key: "getContent",
                      value: function getContent() {
                        var $content = TVE.Theme.models.Content.clean(this.$content);
                        TVE.Theme.models.Content.elementClasses($content);
                        TVE.Theme.models.Content.shortcodes($content);
                        TVE.apply_filters('theme.parse_content', $content, 'section');
                        return TVE.Theme.models.Content.parseContentString($content.html());
                      }
                      /**
                       * Update attributes on the element depending on section being dynamic or not
                       */

                    }, {
                      key: "updateAttr",
                      value: function updateAttr() {
                        _get(_getPrototypeOf(Section.prototype), "updateAttr", this).call(this);

                        if (this.isDynamic()) {
                          this.$element.attr('data-id', this.ID).addClass("thrive-section-".concat(this.ID));
                        } else {
                          var classAttr = this.$element.attr('class');
                          classAttr = classAttr.replace(/thrive-section-\d*/, '');
                          this.$element.attr('class', classAttr).removeAttr('data-id');
                        }
                      }
                      /**
                       * Generate section preview
                       */

                    }, {
                      key: "generatePreview",
                      value: function generatePreview() {
                        var _this25 = this;

                        var silent = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;

                        if (!silent) {
                          TVE.Theme.utils.loadingMessage('Updating section preview.', 'update-preview');
                        }

                        this.startPreview();
                        this.getPreviewPromise().then(function (preview) {
                          return _this25.savePreview(preview, silent);
                        });
                      }
                      /**
                       * Create and return a promise for the preview image that checks if it exists. If it doesn't, it generates a preview
                       *
                       * @return {Promise<any>}
                       */

                    }, {
                      key: "getPreviewPromise",
                      value: function getPreviewPromise() {
                        var _this26 = this;

                        return new Promise(function (resolve, reject) {
                          if (_this26.previewImage) {
                            resolve(_this26.previewImage);
                            delete _this26.previewImage;
                          } else {
                            var $contentToPreview = _this26.getContentToPreview();

                            TVE.generateElementPreview($contentToPreview, function (image) {
                              $contentToPreview.parent(".".concat(TVE.Theme.constants.PREVIEW_SECTION_WRAPPER_CLASS)).remove();
                              resolve(image);
                            }, TVE.$.extend(true, {}, TVE.Theme.constants.defaultPreviewOptions), true);
                          }
                        });
                      }
                      /**
                       * Save the generated preview, then do some stuff after finishing
                       *
                       * @param image
                       * @param silent
                       */

                    }, {
                      key: "savePreview",
                      value: function savePreview(image) {
                        var _this27 = this;

                        var silent = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
                        TVE.Theme.utils.savePreviewImage({
                          'url': "".concat(TVE.CONST.theme.routes.sections, "/").concat(this.ID, "/preview/"),
                          'action': 'section_preview',
                          'image': image,
                          'ID': this.ID
                        }).done(this.applyPreview.bind(this)).always(function () {
                          if (!silent) {
                            TVE.Theme.utils.loadingMessage(false, 'update-preview');
                          }
                          /* always remove this class, even on errors */


                          _this27.$element.removeClass('tcb-generating-preview section-no-overlay');
                        });
                      }
                      /**
                       * Show components depending on the type of section
                       */

                    }, {
                      key: "toggleComponents",
                      value: function toggleComponents() {
                        var componentAvailable = this.isDynamic() && this.inEditMode() || !this.isDynamic();
                        TVE.Components['background'].toggle(componentAvailable);
                        TVE.Components['borders'].toggle(componentAvailable);
                        TVE.Components['shadow'].toggle(componentAvailable);
                        TVE.Components['layout'].toggle(componentAvailable);
                        TVE.Components['decoration'].toggle(componentAvailable);
                        TVE.Components['typography'].toggle(componentAvailable);
                        TVE.Components['responsive'].toggle(componentAvailable);
                      }
                      /**
                       *Returns the outerHTML of a specific bg video
                       *
                       * @returns {boolean}
                       */

                    }, {
                      key: "getBackgroundVideo",
                      value: function getBackgroundVideo() {
                        var $iframe = this.$background.children('iframe'),
                            $wistia = this.$background.children('.wistia_embed').empty(),
                            $custom = this.$background.children('video.tcb-bg-video'),
                            $yt = this.$background.children('div.tcb-yt-bg'); // content is cleaned before this is called. https://github.com/ThriveThemes/thrive-theme/commit/9f9fe9075094b8e74789ec57e3c74bff8b75871a

                        var video = false;

                        if ($iframe.length) {
                          if ($iframe.hasClass('tcb-yt-bg')) {
                            video = '<div id="' + $iframe.attr('id') + '" class="tcb-yt-bg" data-url="' + $iframe.attr('data-url') + '" data-yt-id="' + $iframe.attr('data-yt-id') + '"></div>';
                          } else {
                            video = $iframe.get(0).outerHTML;
                          }
                        } else if ($yt.length) {
                          video = $yt[0].outerHTML;
                        } else if ($wistia.length) {
                          video = '';
                          $wistia.siblings('script').add($wistia).each(function () {
                            video += this.outerHTML;
                          });
                        } else if ($custom.length) {
                          video = $custom.get(0).outerHTML;
                        }

                        return video;
                      }
                      /**
                       * Return object with clip id and svg decoration that can be set on the section element
                       */

                    }, {
                      key: "getDecoration",
                      value: function getDecoration() {
                        var decoration = {};
                        var bgVideo = this.getBackgroundVideo(),
                            $svgs = this.$background.find('svg');

                        if ($svgs.length) {
                          decoration = {
                            'clip-id': this.$background.attr('data-clip-id') || '',
                            'svg': ''
                          };
                          $svgs.each(function (index, element) {
                            decoration.svg += element.outerHTML;
                          });
                        }

                        if (bgVideo) {
                          decoration.video = bgVideo;
                        }

                        return decoration;
                      }
                      /**
                       * Extra characteristics specific to the theme section
                       */

                    }, {
                      key: "getExtra",
                      value: function getExtra() {
                        var extra = {
                          decoration: this.getDecoration(),
                          comments: this.getCommentsMeta(),
                          attr: this.getAttributes()
                        };
                        /* for list templates, also save the posts_per_page of the List element */

                        if (TVE.Theme.template.isList()) {
                          var $blogList = TVE.inner.$body.find(TVE.identifier('blog_list'));
                          extra['posts_per_page'] = $blogList.attr('data-posts_per_page');

                          if (TVE.Theme.template.isBlog()) {
                            /* save the query when we're on the blog list */
                            extra['query'] = $blogList.attr('data-query');
                          }
                        }

                        return TVE.apply_filters('theme.section.data.extra', extra, this);
                      }
                      /**
                       * Return the attributes set on the element ( only classes for now, will be extended ).
                       */

                    }, {
                      key: "getAttributes",
                      value: function getAttributes() {
                        return {
                          'class': TVE.Theme.utils.getElementResponsiveClasses(this.$element[0]).join(' ')
                        };
                      }
                      /**
                       * If this section has a comment form inside it, save the comments meta in this section.
                       */

                    }, {
                      key: "getCommentsMeta",
                      value: function getCommentsMeta() {
                        var commentsMeta = {};
                        var $commentElement = this.$element.find(TVE.identifier('thrive_comments'));

                        if ($commentElement.length > 0) {
                          var labels = {},
                              icons = {};

                          _.each($commentElement, function (cElem) {
                            var $cElem = TVE.$(cElem),
                                $labels = $cElem.find('.theme-comments-label'),
                                $inputs = $cElem.find('input, textarea'); //Clean up Froala

                            TVE.Editor_Page.content_manager.cleanup_froala($labels); //For each label we add it for save

                            _.each($labels, function (lElem) {
                              /**
                               * CLear the label
                               */
                              TVE.$(lElem).find('small').remove();
                              labels[lElem.getAttribute('data-comments-label')] = lElem.innerHTML.replace('<span class="required">*</span>', '');
                            }); //For each input we save the placeholders


                            _.each($inputs, function (iElem) {
                              if (!labels["placeholder_".concat(iElem.getAttribute('name'))]) {
                                labels["placeholder_".concat(iElem.getAttribute('name'))] = iElem.getAttribute('placeholder');
                              }
                            });
                          });

                          var $reply = $commentElement.find('.comment-list .reply').first(),
                              replyLabels = this.getReplyAttr($reply); //Submit Button Icon

                          var $submitButtonIcon = $commentElement.find('.comment-form-submit .thrv_icon');
                          icons.submit_button = $submitButtonIcon.length ? $submitButtonIcon.get(0).outerHTML : '';
                          icons.reply_button = $commentElement.find('.comment-reply-link .thrv_icon').first().html();
                          labels['no_comments'] = TVE.Editor_Page.content_manager.get_clean_content({}, this.$element.find('.no-comments'));
                          labels['error_msg'] = this.$element.find('.thrive-theme-comments-error-msg').html();
                          commentsMeta = {
                            labels: _objectSpread({}, labels, {}, replyLabels),
                            icons: icons
                          };
                        }

                        return commentsMeta;
                      }
                      /**
                       * @param $reply
                       * @return {{'reply-button-size': *, reply_label: *, reply_icon_flip: string, 'reply-button-style': *, 'reply-button_layout': *}}
                       */

                    }, {
                      key: "getReplyAttr",
                      value: function getReplyAttr($reply) {
                        return {
                          'reply_icon_flip': $reply.hasClass('tcb-flip') ? 'tcb-flip' : '',
                          'reply-button-style': $reply.attr('data-button-style'),
                          'reply-button_layout': $reply.attr('data-button_layout'),
                          'reply-button-size': $reply.attr('data-button-size'),
                          'reply_label': $reply.find('.tcb-button-text').first().text()
                        };
                      }
                      /**
                       * Check if a section has full width or not
                       * @returns {boolean}
                       */

                    }, {
                      key: "isOutsideContent",
                      value: function isOutsideContent() {
                        return this.$element.parent().is(TVE.identifier('template-wrapper'));
                      }
                      /**
                       * Remove the section overlay to prevent it from showing in the preview - this is regenerated again on click, so we don't lose it
                       */

                    }, {
                      key: "removeOverlay",
                      value: function removeOverlay() {
                        this.$element.addClass('section-no-overlay').remove('.section-overlay');
                      }
                      /**
                       * Returns true if the section is top or bottom, false if it's not.
                       *
                       * @return {boolean}
                       */

                    }, {
                      key: "isHorizontal",
                      value: function isHorizontal() {
                        return this.type === 'top' || this.type === 'bottom';
                      }
                      /**
                       * Returns true if the section is a content or a sidebar, false if it's not.
                       *
                       * @return {boolean}
                       */

                    }, {
                      key: "isVertical",
                      value: function isVertical() {
                        return this.type === 'content' || this.type === 'sidebar';
                      }
                    }, {
                      key: "baseSelector",
                      get: function get() {
                        return ".".concat(this.type, "-section");
                      }
                    }, {
                      key: "selector",
                      get: function get() {
                        return this.ID ? ".thrive-section-".concat(this.ID) : this.baseSelector;
                      }
                    }], [{
                      key: "getTemplateId",
                      value: function getTemplateId() {
                        return TVE.Theme.template.ID;
                      }
                      /**
                       * Return if the template where the section is placed, is singular or not
                       *
                       * @returns {Boolean}
                       */

                    }, {
                      key: "isOnSingularTemplate",
                      value: function isOnSingularTemplate() {
                        return TVE.Theme.template.isSingular();
                      }
                    }, {
                      key: "getLoadArguments",
                      value: function getLoadArguments() {
                        return {
                          query_vars: TVE.Theme.CONST.query_vars,
                          template_id: TVE.Theme.template.ID
                        };
                      }
                    }, {
                      key: "identifier",
                      get: function get() {
                        return '.theme-section';
                      }
                    }, {
                      key: "component",
                      get: function get() {
                        return TVE.Components['theme_section'];
                      }
                    }, {
                      key: "typographySuffix",
                      get: function get() {
                        return ['p', 'li', 'label', '.tcb-plain-text', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6'];
                      }
                    }, {
                      key: "contentSelector",
                      get: function get() {
                        return '.section-content';
                      }
                    }, {
                      key: "backgroundSelector",
                      get: function get() {
                        return '.section-background';
                      }
                    }]);

                    return Section;
                  }(AbstractSection);

                  module.exports = Section;
                },
                "template.js": function templateJs(exports, module, require) {
                  var Template =
                  /*#__PURE__*/
                  function () {
                    function Template(template) {
                      var _this28 = this;

                      _classCallCheck(this, Template);

                      _.each(template, function (value, key) {
                        _this28[key] = value;
                      });
                    }
                    /**
                     * Getter and setter for the meta values
                     *
                     * @param key
                     * @param value
                     * @returns {*}
                     */


                    _createClass(Template, [{
                      key: "meta",
                      value: function meta(key, value) {
                        var meta = this.meta_input;

                        if (typeof value !== 'undefined') {
                          meta[key] = value;
                          this.meta_input = meta;
                        }

                        return meta[key];
                      }
                    }, {
                      key: "primary",
                      value: function primary() {
                        return this.meta('primary_template');
                      }
                    }, {
                      key: "secondary",
                      value: function secondary() {
                        return this.meta('secondary_template');
                      }
                    }, {
                      key: "variable",
                      value: function variable() {
                        return this.meta('variable_template');
                      }
                    }, {
                      key: "format",
                      value: function format() {
                        return this.meta('format');
                      }
                      /**
                       * @return {boolean}
                       */

                    }, {
                      key: "isSingular",
                      value: function isSingular() {
                        return this.primary() === TVE.Theme.constants.templates.SINGULAR ||
                        /* also check if this is a singular homepage */
                        this.primary() === TVE.Theme.constants.templates.HOME && this.secondary() === TVE.Theme.constants.templates.PAGE;
                      }
                      /**
                       * Check if the current template is a blog
                       * @return {boolean|boolean}
                       */

                    }, {
                      key: "isBlog",
                      value: function isBlog() {
                        return this.primary() === TVE.Theme.constants.templates.HOME && this.secondary() === TVE.Theme.constants.templates.BLOG;
                      }
                      /**
                       * Returns true if the template is a search template
                       *
                       * @return {boolean}
                       */

                    }, {
                      key: "isSearch",
                      value: function isSearch() {
                        return this.primary() === TVE.Theme.constants.templates.SEARCH;
                      }
                      /**
                       * Returns true if the template is an author template
                       *
                       * @return {boolean}
                       */

                    }, {
                      key: "isAuthor",
                      value: function isAuthor() {
                        return this.primary() === TVE.Theme.constants.templates.AUTHOR;
                      }
                      /**
                       * Check the template is for a list
                       * @return {boolean}
                       */

                    }, {
                      key: "isList",
                      value: function isList() {
                        var primary = this.primary();
                        return primary === TVE.Theme.constants.templates.ARCHIVE || primary === TVE.Theme.constants.templates.SEARCH || this.isBlog();
                      }
                      /**
                       * Check if template is archive
                       * @return {boolean}
                       */

                    }, {
                      key: "isArchive",
                      value: function isArchive() {
                        return this.primary() === TVE.Theme.constants.templates.ARCHIVE;
                      }
                      /**
                       * @return {boolean}
                       */

                    }, {
                      key: "is404",
                      value: function is404() {
                        return this.primary() === TVE.Theme.constants.templates.error404;
                      }
                      /**
                       * Check if we're on a WooCommerce template
                       * @returns {boolean}
                       */

                    }, {
                      key: "isWoo",
                      value: function isWoo() {
                        return this.isProduct() || this.isShop(true) || this.isWooPage();
                      }
                      /**
                       * Check if we're on a shop template
                       * @param {boolean} includeProductArchive extend check to product archive types
                       * @return {boolean|boolean}
                       */

                    }, {
                      key: "isShop",
                      value: function isShop() {
                        var includeProductArchive = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
                        var secondaryTypes = [TVE.Theme.constants.templates.PRODUCT];

                        if (includeProductArchive) {
                          secondaryTypes.push('product_tag', 'product_cat');
                        }

                        return this.isArchive() && secondaryTypes.includes(this.secondary());
                      }
                      /**
                       * Check if we're on a product template
                       * @return {boolean|boolean}
                       */

                    }, {
                      key: "isProduct",
                      value: function isProduct() {
                        return this.isSingular() && this.secondary() === TVE.Theme.constants.templates.PRODUCT;
                      }
                      /**
                       * Check if we're on a woo page template
                       * @return {boolean|boolean}
                       */

                    }, {
                      key: "isWooPage",
                      value: function isWooPage() {
                        return this.isSingular() && (this.isCart() || this.isCheckout() || this.isAccount());
                      }
                      /**
                       * @return {boolean}
                       */

                    }, {
                      key: "isCart",
                      value: function isCart() {
                        return this.secondary() === TVE.Theme.constants.templates.CART;
                      }
                      /**
                       * @return {boolean}
                       */

                    }, {
                      key: "isCheckout",
                      value: function isCheckout() {
                        return this.secondary() === TVE.Theme.constants.templates.CHECKOUT;
                      }
                      /**
                       * @return {boolean}
                       */

                    }, {
                      key: "isAccount",
                      value: function isAccount() {
                        return this.secondary() === TVE.Theme.constants.templates.ACCOUNT;
                      }
                      /**
                       * Get the layout data saved on the template -> anything that we find in 'currentData' that is different from 'lastSavedData' must be saved
                       *
                       * @return {*}
                       */

                    }, {
                      key: "getLayoutDataToSave",
                      value: function getLayoutDataToSave() {
                        var currentData = TVE.Theme.models.Layout.getDataFromPage(),
                            lastSavedData = TVE.Theme.models.Layout.getInstance().getMeta();
                        var data = {};

                        _.each(currentData, function (value, key) {
                          if (lastSavedData && lastSavedData[key] !== value) {
                            data[key] = value;
                          }
                        });

                        return data;
                      }
                    }]);

                    return Template;
                  }();

                  module.exports = Template;
                }
              },
              "selectors.js": function selectorsJs(exports, module, require) {
                /* elements that have icons inside and we have to sync */
                var Constants = require('./constants'),
                    icons = ['.thrive-breadcrumbs', '.search-submit', '.thrive-dynamic-styled-list-item', '#comments', '.tve-off-screen-sidebar-trigger', '.tve-sidebar-close-icon'],
                    removeOnSave = ['#thrive-header', '#thrive-footer', '.main-no-results', '.preview-cloned-content', '.thrive-progress-bar', '.tve-sidebar-close-icon', ".".concat(Constants.PREVIEW_SECTION_WRAPPER_CLASS), ".".concat(Constants.PREVIEW_TEMPLATE_WRAPPER_CLASS)],
                    haveDynamicPrefix = {
                  'thrive_dynamic_list': ['dynamic-list-icon', 'dynamic-list-item', 'dynamic-list-text'],
                  'thrive_breadcrumbs': ['breadcrumbs_leaf', 'breadcrumbs_path', 'breadcrumbs_icon'] //TODO: add all comment elements

                },

                /* the content and sidebar selectors are 'special' because unlike the other sections, they can have an icon */
                contentAndSidebarSelector = '.theme-section[data-section="content"] > div,.theme-section[data-section="sidebar"] > div',
                    prevNextSelectors = '.thrive_prev_next .thrv-prev-next-button, .thrive_prev_next .tcb-col, .thrive_prev_next .thrv-columns';
                /* elements that don't have icons */


                var noIcons = _.map(_.filter(tcb_main_const.elements, function (element) {
                  return element.has_icons === false;
                }), function (el) {
                  return el.identifier;
                });
                /* the icon sub-elements don't have operation icons (drag clone delete) */


                icons.forEach(function (icon) {
                  return noIcons.push(icon + ' .thrv_icon');
                });
                /* some really specific elements that don't have icons */

                noIcons = noIcons.concat(['.thrv-inline-text', '.theme-section:not([data-section="content"],[data-section="sidebar"]) > div']);
                /* elements that are saved as shortcodes */

                var shortcodes = {},
                    themeButtons = _.map(_.filter(tcb_main_const.elements, function (element) {
                  return element.is_theme_button === true;
                }), function (el) {
                  return el.identifier;
                });

                _.each(tcb_main_const.elements, function (element) {
                  if (element.shortcode) {
                    shortcodes[element.identifier] = element.shortcode;
                  }
                });
                /* elements that have selectors and will not generate a new data-css */


                var haveSelector = _.map(_.filter(tcb_main_const.elements, function (element) {
                  return element.has_selector === true;
                }), function (el) {
                  return el.identifier;
                });
                /* add more dynamic element selectors */


                haveSelector = haveSelector.concat(Constants.dynamic_selectors);
                var
                /* '.theme-section > div' is added on purpose so it's matched and removed in the _.difference() call below */
                noDragDrop = noIcons.concat(['div.tcb-col', 'a.tve-froala', '.theme-section > div', '.tve_editable.thrv_symbol', '.tve-sidebar-close-icon']),
                    noClone = ['#comments', '.theme-dynamic-icon', contentAndSidebarSelector, prevNextSelectors],
                    noDelete = [contentAndSidebarSelector, prevNextSelectors],
                    elements = Object.values(TVE.CONST.theme.element_selectors).filter(function (element) {
                  return element !== '#main';
                }),
                    editor = {
                  elements: elements,
                  containers: ['.section-content', '.tve_shortcode_editor'],
                  theme_buttons: themeButtons,
                  no_drag: noDragDrop,

                  /* they are special because we treat them separately at save */
                  have_selector: haveSelector,

                  /* elements that don't allow elements inside them and we can't take elements from inside them */
                  compact_elements: ['.tcb-post-content', 'section.widget']
                };
                /* the things added in 'noDragDrop' have to match the element selectors, or they're not removed here because they don't match */

                editor.dragenter = editor.droppable = _.difference(elements.concat(['.tve-droppable', '.thrv_text_element p']), noDragDrop);
                /* not everything that is droppable (that can receive drop events) has to be draggable. There's a distinction between the 2 */

                editor.draggable = _.difference(elements, noDragDrop);
                editor.editable = elements;
                editor.architect = {
                  editable: editor.editable,
                  mouseover: editor.editable,
                  no_icons: noIcons,
                  no_clone: noClone,
                  no_delete: noDelete,
                  no_lock: ['.thrive-breadcrumbs'],
                  no_unlock: ['.thrive-breadcrumbs'],
                  not_editable: ['.tcb-post-content *', '.thrive_author_box:not(.tcb-compact-edit-mode) *'],
                  no_highlight: ['.tcb-post-content *', '.thrive_author_box:not(.tcb-compact-edit-mode) *', '.theme-section[data-id]:not(.tcb-compact-edit-mode) *'],
                  no_save: [].concat(_toConsumableArray(Object.keys(shortcodes)), ['#comments', '.tve_lg_input_container', '.thrv_symbol', '.tcb-col', contentAndSidebarSelector, prevNextSelectors])
                };
                module.exports = {
                  haveDynamicPrefix: haveDynamicPrefix,
                  removeOnSave: removeOnSave,
                  shortcodes: shortcodes,
                  editor: editor,
                  icons: icons
                };
              },
              "utils.js": function utilsJs(exports, module, require) {
                (function ($) {
                  var Layout = require('./models/layout'),
                      Section = require('./models/section'),
                      HFSection = require('./models/hf-section');

                  module.exports = {
                    /**
                     * Display a loading message.
                     * If we have the message, we lower the "box" and set the message, otherwise we move it out of the screen
                     * This function can handle more than one message and it stacks them
                     * @param message
                     * @param messageTag
                     */
                    loadingMessage: function loadingMessage() {
                      var message = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
                      var messageTag = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';

                      if (message) {
                        var $element = $(TVE.tpl('theme-main/loading')({
                          message: message,
                          messageTag: messageTag
                        })).appendTo($('#tt-loading-wrapper'));
                        setTimeout(function () {
                          $element.css('top', '0');
                        }, 1);
                      } else {
                        var _$element = $('.tt-loading');

                        if (messageTag) {
                          _$element = _$element.filter("[data-tag=\"".concat(messageTag, "\"]"));
                        }

                        if (_$element) {
                          _$element.css('top', '-400px');

                          setTimeout(function () {
                            _$element.remove();
                          }, 1000);
                        }
                      }
                    },

                    /**
                     * Get element attributes
                     * @param element
                     * @param {Array} exclude attributes that we want to exclude
                     * @param {Boolean} just_data return just the data attributes
                     * @param {Boolean} shortcode_encoded encode [ and ] characters so the shortcodes won't mess the shortcode regex
                     * @returns {{}}
                     */
                    element_attributes: function element_attributes(element) {
                      var exclude = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
                      var just_data = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
                      var shortcode_encoded = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;

                      if (element.jquery) {
                        element = element[0];
                      }

                      var attributes = {};

                      _.each(element.attributes, function (attr) {
                        if (exclude.indexOf(attr.name) !== -1) {
                          return;
                        }

                        var value = attr.value;

                        if (shortcode_encoded) {
                          value = value.replace(/\[/g, '|{|').replace(/\]/g, '|}|');
                        }

                        if (!just_data) {
                          attributes[attr.name] = value;
                        } else if (attr.name.indexOf('data-') === 0) {
                          attributes[attr.name.replace('data-', '')] = value;
                        }
                      });

                      return attributes;
                    },

                    /**
                     * Function for saving options.
                     * Uses the /options route from class-thrive-options-rest.php
                     * @param name
                     * @param value
                     * @param silent
                     * @param successText
                     * @param errorText
                     */
                    save_options: function save_options(name, value) {
                      var silent = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
                      var successText = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 'Options saved!';
                      var errorText = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 'Error saving options!';
                      $.post({
                        headers: {
                          'X-WP-Nonce': TVE.CONST.rest_nonce
                        },
                        url: TVE.CONST.theme.routes.options,
                        data: {
                          'name': name,
                          'value': value
                        },
                        success: function success(response) {
                          if (!silent) {
                            TVE.page_message(successText, false, 5000);
                          }
                        },
                        error: function error(response) {
                          if (!silent) {
                            TVE.page_message(errorText, true, 5000);
                          }
                        }
                      });
                    },

                    /**
                     * Return an array of responsive classes --> tcb-desktop-hidden / tcb-tablet-hidden / tcb-mobile-hidden
                     * @param element
                     * @returns {Array}
                     */
                    getElementResponsiveClasses: function getElementResponsiveClasses(element) {
                      var regex = /tcb-\w*-hidden/g,
                          cls = [];
                      var match;

                      while ((match = regex.exec(element.className)) !== null) {
                        if (match.index === regex.lastIndex) {
                          regex.lastIndex++;
                        }

                        if (match.length) {
                          cls.push(match[0]);
                        }
                      }

                      return cls;
                    },

                    /**
                     * Ajax request with nonce included
                     * @param url
                     * @param data
                     * @param method
                     * @param success
                     * @param error
                     * @param always
                     * @return {*}
                     */
                    ajax: function ajax(url, data) {
                      var method = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'POST';
                      var success = arguments.length > 3 ? arguments[3] : undefined;
                      var error = arguments.length > 4 ? arguments[4] : undefined;
                      var always = arguments.length > 5 ? arguments[5] : undefined;
                      return $.ajax({
                        headers: {
                          'X-WP-Nonce': TVE.CONST.rest_nonce
                        },
                        url: url,
                        method: method,
                        data: data,
                        success: success,
                        error: error,
                        always: always
                      });
                    },

                    /**
                     * Ajax request to get the html for the dynamic list element
                     *
                     * @param args
                     * @param callback
                     */
                    fetch_list: function fetch_list(args, callback) {
                      $.ajax({
                        headers: {
                          'X-WP-Nonce': TVE.CONST.rest_nonce
                        },
                        url: TVE.CONST.theme.routes.list,
                        method: 'GET',
                        data: {
                          args: args,
                          'demo-content': TVE.Theme.CONST.is_demo_content
                        },
                        success: function success(response) {
                          if (response.success === 1) {
                            typeof callback === 'function' && callback(response);
                          }
                        },
                        error: function error(response) {
                          TVE.page_message('There has been an error and the list could not be generated', true, 5000);
                        }
                      });
                    },

                    /**
                     * Return a regexp containing all the pseudo-selectors.
                     *
                     * @returns {RegExp}
                     */
                    pseudoSelectorsRegex: function pseudoSelectorsRegex() {
                      return new RegExp([':hover', ':active', ':after', ':focus', '::after', ':before', '::before', '::placeholder', '.tve-state-active', '.tve-state-expanded'].join('|'), 'gi');
                    },

                    /**
                     * Replaces $element tags with newTagString which is of structure <div></div>
                     *
                     * @param $element
                     * @param newTagString
                     *
                     * @returns bool
                     */
                    replaceElementTag: function replaceElementTag($element, newTagString) {
                      var $newElem = TVE.inner_$(newTagString, {
                        html: $element.html()
                      });
                      $.each($element[0].attributes, function () {
                        $newElem.attr(this.name, this.value);
                      });
                      $element.replaceWith($newElem);
                      return $newElem;
                    },

                    /**
                     * Replace real data for situations where we don't have an existing post data in backend like template import
                     *
                     * @param $container
                     */
                    inline_shortcodes_init: function inline_shortcodes_init($container) {
                      $container.find('.thrive-shortcode-content').each(function (index, shortcode) {
                        var $shortcode = $(shortcode),
                            shortcode_name = shortcode.dataset.shortcode;

                        if (shortcode_name === 'tcb_post_published_date') {
                          return true;
                        }

                        if (TVE.PostList.posts && TVE.inner.window.thrive_page_params && shortcode_name) {
                          var ID = TVE.PostList.utils.getArticleID($shortcode);
                          /* The ID could be undefined if somehow the user adds a shortcode outside the blog list */

                          if (ID) {
                            var $new = TVE.inner_$(TVE.apply_filters('tcb.post_list_article.sync.' + shortcode_name, TVE.PostList.posts[ID][shortcode_name], TVE.PostList.posts[ID], $shortcode));

                            if ($new.length) {
                              $shortcode.html($new.text());
                            }
                          }
                        }
                      });
                    },
                    image_shortcodes_init: function image_shortcodes_init($container) {
                      $container.find('.thrive-shortcode-content[data-shortcode="tcb_post_author_picture"]').each(function (index, shortcode) {
                        var $shortcode = $(shortcode),
                            shortcode_name = shortcode.dataset.shortcode;

                        if (TVE.PostList.posts && TVE.inner.window.thrive_page_params && shortcode_name) {
                          var ID = TVE.PostList.utils.getArticleID($shortcode);

                          if (ID) {
                            var $new = TVE.inner_$(TVE.apply_filters('tcb.post_list_article.sync.' + shortcode_name, TVE.PostList.posts[ID][shortcode_name], TVE.PostList.posts[ID], $shortcode));

                            if ($new.length) {
                              $shortcode.replaceWith($new);
                            }
                          }
                        }
                      });
                    },

                    /**
                     * Remove every regex match from a string except for the first occurrence
                     *
                     * @param string
                     * @param regex
                     * @param replacement
                     * @returns {*}
                     */
                    replace_all_but_first: function replace_all_but_first(string, regex, replacement) {
                      var regExp = new RegExp(regex, 'g');
                      var count = 1;
                      return string.replace(regExp, function (match) {
                        var replace = count === 1 ? match : replacement;
                        count++;
                        return replace;
                      });
                    },

                    /**
                     * Add brackets to string, used for inline shortcodes management
                     *
                     * @param string
                     * @returns {*}
                     */
                    applyBrackets: function applyBrackets(string) {
                      return "[".concat(string, "]");
                    },

                    /**
                     * Remove brackets from string and return first part which is the name, used for inline shortcodes management
                     *
                     * @param string
                     * @returns {*}
                     */
                    extractShortcodeName: function extractShortcodeName(string) {
                      return string.split(' ')[0];
                    },

                    /**
                     * Returns true if the given element is inside a symbol (or is a symbol), false if it's not.
                     *
                     * @param $element
                     * @returns {boolean}
                     */
                    isInsideSymbol: function isInsideSymbol($element) {
                      var insideSymbol;
                      /* flag used in case we want to overwrite the base verification if an element is inside a symbol or not */

                      if (typeof TVE.Theme.FLAGS.INSIDE_SYMBOL_OVERWRITE === 'boolean') {
                        insideSymbol = TVE.Theme.FLAGS.INSIDE_SYMBOL_OVERWRITE;
                      } else {
                        insideSymbol = $element && $element.closest("".concat(TVE.identifier('symbol').trim(), "[data-id]")).length > 0;
                        /**
                         * @param {Boolean} insideSymbol
                         * @param {jQuery} $element
                         */

                        insideSymbol = TVE.apply_filters('theme.is_element_inside_symbol', insideSymbol, $element);
                      }

                      return insideSymbol;
                    },

                    /**
                     * Toggle the disabled state for some controls.
                     *
                     * @param toggle
                     * @param controls
                     * @param controlsToToggle
                     */
                    toggle_controls: function toggle_controls(toggle, controls, controlsToToggle) {
                      var _iteratorNormalCompletion2 = true;
                      var _didIteratorError2 = false;
                      var _iteratorError2 = undefined;

                      try {
                        for (var _iterator2 = controlsToToggle[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
                          var key = _step2.value;

                          if (controls[key]) {
                            controls[key].toggle_disabled(toggle);
                          }
                        }
                      } catch (err) {
                        _didIteratorError2 = true;
                        _iteratorError2 = err;
                      } finally {
                        try {
                          if (!_iteratorNormalCompletion2 && _iterator2["return"] != null) {
                            _iterator2["return"]();
                          }
                        } finally {
                          if (_didIteratorError2) {
                            throw _iteratorError2;
                          }
                        }
                      }
                    },

                    /**
                     * Toggle the disabled state for all the components of the given element except the given component.
                     *
                     * @param toggle
                     * @param exceptionComponent
                     */
                    disable_components: function disable_components(toggle, exceptionComponent) {
                      var components = TVE.Elements[TVE._type(TVE.ActiveElement)].components;

                      for (var key in components) {
                        if (components.hasOwnProperty(key) && exceptionComponent !== key) {
                          TVE.Components[key].$el.toggleClass('disabled-children', toggle);
                        }
                      }
                    },

                    /**
                     * Return prefix based on the cssText style so we can make styles specific for each template.
                     *
                     * @param {jQuery} $element
                     * @param {String} cssText
                     * @returns {String}
                     */
                    templatePrefix: function templatePrefix($element) {
                      var cssText = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';

                      if (!$element || TVE.Theme.FLAGS.duringImport || !TVE.CONST.theme.is_theme_template || this.isInsideSymbol($element)) {
                        /* those prefixes are only for the theme templates elements */
                        return cssText;
                      }
                      /**
                       * Change the target that is being prefixed.
                       * Useful when the element is not physically inside the section
                       *
                       * @param {jQuery} $element
                       */


                      $element = TVE.apply_filters('theme.css.change_prefix_target', $element);
                      var prefix = TVE.Theme.CONST.body_class;
                      var sectionInstance = this.getSectionInstance($element);

                      if (TVE.Theme.FLAGS.LAYOUT_CSS_WRITE) {
                        /* we add this prefix which does not affect the css, but it will help us to identify layout css */
                        prefix = "".concat(Layout.prefix, " ").concat(prefix);
                      }

                      if (sectionInstance) {
                        /* Dynamic sections don't need any prefix. Normal ones have the body class */
                        if (sectionInstance.constructor.is($element)) {
                          if (sectionInstance.isDynamic()) {
                            prefix = '';
                          }
                          /* for dynamic sections, content and background has only section type in data-selector so we add the section class as prefix.
                          * static sections have the section type in the data selector so we don't need to add anything else, body class was already added. */

                        } else if (sectionInstance.isContent($element) || sectionInstance.isBackground($element)) {
                          if (sectionInstance.isDynamic()) {
                            prefix = sectionInstance.selector;
                          }
                        } else {
                          if (sectionInstance.isDynamic()) {
                            prefix = sectionInstance.selector;
                          } else {
                            prefix = "".concat(prefix, " ").concat(sectionInstance.selector);
                          }
                        }
                      }

                      if (cssText.includes(prefix)) {
                        /* if the cssText style already has the body class and section, there's nothing much to do */
                        return cssText;
                      }
                      /* make sure we remove the body class from the selector so we won't have it twice */


                      cssText = cssText.replace(this.escapedRegEx(TVE.Theme.CONST.body_class, 'g'), '');

                      if (cssText.includes(TVE.CONST.global_css_prefix)) {
                        prefix = "".concat(TVE.CONST.global_css_prefix, " ").concat(prefix);
                        /* make sure the global prefix is added at the beginning and remove it from the cssText */

                        cssText = cssText.replace(this.escapedRegEx(TVE.CONST.global_css_prefix, 'g'), '');
                      }
                      /* if we have full css selector text where we have to replace the prefix, we split it so we won't match comma inside the css like rgb (24, 24, 24) and others */


                      if (cssText.includes('{')) {
                        prefix = cssText.replace(/(.*){(.*)/g, function (m, cssSelector, cssStyle) {
                          return (
                            /* split selector by comma */
                            cssSelector.split(', ')
                            /* for each selector add the prefix */
                            .map(function (selector) {
                              return "".concat(prefix, " ").concat(selector);
                            })
                            /* put everything back */
                            .join(', ') + '{' + cssStyle
                          );
                        });
                      } else {
                        prefix = cssText.split(', ').map(function (selector) {
                          return "".concat(prefix, " ").concat(selector);
                        }).join(', ');
                      }

                      return prefix;
                    },

                    /**
                     * Change css rules when inserting a cloud template inside sections or theme template
                     *
                     * @param rules
                     * @returns {*}
                     */
                    cssRulesBeforeInsert: function cssRulesBeforeInsert(rules) {
                      var inSymbolEditMode = TVE.main.EditMode.in_edit() && TVE.main.EditMode.element().is(TVE.identifier('symbol'));
                      /* the symbol has his own functionality that takes care of things */

                      if (!inSymbolEditMode) {
                        var desktopMediaRule = TVE.CSS_Rule_Cache.media_rule(TVE.main.responsive.desktop.media);

                        for (var i = 0; i < rules.length; i++) {
                          switch (rules[i].type) {
                            case CSSRule.MEDIA_RULE:
                              for (var j = 0; j < rules[i].cssRules.length; j++) {
                                var cssText = TVE.Theme.utils.templatePrefix(TVE.ActiveElement, rules[i].cssRules[j].cssText);
                                rules[i].deleteRule(j);
                                rules[i].insertRule(cssText, j);
                              }

                              break;

                            case CSSRule.STYLE_RULE:
                              /**
                               * Prefix css variables too
                               */
                              var prefixedRule = rules[i];
                              prefixedRule.selectorText = TVE.Theme.utils.templatePrefix(TVE.ActiveElement, rules[i].selectorText);
                              desktopMediaRule.insertStyleRule(prefixedRule);
                              break;

                            default:
                              break;
                          }
                        }
                      }

                      return rules;
                    },

                    /**
                     * Some elements like dynamic lists, breadcrumbs and others (check the lists from dynamic selectors in the selectors.js file) are saved as shortcodes
                     * so the css is relative to the parent data-css
                     * @param $element
                     * @returns {string}
                     */
                    getDynamicElementPrefix: function getDynamicElementPrefix($element) {
                      var prefix = '',
                          elementType = TVE._type($element);

                      if (!elementType) {
                        elementType = TVE._type($element.closest('.thrv_wrapper'));
                      }

                      _.each(TVE.Theme.selectors.haveDynamicPrefix, function (subElements, parentElement) {
                        if (subElements.includes(elementType)) {
                          var $parent = $element.closest(TVE.identifier(parentElement));

                          if ($parent.length) {
                            prefix = "[data-css=\"".concat(TVE.CSS_Rule_Cache.uniq_id($parent), "\"]");
                          }
                        }
                      });

                      return prefix;
                    },

                    /**
                     * Remove the specific section part from the css generated for elements within a theme section
                     *
                     * @param $element
                     * @param css
                     * @returns {*}
                     */
                    replaceThemeSectionsCss: function replaceThemeSectionsCss($element, css) {
                      var _this29 = this;

                      if (TVE.CONST.theme.is_theme_template && $element) {
                        var templatePrefix = this.templatePrefix($element);

                        if (typeof css === 'string') {
                          css = css.replace(this.escapedRegEx(templatePrefix, 'g'), '').trim();
                        } else {
                          _.each(css, function (value, key) {
                            css[key] = value.map(function (cssText) {
                              return cssText.replace(_this29.escapedRegEx(templatePrefix, 'g'), '').trim();
                            });
                          });
                        }
                      }

                      return css;
                    },

                    /**
                     * Delete all the CSS rules that contain selectors for the given element.
                     *
                     * @param $element
                     */
                    deleteCssForElement: function deleteCssForElement($element) {
                      if ($element && $element.length) {
                        _.each(TVE.stylesheet.cssRules, function (rule) {
                          /* we need the media as a parameter for the css_remove function */
                          var media = TVE.compat.conditionText(rule);

                          if (rule.type === CSSRule.MEDIA_RULE && media && media.length) {
                            var ruleSelectors = _.map(rule.cssRules, function (cssRule) {
                              return cssRule.selectorText;
                            }),

                            /* get only the rules that we want to delete */
                            rulesToDelete = _.filter(ruleSelectors, function (selector) {
                              return TVE.inner.$document.find(selector).is($element) &&
                              /* check if the selector is for this element */
                              selector.includes(TVE.Theme.CONST.body_class);
                            }
                            /* if the selector contains the body class */
                            );
                            /* delete all the rules that belonged to the element */


                            _.each(rulesToDelete, function (selector) {
                              return TVE.head_css_remove(selector, media);
                            });
                          }
                        });
                      } else {
                        console.warn('Error - Element does not exist in function "deleteCssForElement"');
                      }
                    },

                    /**
                     * Extract the image URL from the background image css.
                     * Example:
                     * in: 'background-image: url("http://wordpress.local/wp-content/uploads/2019/03/IMG_5495-e1513047453498.jpg");'
                     * out: 'http://wordpress.local/wp-content/uploads/2019/03/IMG_5495-e1513047453498.jpg'
                     * @param backgroundImageCss
                     * @returns {string}
                     */
                    getImageUrlFromCss: function getImageUrlFromCss(backgroundImageCss) {
                      var imageUrlMatchingRegex = /(?:\(['"]?)(.*?)(?:['"]?\))/,
                          m = imageUrlMatchingRegex.exec(backgroundImageCss);
                      return m === null ? '' : m[1];
                    },

                    /**
                     * Replace specific theme selectors so they won't be used later in the symbol
                     * @param css
                     * @returns {*}
                     */
                    replaceInSymbolCss: function replaceInSymbolCss(css) {
                      if (TVE.CONST.theme.is_theme_template) {
                        /**
                         * Add regex and replacement
                         *
                         * @param regex
                         * @param replacement
                         * @param escapeString
                         */
                        var addThingsToReplace = function addThingsToReplace(regex, replacement) {
                          var escapeString = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
                          var regexString = escapeString ? TVE.Theme.utils.escapeString(regex) : regex;
                          thingsToReplace.push({
                            'regex': regexString,
                            'replacement': replacement
                          });
                        };

                        var thingsToReplace = [];

                        if (typeof TVE.Elements.blog_list !== 'undefined') {
                          addThingsToReplace(TVE.identifier('blog_list'), '');
                        }

                        if (TVE.ActiveElement) {
                          addThingsToReplace(TVE.Theme.utils.templatePrefix(TVE.ActiveElement), '');
                        }
                        /**
                         * Strips also the body class from the css string only after the template prefix is deleted
                         */


                        addThingsToReplace(TVE.Theme.CONST.body_class, '');

                        _.each(thingsToReplace, function (thing) {
                          css = css.replace(new RegExp(thing.regex, 'g'), thing.replacement);
                        });
                      }

                      _.each(TVE.PostList.constants.dynamicStyles, function (dynamic_style) {
                        css = css.replace(new RegExp(dynamic_style.regex, 'g'), 'url("' + dynamic_style.replacement + '")');
                      });

                      return css;
                    },

                    /**
                     * Create new regex but escape the string first
                     * @param string
                     * @param options
                     * @returns {RegExp}
                     */
                    escapedRegEx: function escapedRegEx(string, options) {
                      return new RegExp(TVE.Theme.utils.escapeString(string), options);
                    },

                    /**
                     * Escape string for a regex
                     *
                     * @param string
                     * @returns {*}
                     */
                    escapeString: function escapeString(string) {
                      return string.replace(/[-/\\^$*+?.()|[\]{}]/g, '\\$&');
                    },

                    /**
                     * Check if a css text contains dynamic elements. Maybe make it more strict !?
                     *
                     * @param css
                     * @returns {*}
                     */
                    isDynamicCss: function isDynamicCss(css) {
                      return css.includes('dynamic_');
                    },

                    /**
                     * Check if a css text contains acf dynamic colors
                     *
                     * @param css
                     * @returns {*|boolean}
                     */
                    isDynamicColor: function isDynamicColor(css) {
                      return css.includes(TVE.CONST.colors.dynamic_prefix);
                    },

                    /**
                     * Return a target dropzone inside one of the sections.
                     * Prioritization:
                     * 1. If a section is active, try to drop there.
                     * 2. Else, get the first viable section where we can drop something. The iteration order is: content, top, sidebar, bottom.
                     * @returns {*}
                     */
                    getDropTargetSection: function getDropTargetSection() {
                      var $target, section;
                      /* if we have something selected and it is a section / is inside a section, store it */

                      if (TVE.ActiveElement) {
                        section = TVE.Theme.utils.getSectionInstance(TVE.ActiveElement);
                      }
                      /* if we stored a section above, check if it can accept drops and (if yes) set it as target */


                      if (section && TVE.Theme.utils.canDropIntoSection(section.$element)) {
                        $target = section.$element;
                      } else {
                        /* else, go through the sections in a specific order and stop at the first section that's eligible for being a drop target */
                        var targetSection = _.find(['content', 'top', 'sidebar', 'bottom'], function (section) {
                          return TVE.Theme.utils.canDropIntoSection(TVE.Theme.$sections[section]);
                        });
                        /* set the target if we found a section that can be dropped into */


                        if (typeof targetSection !== 'undefined') {
                          $target = TVE.Theme.$sections[targetSection];
                        }
                      }

                      return $target;
                    },

                    /**
                     * Check if we can drop elements in the given section.
                     *
                     * @param $section
                     * @returns {boolean}
                     */
                    canDropIntoSection: function canDropIntoSection($section) {
                      var section = this.getSectionInstance($section),
                          isDynamic = section.isDynamic();
                      /* must be visible and either static or if it's dynamic, it must be in edit mode */

                      return section.isVisible() && (!isDynamic || isDynamic && section.inEditMode());
                    },

                    /**
                     * Get css, fonts and dynamic css
                     * @returns {{css, fonts: string, dynamic}}
                     */
                    getSpecificStyle: function getSpecificStyle(selectorValidator) {
                      var _this30 = this;

                      var css = {},
                          dynamic = {};
                      var fonts = [];

                      if (typeof selectorValidator !== 'function') {
                        selectorValidator = function selectorValidator() {
                          return true;
                        };
                      }
                      /* go through all the rules */


                      _.each(TVE.stylesheet.cssRules, function (rule) {
                        /* Safari does not support CSSMediaRule.conditionText */
                        var conditionText = TVE.compat.conditionText(rule);
                        /* if we find a media rule, that is not empty */

                        if (rule.type === CSSRule.MEDIA_RULE && conditionText && conditionText.length) {
                          /* we go through each rule from the media rule */
                          _.each(rule.cssRules, function (r) {
                            /* save selectors that are not empty and for specific just for the current template */
                            if (r.style.length && selectorValidator(r.selectorText)) {
                              /* we replace the pseudo selectors with nothing so we can use jQuery to find the element in page */
                              var selector = r.selectorText.replace(_this30.pseudoSelectorsRegex(), ''),
                                  $element = TVE.inner.$document.find(selector),

                              /**
                               * Modify the css text before it is saved
                               *
                               * @param {string} cssText
                               */
                              cssText = TVE.apply_filters('theme.css_rule.before_save', r.cssText.replace(/\n/g, ' ')),

                              /**
                               * If this rule was added to the whitelist, we should save it even if the $element is missing
                               *
                               * @param {boolean}
                               * @param {string} selector
                               * @param {string} cssText
                               */
                              isWhitelisted = TVE.apply_filters('ttb.css.save.whitelist_rule', false, selector, cssText);
                              /* save selectors only for the elements that exist on the page, or if they're whitelisted */

                              if ($element.length || isWhitelisted) {
                                if (typeof css[conditionText] === 'undefined') {
                                  css[conditionText] = '';
                                }

                                if (!css[conditionText].includes(cssText.trim())) {
                                  css[conditionText] += cssText;
                                }
                                /* if we're in a post list, skip this step */


                                if ($element.closest(TVE.identifier('article')).length === 0) {
                                  _this30.saveDynamicStyle(r, dynamic);
                                }
                              }
                            }
                          });
                        } else if (rule.type === CSSRule.IMPORT_RULE && !fonts.includes(rule.cssText)) {
                          fonts.push(rule.cssText);
                        }
                      });

                      fonts = fonts.filter(function (font) {
                        return JSON.stringify(css).includes(TVE.FontManager.read_font_name(font));
                      });
                      return {
                        css: css,
                        fonts: fonts,
                        dynamic: dynamic
                      };
                    },

                    /**
                     * Check if the css rule has some dynamic text
                     * @param rule
                     * @param dynamic
                     */
                    saveDynamicStyle: function saveDynamicStyle(rule, dynamic) {
                      var css = rule.cssText,
                          style = '';
                      /* if the css contains some dynamic strings like the featured image or the author image we replace it with a shortcode and we save the css*/

                      if (this.isDynamicCss(css)) {
                        var bgRegex = /background-image: .[^;]*;/gm;
                        var selector = rule.selectorText,
                            match;

                        _.each(TVE.PostList.constants.dynamicStyles, function (dynamicStyle) {
                          css = css.replace(new RegExp(dynamicStyle.regex, 'g'), 'url("' + dynamicStyle.replacement + '")');
                        });

                        selector = TVE.remove_extra_spaces(selector);
                        match = css.match(bgRegex);

                        if (match) {
                          style = selector + '{' + match[0] + '}';
                        }
                      }
                      /* if the css contains acf dynamic colors we replace the post id with a shortcode */


                      if (this.isDynamicColor(css)) {
                        var dynamicColorsRegex = /--tcb-dynamic-color-[^,]*_(\d+)/gm,
                            _match = new RegExp(dynamicColorsRegex.exec(css)[1], 'gi');

                        if (_match) {
                          style += css.replace(_match, '[thrive_the_id]');
                        }
                      }

                      if (style) {
                        /* Safari does not support CSSMediaRule.conditionText */
                        var conditionText = TVE.compat.conditionText(rule.parentRule);

                        if (typeof dynamic[conditionText] === 'undefined') {
                          dynamic[conditionText] = '';
                        }
                        /* save dynamic css inside the post list selector and for each media rule */


                        dynamic[conditionText] += style;
                      }
                    },

                    /**
                     * Set a section full width by moving it outside the template container or boxed by putting it back.
                     * @param $section
                     * @param isFullWidth
                     */
                    toggleSectionFullWidth: function toggleSectionFullWidth($section, isFullWidth) {
                      var section = $section.attr('data-section');

                      if (isFullWidth) {
                        /* move the section outside the template container */
                        TVE.Theme.$content[section === 'top' ? 'before' : 'after']($section);
                      } else {
                        /* move section inside the template container */
                        TVE.Theme.$content[section === 'top' ? 'prepend' : 'append']($section);
                      }

                      if (TVE.ActiveElement) {
                        /* refresh the breadcrumbs */
                        TVE.main.active_elem_nav_view.reset_breadcrumbs();
                      }
                    },

                    /**
                     * add link to testing page for the current template
                     */
                    addDebugButton: function addDebugButton() {
                      TVE.main.$('#sidebar-bottom').append('<a href="' + window.location.href + '&jstest=1" target="_blank" class="test-button-link preview-content tvd-fixed-right"><span>TEST</span></a>');
                    },

                    /**
                     * Get an instance of a Section or HFSection, depending on where the element is.
                     * @param {jQuery} $element
                     * @returns {Section|HFSection}
                     */
                    getSectionInstance: function getSectionInstance() {
                      var $element = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : TVE.ActiveElement;
                      var instance = null;
                      /* Give the the possibility to extends the sections array */

                      var sections = TVE.apply_filters('thrive_theme_sections', [Section, HFSection]);
                      sections.forEach(function (SectionClass) {
                        if (!instance && SectionClass.parentSection($element).length) {
                          instance = SectionClass.getInstance($element);
                        }
                      });
                      return instance;
                    },

                    /**
                     * Convert base64 data to blob.
                     *
                     * @param dataURI
                     * @return {Blob}
                     */
                    base64ToBlob: function base64ToBlob(dataURI) {
                      var byteString = dataURI ? atob(dataURI.split(',')[1]) : '';
                      var arrayBuffer = new ArrayBuffer(byteString.length),
                          intArray = new Uint8Array(arrayBuffer);

                      for (var i = 0; i < byteString.length; i++) {
                        intArray[i] = byteString.charCodeAt(i);
                      }

                      return new Blob([arrayBuffer], {
                        type: 'image/jpeg'
                      });
                    },

                    /**
                     * Save the image and return the ajax call.
                     *
                     * @param args
                     * @return {*}
                     */
                    savePreviewImage: function savePreviewImage(args) {
                      var form = new FormData(),
                          imageName = args['imageName'] ? args['imageName'] : "".concat(args['ID'], ".png");
                      form.append('action', args['action']);
                      /* format the image from base64 to blob and add it to the form */

                      form.append('img_data', this.base64ToBlob(args['image']), imageName);
                      return TVE.$.ajax({
                        url: args['url'],
                        type: 'POST',
                        data: form,
                        processData: false,
                        contentType: false,
                        headers: {
                          'X-WP-Nonce': TVE.CONST.rest_nonce
                        }
                      }).fail(function (response) {
                        if (typeof response.message !== 'undefined') {
                          TVE.page_message(response.message, true, 3000);
                        }
                      }).done(function (response) {
                        /**
                         * Notify the opened window that the thumb has been generated
                         */
                        TVE.outer.window.opener && TVE.outer.window.opener.postMessage({
                          action: 'ttb.thumbnail.generated',
                          post_id: parseInt(args.ID),
                          thumb: response
                        }, '*');
                      });
                    },

                    /**
                     * Fix the cloned images - they lose their native height after the content is cloned, so we have to add the original height back manually
                     *
                     * @param {jQuery} $clonedContent
                     * @param {jQuery} $originalContent
                     */
                    fixClonedImageHeights: function fixClonedImageHeights($clonedContent, $originalContent) {
                      $clonedContent.find('img').each(function (index, element) {
                        var $img = $originalContent.find("img:eq(".concat(index, ")")),
                            originalHeight = $img.height(),
                            originalWidth = $img.width();
                        element.style.height = originalHeight + 'px';
                        element.style.width = originalWidth + 'px';
                      });
                    },

                    /**
                     * Remove the content that is below the specified height.
                     *
                     * @param {jQuery} $content
                     * @param {int} contentHeight
                     * @return {*}
                     */
                    filterContentByHeight: function filterContentByHeight($content, contentHeight) {
                      if (contentHeight <= 0) {
                        $content.empty();
                      } else {
                        $content.children(':not(style)').each(function (index, element) {
                          if (contentHeight > 0) {
                            /* when an element is wrapped in a link for some reason, get the first child */
                            if (!element.classList.contains('thrv_wrapper') && element.tagName.toUpperCase() === 'A') {
                              element = element.firstChild;
                            }

                            contentHeight -= TVE.$(element).outerHeight(true);
                          } else {
                            element.parentNode.removeChild(element);
                          }
                        });
                      }
                      /* this is the remaining content height */


                      return contentHeight;
                    },

                    /**
                     * Remove certain classes/overlays/elements that mess up the preview generation library.
                     *
                     * @param $content
                     */
                    filterContentToPreview: function filterContentToPreview($content) {
                      /* clean the filtered content of edit-mode classes */
                      $content.find('.edit_mode, .layout-highlight').removeClass('edit_mode layout-highlight');
                      $content.find('.tcb-hamburger-logo').remove();
                      /**
                       * Do an action in case we want to filter this content from elsewhere
                       * @param {jQuery} $content
                       */

                      TVE.do_action('theme.filter_generated_preview', $content);
                    },

                    /**
                     * Computes the skin variables
                     *
                     * @param skinVariables
                     *
                     * @return {{master_variables: [], other_variables: []}}
                     */
                    getSkinVariables: function getSkinVariables() {
                      var skinVariables = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
                      var varTypes = ['colors', 'gradients'],
                          _return = {
                        master_variables: [],
                        other_variables: []
                      };

                      _.each(varTypes, function (type) {
                        var prefix = skinVariables["".concat(type, "_prefix")];

                        _.each(skinVariables[type], function (variable) {
                          var parent = parseInt(variable.parent),
                              template_var = "var(".concat(prefix).concat(variable.id, ")"),
                              css = type === 'colors' ? "linear-gradient(".concat(template_var, ", ").concat(template_var, ")") : template_var;
                          Object.assign(variable, {
                            type: type,
                            css_variable: prefix + variable.id,
                            prefix: prefix,
                            css: css
                          });

                          if (parent === -1) {
                            _return.master_variables.push(variable);
                          } else if (_.isNaN(parent)) {
                            _return.other_variables.push(variable);
                          }
                        });
                      });

                      return _return;
                    },

                    /**
                     * Callback for saving variable into the database
                     *
                     * @param data
                     */
                    saveSkinVariables: function saveSkinVariables() {
                      var data = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
                      $.ajax({
                        url: "".concat(TVE.CONST.theme.routes.skins, "/").concat(TVE.CONST.theme.skin_id, "/skin_variables"),
                        type: 'POST',
                        data: data,
                        headers: {
                          'X-WP-Nonce': TVE.CONST.rest_nonce
                        }
                      }).done(function () {
                        TVE.outer.window.opener && TVE.outer.window.opener.postMessage({
                          action: 'ttb.skin_variables_changed',
                          color_data: data
                        }, '*');
                      }).fail(function (response) {
                        if (response.responseJSON) {
                          TVE.page_message(response.responseJSON.message, true, 5000);
                        }
                      });
                    },

                    /**
                     * Labels for ordering depending on key
                     * @param key
                     * @return {*}
                     */
                    getOrderLabels: function getOrderLabels(key) {
                      var orderLabels = {
                        title: [{
                          name: 'A to Z',
                          value: 'asc'
                        }, {
                          name: 'Z to A',
                          value: 'desc'
                        }],
                        popularity: [{
                          name: 'Lowest first',
                          value: 'asc'
                        }, {
                          name: 'Highest first',
                          value: 'desc'
                        }],
                        id: [{
                          name: 'Lowest first',
                          value: 'asc'
                        }, {
                          name: 'Highest first',
                          value: 'desc'
                        }],
                        date: [{
                          name: 'Newest first',
                          value: 'asc'
                        }, {
                          name: 'Oldest first',
                          value: 'desc'
                        }],
                        modified: [{
                          name: 'Newest first',
                          value: 'asc'
                        }, {
                          name: 'Oldest first',
                          value: 'desc'
                        }],
                        menu_order: [{
                          name: 'Lowest first',
                          value: 'asc'
                        }, {
                          name: 'Highest first',
                          value: 'desc'
                        }],
                        price: [{
                          name: 'Lowest first',
                          value: 'asc'
                        }, {
                          name: 'Highest first',
                          value: 'desc'
                        }]
                      };
                      return typeof key === 'undefined' ? orderLabels : orderLabels[key];
                    },

                    /**
                     * If this element is a theme container, get the component and call some update functions
                     *
                     * @param $element
                     */
                    refreshThemeContainerComponent: function refreshThemeContainerComponent($element) {
                      var component;

                      if ($element.is(TVE.Theme.$wrapper) || $element.is(TVE.Theme.$content) || $element.is(TVE.Theme.$main)) {
                        component = TVE.getActiveComponent();
                      }

                      if (component && component.controls.PageMap && component.controls.LayoutVisibility) {
                        component.controls.PageMap.update();
                        component.controls.LayoutVisibility.render();
                      }
                    },

                    /**
                     * Check if we have more than 2 post contents, then we can delete some of them, otherwise we don't allow to delete.
                     */
                    allowPostContentDelete: function allowPostContentDelete() {
                      var postContents = [];
                      TVE.Theme.$wrapper.find(TVE.identifier('post_content')).each(function (index, element) {
                        if (!element.closest(TVE.identifier('post_list'))) {
                          postContents.push(element);
                        }
                      });
                      var canDelete = postContents.length > 1;
                      postContents.forEach(function (postContent) {
                        postContent.classList[canDelete ? 'remove' : 'add']('tcb-no-delete');
                      });
                    },

                    /**
                     * Adds TTB template prefixes to head css selectors
                     *
                     * @param {String} prefix current prefix
                     * @param {JQuery} $element element receiving the head_css
                     * @param {Boolean} forHoverState Whether or not this function is applied for the hover state selector or for the normal state
                     *
                     * @return {*}
                     */
                    getHeadCssPrefix: function getHeadCssPrefix(prefix, $element) {
                      var forHoverState = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

                      /* When we are editing thrive theme elements which are in the cloud on their own page we don't need a prefix */
                      if (!TVE.CONST.theme.is_theme_template) {
                        return prefix;
                      }
                      /**
                       * if editing the hover state of an element, or of a child of a hovered element, and this is not applied for the hover state, don't modify the prefix
                       */


                      if (forHoverState === false && TVE.flag_modify_hover_selector && TVE.state_manager.is_hover()) {
                        return prefix;
                      }

                      prefix = this.templatePrefix($element, prefix);
                      var $widgetArea = $element.parents(TVE.identifier('thrive_widget_area'));

                      if ($widgetArea.length) {
                        /* append the widget area data-css so the style will apply only on the current widget area */
                        prefix = prefix + '[data-css="' + TVE.CSS_Rule_Cache.uniq_id($widgetArea) + '"]' + TVE.identifier('thrive_widget_area') + ' ';
                      }
                      /* replace double spaces with just one */


                      return prefix.replace(/([ ]{2,})/g, ' ');
                    },

                    /**
                     * Check if on shop page the element is shop template element, or on the product page the element is product template.
                     * Do the same checks for the cart, checkout, account page templates.
                     * @param $element
                     * @return {boolean|*}
                     */
                    getWooElement: function getWooElement($element) {
                      var wooElement = TVE.Theme.constants.WOO_ELEMENTS.find(function (wooElement) {
                        return TVE.Theme.template["is".concat(TVE.ucFirst(wooElement))]() && $element.is(TVE.identifier("".concat(wooElement, "-template")));
                      });
                      return typeof wooElement === 'undefined' ? false : wooElement;
                    }
                  };
                })(jQuery);
              },
              "views": {
                "section-overlay.js": function sectionOverlayJs(exports, module, require) {
                  var Section = require('../models/section');

                  module.exports = TVE.Views.Base.base_view.extend({
                    initialize: function initialize(args) {
                      var _this31 = this;

                      this.section = args.section;
                      this.section.$element.one('mouseleave', function () {
                        _this31.remove(true);
                      });
                      this.render();
                    },
                    render: function render() {
                      if (this.section.$element.hasClass('section-hover') && this.section.$element.find('.section-overlay-actions').length === 0) {
                        this.setElement(TVE.inner_$(TVE.tpl('theme-main/section-overlay')({
                          view: this
                        })));
                        this.$el.hide().appendTo(this.section.$element).fadeIn();
                      }
                    },
                    enterEditMode: function enterEditMode() {
                      this.section.constructor.component.sectionSelect.setSection(this.section).enterEditMode();
                      this.remove();
                    },
                    unlink: function unlink() {
                      this.section.unlink();
                      this.section.constructor.component.after_update();
                      this.remove();
                    },
                    remove: function remove() {
                      var _this32 = this;

                      var animate = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
                      this.$el.fadeOut(animate ? 400 : 0, function () {
                        _this32.$el.remove();
                      });
                    },
                    addResponsiveClasses: function addResponsiveClasses() {
                      var classes = [];

                      if (this.section.$element.height() < TVE.Theme.constants.NORMAL_OVERLAY_MIN_HEIGHT) {
                        classes.push('small-height-overlay');
                      }

                      if (this.section.$element.height() < TVE.Theme.constants.SMALL_OVERLAY_MIN_HEIGHT) {
                        classes.push('no-description-overlay');
                      }

                      if (this.hasSmallWidht()) {
                        classes.push('small-width-overlay');
                      }

                      return classes.join(' ');
                    },
                    hasSmallWidht: function hasSmallWidht() {
                      return this.section.$element.width() < TVE.Theme.constants.SMALL_OVERLAY_MIN_WIDTH;
                    },
                    openSectionModal: function openSectionModal() {
                      this.section.constructor.component.sectionSelect.setSection(this.section).openSectionsModal();
                    }
                  });
                }
              }
            }
          },
          "frontend": {
            "models": {
              "sidebar": {
                "off-screen.js": function offScreenJs(exports, module, require) {
                  module.exports = function () {
                    var $ = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : jQuery;

                    var _window = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : window;

                    var body = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : document.body;

                    var OffScreen =
                    /*#__PURE__*/
                    function () {
                      _createClass(OffScreen, null, [{
                        key: "clickListener",
                        get: function get() {
                          return 'click.off-screen';
                        }
                      }, {
                        key: "defaultSettings",
                        get: function get() {
                          return {
                            display: {
                              desktop: 'slide',
                              mobile: 'slide'
                            },
                            visibleOnLoad: {
                              desktop: true,
                              mobile: false
                            },
                            visibleInEditor: true,
                            hasOverlay: {
                              desktop: false
                            },
                            hasDefaultTrigger: {
                              desktop: true
                            },
                            hasCloseIcon: {
                              desktop: true
                            },
                            sidebarWidth: null,
                            triggerPosition: {
                              desktop: 'center'
                            },
                            collapsedIcon: 'icon-menu-left-solid',
                            expandedIcon: 'icon-menu-right-solid',
                            closeIcon: 'icon-close-solid'
                          };
                        }
                      }, {
                        key: "triggerSelector",
                        get: function get() {
                          return '.tve-off-screen-sidebar-trigger';
                        }
                      }, {
                        key: "closeIconSelector",
                        get: function get() {
                          return '.tve-sidebar-close-icon';
                        }
                        /**
                         *
                         * @param {Sidebar} sidebarInstance
                         */

                      }]);

                      function OffScreen(sidebarInstance) {
                        _classCallCheck(this, OffScreen);

                        this.sidebarInstance = sidebarInstance;
                        this.$element = sidebarInstance.$element;
                        this.element = sidebarInstance.$element[0];
                        this.$main = sidebarInstance.$element.parent();
                        this.inEditor = sidebarInstance.constructor.inEditor && TVE.Theme && TVE.Theme.template;
                        var config = sidebarInstance.getJsonData('off-screen');
                        this.setConfig(config);
                      }

                      _createClass(OffScreen, [{
                        key: "init",
                        value: function init() {
                          var _this33 = this;

                          this.sidebarSide = this.$main.hasClass('flip-sections') ? 'left' : 'right';
                          body.setAttribute('data-off-screen-side', this.sidebarSide);
                          body.setAttribute('data-off-screen-type', this.getConfig('display', this.getDevice()));
                          body.classList.add('theme-has-off-screen-sidebar');
                          this.updateSidebarWidth();
                          this.initDefaultTrigger();
                          this.initCloseIcon();
                          this.toggleCloseIcon(this.getConfig('hasCloseIcon', this.getDevice()));
                          /* first time we hide the sidebar */

                          body.classList.remove('visible-off-screen-sidebar');
                          this.element.classList.remove('theme-has-off-screen-overlay');
                          this.element.classList.remove("sidebar-off-screen-on-".concat(this.getDevice()));
                          this.element.style.display = 'block';

                          if (this.inEditor) {
                            if (this.getConfig('visibleInEditor')) {
                              setTimeout(function () {
                                return _this33.toggle(true);
                              }, 24);
                            }
                          } else {
                            this.setSidebarTop();
                            $(document).off('keyup.off-screen').on('keyup.off-screen', this.onKeyUp.bind(this));

                            if (this.getConfig('hasOverlay', this.getDevice())) {
                              this.$element.off(OffScreen.clickListener).on(OffScreen.clickListener, this.onClick.bind(this));
                            }

                            if (this.isVisibleOnLoad()) {
                              setTimeout(function () {
                                return _this33.toggle(true);
                              }, 24);
                            }

                            this.$element.appendTo($('#wrapper'));
                          }

                          return this;
                        }
                        /**
                         * Check if the sidebar is visible on load. Take into consideration user options if a user is logged in
                         * @param device
                         * @return boolean
                         */

                      }, {
                        key: "isVisibleOnLoad",
                        value: function isVisibleOnLoad() {
                          var device = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.getDevice();
                          var isVisible = null;

                          if (!this.inEditor && device !== 'mobile' &&
                          /* on mobile we should always keep if collapsed */
                          ThriveTheme.localize.is_user_logged_in && ThriveTheme.localize.sidebar_visibility && typeof ThriveTheme.localize.sidebar_visibility[device] !== 'undefined') {
                            isVisible = !!parseInt(ThriveTheme.localize.sidebar_visibility[device]);
                          }

                          if (isVisible === null) {
                            isVisible = this.getConfig('visibleOnLoad', device);
                          }

                          return isVisible;
                        }
                        /**
                         * Initialize "mâner" that will help us toggle the sidebar open/close
                         */

                      }, {
                        key: "initDefaultTrigger",
                        value: function initDefaultTrigger() {
                          var _this34 = this;

                          this.$trigger = this.$element.find(OffScreen.triggerSelector);

                          if (this.inEditor) {
                            this.$trigger.data('tcb-elem-type', 'sidebar-trigger');
                            this.$trigger.attr('data-selector', OffScreen.triggerSelector);
                          } else {
                            this.$trigger.off(OffScreen.clickListener).on(OffScreen.clickListener, function () {
                              _this34.toggle(!_this34.isVisible());
                            });
                          }

                          this.$trigger.css({
                            display: this.getConfig('hasDefaultTrigger', this.getDevice()) ? 'flex' : 'none'
                          });
                          var triggerPosition = this.getConfig('triggerPosition', this.getDevice());

                          if (body.classList.contains('admin-bar') && triggerPosition === 'top') {
                            this.$trigger.css({
                              top: _window.TCB_Front.bodyOffsetTop()
                            });
                          }

                          this.element.setAttribute('data-trigger-position', triggerPosition);
                        }
                      }, {
                        key: "initCloseIcon",
                        value: function initCloseIcon() {
                          var _this35 = this;

                          if (this.inEditor) {
                            this.$element.find(OffScreen.closeIconSelector).attr('data-selector', OffScreen.closeIconSelector).addClass('tve_no_icons tve_no_drag');
                          } else {
                            $(document).off(OffScreen.clickListener).on(OffScreen.clickListener, OffScreen.closeIconSelector, function () {
                              return _this35.toggle(false);
                            });
                          }
                        }
                      }, {
                        key: "destroy",
                        value: function destroy() {
                          body.classList.remove('theme-has-off-screen-sidebar');
                          body.classList.remove('visible-off-screen-sidebar');
                          this.element.style.removeProperty('top');
                          this.element.style.removeProperty('height');
                          this.element.style.removeProperty('display');
                          this.element.style.removeProperty('min-width');
                          this.element.classList.remove("sidebar-off-screen-on-".concat(this.getDevice()));

                          if (this.$trigger) {
                            this.$trigger.hide();
                          }

                          this.toggleCloseIcon(false);

                          if (this.$element.parent().attr('id') === 'wrapper') {
                            this.$element.insertBefore($('.main-columns-separator'));
                          }

                          return this;
                        }
                        /**
                         * Show/hide sidebar. Adding classes at different times so we can get the right effect
                         * @param show
                         * @return {OffScreen}
                         */

                      }, {
                        key: "toggle",
                        value: function toggle(show) {
                          var _this36 = this;

                          if (typeof show === 'undefined') {
                            show = !this.isVisible();
                          }

                          var device = this.getDevice();

                          if (this.$element.hasClass("tcb-".concat(device, "-hidden"))) {
                            /* don't show the sidebar if it's hidden*/
                            show = false;
                          }

                          if (show && this.getConfig('hasOverlay', device)) {
                            this.element.classList.add('theme-has-off-screen-overlay');
                            setTimeout(function () {
                              body.classList.toggle('visible-off-screen-sidebar', show);
                            }, 42);
                          } else {
                            body.classList.toggle('visible-off-screen-sidebar', show);
                            setTimeout(function () {
                              _this36.element.classList.remove('theme-has-off-screen-overlay');
                            }, 420);
                          }
                          /* update settings only for logged in user and when not on mobile */


                          if (!this.sidebarInstance.constructor.inEditor && ThriveTheme.localize.is_user_logged_in && device !== 'mobile') {
                            this.updateUserSidebarSettings(show);
                          }
                          /* resize full width page sections */


                          setTimeout(_window.TCB_Front.resizePageSection, 500);
                          return this;
                        }
                        /**
                         * Set config data
                         * @param config
                         */

                      }, {
                        key: "setConfig",
                        value: function setConfig() {
                          var config = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
                          this.config = config;
                          return this;
                        }
                        /**
                         * Get key from config
                         * @param key
                         * @param device
                         * @return {*}
                         */

                      }, {
                        key: "getConfig",
                        value: function getConfig() {
                          var key = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
                          var device = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
                          var data = this.config;

                          if (key) {
                            data = data[key];

                            if (device) {
                              data = this.sidebarInstance.getConfigByDevice(data, device);
                            }
                          }

                          return data;
                        }
                        /**
                         * Determine the sidebar width from the percentage size
                         *      > for mobile we use full screen - 24 (the trigger size)
                         *      > for tablet we use half of the screen
                         *      > for desktop we use the same percentage the sidebar had related to the main container - if the container was wrapped, we use half of the container
                         *  > in case we set a min width, we use the max between the decided width and the min width
                         *  > if the width we want to set is larger than the screen size, we use just like for the mobile version - full screen minus 24 trigger size
                         * @return {number}
                         */

                      }, {
                        key: "updateSidebarWidth",
                        value: function updateSidebarWidth(width) {
                          var windowWidth = $(_window).width();

                          if (typeof width === 'undefined') {
                            switch (this.getDevice()) {
                              case 'desktop':
                                var mainStyle = getComputedStyle(this.element.parentElement);

                                if (mainStyle.flexWrap === 'wrap') {
                                  /* a decent width for the sidebar ? */
                                  width = parseInt(mainStyle.width) / 2;
                                } else {
                                  /* we calculate using percentage relative to parent element instead of reading directly from the sidebar because the sidebar can already be in offscreen state and it won't be relevant */
                                  width = parseFloat(mainStyle.getPropertyValue('--sidebar-size')) * parseInt(mainStyle.width) / 100 - parseFloat(mainStyle.getPropertyValue('--separator-size')) / 2;
                                }

                                break;

                              case 'tablet':
                                width = windowWidth / 2;
                                break;

                              case 'mobile':
                                width = windowWidth - 24;
                                break;

                              default:
                                break;
                            }

                            var minWidth = this.$element.css('min-width');

                            if (minWidth.includes('%')) {
                              minWidth = parseInt(minWidth) * windowWidth / 100;
                            } else {
                              minWidth = parseInt(minWidth);

                              if (isNaN(minWidth)) {
                                minWidth = 0;
                              }
                            }

                            width = Math.max(minWidth, width);
                          }

                          if (width >= windowWidth) {
                            /* make sure the sidebar is not larger than the screen + some padding */
                            width = windowWidth - 24;
                          }

                          if (parseInt(this.$element.css('min-width'))) {
                            this.$element.css('min-width', "".concat(width, "px"));
                          }

                          body.style.setProperty('--off-screen-sidebar-size', "".concat(width, "px"));
                          return width;
                        }
                        /**
                         * show/hide close icon
                         * @param show
                         */

                      }, {
                        key: "toggleCloseIcon",
                        value: function toggleCloseIcon() {
                          var show = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
                          this.$element.find(OffScreen.closeIconSelector).toggle(show);
                        }
                        /**
                         * Set sidebar top depending if we have some other bars (like the admin) on top of the page
                         */

                      }, {
                        key: "setSidebarTop",
                        value: function setSidebarTop() {
                          var bodyOffset = _window.TCB_Front.bodyOffsetTop();

                          this.$element.css({
                            top: "".concat(bodyOffset, "px"),
                            height: "calc(100vh - ".concat(bodyOffset, "px)")
                          });
                        }
                        /**
                         * Save the last state of the sidebar visibility for a specific device so we can load it next time when the user is online
                         * @param show
                         */

                      }, {
                        key: "updateUserSidebarSettings",
                        value: function updateUserSidebarSettings(show) {
                          if (_typeof(ThriveTheme.localize.sidebar_visibility) !== 'object' || Array.isArray(ThriveTheme.localize.sidebar_visibility)) {
                            ThriveTheme.localize.sidebar_visibility = {};
                          }

                          ThriveTheme.localize.sidebar_visibility[this.getDevice()] = show ? 1 : 0;
                          $.ajax({
                            url: "".concat(ThriveTheme.localize.routes.frontend, "/user_options"),
                            headers: {
                              'X-WP-Nonce': tve_frontend_options.nonce
                            },
                            type: 'POST',
                            data: {
                              template: ThriveTheme.localize.ID,
                              option: 'sidebar_visibility',
                              value: ThriveTheme.localize.sidebar_visibility
                            }
                          });
                        }
                        /**
                         * Hide sidebar when we click the overlay
                         * @param event
                         */

                      }, {
                        key: "onClick",
                        value: function onClick(event) {
                          if (event.target.classList.contains('sidebar-section')) {
                            this.toggle(false);
                          }
                        }
                        /**
                         * Hide sidebar when we press escape
                         * @param event
                         */

                      }, {
                        key: "onKeyUp",
                        value: function onKeyUp(event) {
                          if (event.key === 'Escape') {
                            this.toggle(false);
                          }
                        }
                        /**
                         * Check if the sidebar is visible
                         * @return {boolean}
                         */

                      }, {
                        key: "isVisible",
                        value: function isVisible() {
                          return body.classList.contains('visible-off-screen-sidebar');
                        }
                      }, {
                        key: "getDevice",
                        value: function getDevice() {
                          return typeof _window.TCB_Front === 'undefined' ? TVE.main.device : _window.TCB_Front.getDisplayType();
                        }
                      }]);

                      return OffScreen;
                    }();

                    return OffScreen;
                  };
                }
              }
            }
          },
          "landingpage": {
            "components": {
              "landingpage-section.js": function landingpageSectionJs(exports, module, require) {
                var ThemeSectionComponent = require('../../architect/main/components/theme-section'),
                    Section = require('../models/lp-section');

                module.exports = ThemeSectionComponent.extend({
                  /**
                   * Before updating components, save an instance of the current section and its component
                   */
                  before_update: function before_update() {
                    this.section = TVE.Theme.utils.getSectionInstance(TVE.ActiveElement);
                    this.sectionSelect.setSection(this.section);
                    this.sectionSelect.setSectionComponent(this);
                    return this;
                  },
                  controls_init: function controls_init(controls) {
                    var _this37 = this;

                    var resizePageSection = _.throttle(TVE.inner.window.TCB_Front.resizePageSection, 10),
                        masonryRedo = _.throttle(TVE.PostList.layout.masonryRedo, 500),
                        self = this;
                    /* We are using from the parent the following controls - Visibility, VerticalPosition, InheritContentSize ( update ) */


                    ThemeSectionComponent.prototype.controls_init.call(this, controls, false);

                    controls['StretchBackground'].input = function ($element, control) {
                      self.section.toggleFullWidthBackground(control.checked);
                      controls.PageMap.update($element);
                      controls['ContentWidth'].update();
                      controls['StretchContent'].update();
                    };

                    controls['StretchBackground'].update = function () {
                      this.setChecked(self.section.hasFullWidthBackground());
                      this.$el.toggleClass('tcb-disabled', !self.section.isVisible() || TVE.isLPFullWidth());
                    };

                    controls['InheritContentSize'].input = function ($element, control) {
                      var inherit = control.checked;

                      if (inherit) {
                        self.section.setContentWidth("var(".concat(Section.contentWidthVariable, ", 1080px)"), true);
                      } else {
                        self.section.setContentWidth(Section.getEditorContentWidth(true), true);
                        controls['ContentWidth'].update();
                        controls['StretchContent'].update();
                      }

                      controls['ContentWidth'].$el.toggle(!inherit);
                      controls['StretchContent'].$el.toggle(!inherit);
                      resizePageSection();
                      masonryRedo();
                    };

                    controls['ContentWidth'].input = function ($element, control) {
                      self.section.setContentWidth(control.value + this.getUM(), false);
                      resizePageSection();
                      masonryRedo();
                    };

                    controls['ContentWidth'].change = function ($element, control) {
                      self.section.setContentWidth(control.value + this.getUM(), true);
                    };

                    controls['ContentWidth'].update = function () {
                      this.originalConfig.max = parseInt(self.section.$background.css('width'));
                      this.setValue(self.section.$content.css('width'));
                      this.$el.toggleClass('tcb-disabled', self.section.hasFullWidthContent() || !self.section.isVisible());
                      this.$el.toggle(!self.section.inheritsContent());
                    };

                    controls['StretchContent'].input = function ($element, control) {
                      self.section.setContentWidth(control.checked ? '100%' : Section.getEditorContentWidth(true), true);
                      resizePageSection();
                      masonryRedo();
                      controls['ContentWidth'].update();
                    };

                    controls['StretchContent'].update = function () {
                      this.setChecked(self.section.hasFullWidthContent());
                      this.$el.toggleClass('tcb-disabled', !(self.section.isVisible() && (self.section.hasFullWidthBackground() || TVE.isLPFullWidth())));
                      this.$el.toggle(!self.section.inheritsContent());
                    };
                    /* Save data for when a top/bottom landing page section is full width or not */


                    TVE.add_filter('tcb_save_post_data_after', function (data) {
                      if (_this37.section) {
                        data.tve_globals.body_class = TVE.toggleClassNames(data.tve_globals.body_class, "tcb-full-".concat(_this37.section.type));
                      }

                      return data;
                    });
                    /* On landing pages the section at first needs to inherit content size from layout */

                    TVE.add_action('theme.section.after_insert', function (section, sectionInstance) {
                      sectionInstance.setContentWidth("var(".concat(Section.contentWidthVariable, ", 1080px)"), true);
                    });
                  },
                  after_update: function after_update() {
                    var isStatic = !this.section.isDynamic(),
                        inSectionEditMode = this.section.inEditMode();
                    this.controls['PageMap'].$el.toggle(!inSectionEditMode);
                    /* only top and bottom sections can control their content width */

                    this.controls['InheritContentSize'].$el.toggle(!inSectionEditMode);
                    /* hide the visibility options for the content section */

                    this.controls['Visibility'].$el.toggle(!inSectionEditMode);
                    /*Display SectionHeight and VerticalPosition only for sections(while in edit mode or when the section is not saved as template) */

                    this.controls['SectionHeight'].$el.toggle(inSectionEditMode || isStatic);
                    this.controls['VerticalPosition'].$el.toggle(inSectionEditMode || isStatic);
                    this.sectionSelect.update();
                  }
                });
              }
            },
            "hooks": {
              "actions.js": function actionsJs(exports, module, require) {
                (function ($) {
                  var commonSectionActions = require('../../architect/main/actions/common-section'),
                      LPSection = require('../models/lp-section'),
                      actions = {
                    /**
                     * When the lazy load filter is called, add the section data to the sections object
                     *
                     * @param {{theme_sections: * }} data
                     * @return {*}
                     */
                    'tve.lazyload.done': function tveLazyloadDone(data) {
                      _.each(data.theme_sections, function (section) {
                        if (typeof TVE.Theme.data.local[section.type] === 'undefined') {
                          TVE.Theme.data.local[section.type] = {};
                        }

                        TVE.Theme.data.local[section.type][section.id] = section;
                      });
                    },

                    /**
                     * Overwrite the visibility toggle for the page map
                     * @param control
                     */
                    'tcb.page-map.extend': function tcbPageMapExtend(control) {
                      /**
                       * Toggle visibility for section
                       * @param {string} section
                       * @param {string} sectionSelector
                       * @param {boolean} show
                       */
                      control.visibilityToggle = function (section, sectionSelector, show) {
                        var $section = TVE.inner_$(sectionSelector);

                        if ($section.length) {
                          if (TVE.Theme.$sections[section]) {
                            var sectionInstance = TVE.Theme.utils.getSectionInstance(TVE.Theme.$sections[section]);
                            sectionInstance.toggle(show);
                          } else {
                            $section.toggle();
                          }
                        } else {
                          if (section === 'header' || section === 'footer') {
                            control.symbolInsert.add_section_placeholder(section, sectionSelector, TVE.Editor_Page.editor);
                          }
                        }
                      };
                    },

                    /**
                     * Open sections modal for top / bottom when there is only the placeholder present in the page
                     *
                     * @param {jQuery} $target
                     * @param {String} section
                     */
                    'tcb.before_select_section': function tcbBefore_select_section($target, section) {
                      if ($target.length && TVE.Theme.$sections[section]) {
                        var sectionInstance = TVE.Theme.utils.getSectionInstance(TVE.Theme.$sections[section]);
                        sectionInstance.openModal();
                      }
                    }
                  };

                  module.exports = _objectSpread({}, actions, {}, commonSectionActions);
                })(jQuery);
              },
              "filters.js": function filtersJs(exports, module, require) {
                (function ($) {
                  var Content = require('../models/content'),
                      LPSection = require('../models/lp-section'),
                      commonSectionFilters = require('../../architect/main/filters/common-section');
                  /**
                   * General function to add landing page section selector to the others
                   *
                   * @param {String} selectors
                   * @returns {String}
                   */


                  var addSelectors = function addSelectors(selectors) {
                    return selectors + ',' + LPSection.selectionSelector();
                  };

                  var filters = {
                    /**
                     * Add the landingpage selector as editable in the editor
                     */
                    'selectors_editable': addSelectors,

                    /**
                     * Add the landingpage selector at mouseover
                     */
                    'selectors_mouseover': addSelectors,

                    /**
                     * The section doesn't have any icons
                     */
                    'selectors_no_icons': addSelectors,

                    /**
                     * Overwrite the page map template when we have the theme active because we need to add top and bottom sections
                     *
                     * @param {String} tpl
                     * @returns {String}
                     */
                    'tcb.page-map.template': function tcbPageMapTemplate(tpl) {
                      return 'architect-main/landing-page-map';
                    },

                    /**
                     * Initialize some constants inside the editor
                     */
                    'editor_loaded_callback': function editor_loaded_callback() {
                      TVE.Theme.$sections = {};
                      TVE.inner.$body.find(TVE.Theme.models.LPSection.identifier).each(function (index, element) {
                        var $section = TVE.inner_$(element),
                            $style = $section.children('style');
                        TVE.Theme.$sections[element.dataset.section] = $section;

                        if ($style.length) {
                          TVE.Editor_Page.content_manager.insert_head_css($style.text()).done(function () {
                            $style.remove();
                          });
                        }
                      });
                      TVE.Theme.$wrapper = TVE.Editor_Page.editor;

                      var SectionHover = require('../../architect/editor/section-hover');

                      TVE.Theme.sectionHover = new SectionHover();
                    },

                    /**
                     * Do not highlight when the section is linked
                     *
                     * @param {String} selectors
                     * @returns {String}
                     */
                    'selectors_no_highlight': function selectors_no_highlight(selectors) {
                      return selectors + ',' + '.landingpage-section[data-id]:not(.tcb-compact-edit-mode) *';
                    },

                    /**
                     * @param {Object} TVE
                     * @returns {*}
                     */
                    'tcb.includes': function tcbIncludes(TVE) {
                      $.extend(true, TVE.Views.Components, {
                        'LandingpageSection': require('../components/landingpage-section')
                      });
                      TVE.Theme.views = _objectSpread({}, TVE.Theme.views || {}, {
                        SectionOverlay: require('../../architect/main/views/section-overlay')
                      });
                      return TVE;
                    },

                    /**
                     * Add the sections here to be saved together with the landing page content
                     *
                     * @param {Object} data
                     * @returns {*}
                     */
                    'tcb_save_post_data_after': function tcb_save_post_data_after(data) {
                      var ContentInstance = new Content(TVE.Editor_Page.editor);
                      data['theme_extra'] = ContentInstance.saveSections();
                      return data;
                    },

                    /**
                     * Remove the sections from the html before saving the landing page
                     *
                     * @param $html
                     * @param $root
                     * @param options
                     * @returns {*}
                     */
                    'tcb_filter_html_before_save': function tcb_filter_html_before_save($html, $root, options) {
                      $html.find("".concat(TVE.Theme.models.LPSection.identifier)).each(function (index, section) {
                        section.parentNode.removeChild(section);
                      });
                      return $html;
                    },

                    /**
                     * The content/background is the one that is selected, but we're making the section as the active element
                     *
                     * @param {jQuery} $activeElement
                     * @param {String} type
                     * @returns {*|Element}
                     */
                    'tcb.element_selected': function tcbElement_selected($activeElement, type) {
                      if (type === 'landingpage_section') {
                        $activeElement = LPSection.parentSection($activeElement);
                      }

                      return $activeElement;
                    },

                    /**
                     * Add also the landingpage section to the sections array instances
                     *
                     * @param {Array} sections
                     * @returns {*}
                     */
                    'thrive_theme_sections': function thrive_theme_sections(sections) {
                      sections.push(LPSection);
                      return sections;
                    },

                    /**
                     * Change the head css prefix for the sections and the elements inside them
                     *
                     * @param {String} prefix
                     * @param {jQuery} $element
                     * @returns {*}
                     */
                    'tcb_head_css_prefix': function tcb_head_css_prefix(prefix, $element) {
                      return TVE.LP.utils.sectionHeadCssPrefix(prefix, $element, false);
                    },

                    /**
                     * If we are importing a cloud template in a landing page section we need to change the selector from css so that it contains the section selector
                     *
                     * @param rules
                     * @returns {*}
                     */
                    'css_rules_before_insert': function css_rules_before_insert(rules) {
                      if (TVE.ActiveElement) {
                        var section = TVE.Theme.utils.getSectionInstance(TVE.ActiveElement);
                        /* we are only changing the css rules for elements within section or the section itself */

                        if (section) {
                          /* Sneaky trick to change css text even if we are not in a theme template */
                          TVE.CONST.theme.is_theme_template = true;
                          rules = TVE.Theme.utils.cssRulesBeforeInsert(rules);
                          TVE.CONST.theme.is_theme_template = false;
                        }
                      }

                      return rules;
                    },

                    /**
                     * When writing head css, we replace data-css selector with their "natural" selector
                     *
                     * @param {Object} data
                     * @returns {*}
                     */
                    'head_css_selector': function head_css_selector(data) {
                      var $element = $(data.element),
                          dynamicPrefix = TVE.Theme.utils.getDynamicElementPrefix($element);

                      if (dynamicPrefix.length) {
                        data.prefix = data.prefix.trimRight() + ' ' + dynamicPrefix + ' ';
                      }

                      return data;
                    },

                    /**
                     * Include landing page section in the array of elements that support background effects
                     *
                     * @param {Array} elements
                     * @returns {_._Chain<any> | * | any[] | string}
                     */
                    'tcb.bg_effects_elements': function tcbBg_effects_elements(elements) {
                      return elements.concat('landingpage-section');
                    },

                    /**
                     * Change section selector when we are on a landing page
                     *
                     * @param {String} selector
                     * @returns {String}
                     */
                    'theme.convert_section_selector': function themeConvert_section_selector(selector) {
                      var postListSelector = TVE.identifier('post_list');

                      if (!selector.includes(postListSelector)) {
                        /* when we're not in a post list */
                        selector = TVE.PostList.dynamicImage.replaceDynamicImage(TVE.Theme.CONST.ID, selector);
                      }

                      return selector;
                    },

                    /**
                     * Filter before inserting an element inside a content area on click.
                     *
                     * @param {jQuery} $target
                     * @returns {*}
                     */
                    'tcb.change_target': function tcbChange_target($target) {
                      return TVE.LP.utils.getSectionDropzoneTarget($target);
                    },

                    /**
                     * Filter before the selection of the dropzone target. The editor scrolls to this after inserting an element with click.
                     *
                     * @param {jQuery} $target
                     * @returns {*}
                     */
                    'tcb.get_dropzone_target': function tcbGet_dropzone_target($target) {
                      $target = TVE.LP.utils.getSectionDropzoneTarget($target);
                      /* if the added element is higher in the page than where we scrolled, animate-scroll up */

                      if ($target.offset().top + $target.height() < TVE.inner.$window.scrollTop()) {
                        TVE.inner_$('html, body').animate({
                          scrollTop: $target.offset().top + $target.height()
                        });
                      }

                      return $target;
                    },

                    /**
                     * We don't want to save the css for a dynamic section. This is saved separately in the section's meta
                     *
                     * @param {Boolean} shouldSave
                     * @param rule
                     * @returns {Boolean}
                     */
                    'tcb.css.should_save_rule': function tcbCssShould_save_rule(shouldSave, rule) {
                      if (rule.selectorText.includes('thrive-section')) {
                        shouldSave = false;
                      }

                      return shouldSave;
                    },

                    /**
                     * If the target is section, we want need to change it based on the section type
                     *
                     * @param {jQuery} $target
                     * @returns {*}
                     */
                    'tcb.block_drop_target': function tcbBlock_drop_target($target) {
                      var section = TVE.Theme.utils.getSectionInstance($target);

                      if (section) {
                        $target = section.getBlockTarget();
                      }

                      return $target;
                    },

                    /**
                     * Whether to show or not the below block controls for LP section
                     *
                     * @param {Boolean} allow
                     * @param {jQuery} $target
                     *
                     * @returns {Boolean}
                     */
                    'tcb.allow_block_controls_below': function tcbAllow_block_controls_below(allow, $target) {
                      var section = TVE.Theme.utils.getSectionInstance($target);

                      if (section) {
                        allow = section.allowBlockControlsBelow(allow);
                      }

                      return allow;
                    },

                    /**
                     * Whether to show or not the above block controls for LP section
                     *
                     * @param {Boolean} allow
                     * @param {jQuery} $target
                     * @returns {Boolean}
                     */
                    'tcb.allow_block_controls_above': function tcbAllow_block_controls_above(allow, $target) {
                      if ($target.length && TVE.Theme.models.LPSection.isLPSection($target)) {
                        allow = false;
                      }

                      return allow;
                    }
                  };
                  module.exports = _objectSpread({}, filters, {}, commonSectionFilters);
                })(jQuery);
              }
            },
            "init.js": function initJs(exports, module, require) {
              (function ($) {
                var SectionHover = require('../architect/editor/section-hover');

                $(window).on('tcb_main_ready', function () {
                  /* Sections from cloud modal */
                  TVE.Theme.modals.sectionTemplates = new (require('../architect/main/modals/section-templates-block'))({
                    el: TVE.modal.get_element('section-templates-block')
                  });
                  /* Save section modal */

                  TVE.Theme.modals.sectionSave = new (require('../architect/main/modals/section-save'))({
                    el: TVE.modal.get_element('section-save')
                  });
                }).on('tcb.register-hooks', function () {
                  var ThemeModels = require('../architect/main/models/_includes');

                  TVE.Theme = _objectSpread({}, TVE.Theme || {}, {
                    FLAGS: {},
                    data: {
                      cloud: {},
                      local: {}
                    },
                    models: _objectSpread({}, ThemeModels, {
                      LPSection: require('./models/lp-section')
                    }),
                    selectors: require('../architect/main/selectors'),
                    content: require('../architect/main/content'),
                    utils: require('../architect/main/utils'),
                    CONST: ttb_landingpage_localize
                  });
                  TVE.LP = {
                    utils: require('./utils')
                  };

                  _.each(require('./hooks/actions'), function (callback, tag) {
                    return TVE.add_action(tag, callback);
                  });

                  _.each(require('./hooks/filters'), function (callback, tag) {
                    return TVE.add_filter(tag, callback);
                  });
                }).on('tcb-ready', function () {
                  TVE.Theme.sectionHover = new SectionHover();
                });
              })(jQuery);
            },
            "models": {
              "content.js": function contentJs(exports, module, require) {
                /**
                 * Handle landing page section content at save
                 */
                (function ($) {
                  var Content =
                  /*#__PURE__*/
                  function () {
                    function Content($content) {
                      _classCallCheck(this, Content);

                      this.$content = $content;
                    }
                    /**
                     * @returns {{icons: {}, sections: {}}}
                     */


                    _createClass(Content, [{
                      key: "saveSections",
                      value: function saveSections() {
                        var _this38 = this;

                        var sections = {},
                            icons = {};
                        this.$content.find(TVE.Theme.models.LPSection.identifier).each(function (index, section) {
                          /* We are only saving the sections which are not placeholders */
                          if (!section.classList.contains('placeholder-section')) {
                            var sectionId = parseInt(section.dataset.id || 0),
                                type = section.dataset.section;
                            /**
                             * To know type of section saved
                             * e.g used for toc element refresh functionality
                             */

                            TVE.Theme.savedSection = type;

                            if (sectionId) {
                              sections[type] = {
                                id: sectionId
                              };
                            } else {
                              var $section = TVE.inner_$(section),
                                  sectionInstance = TVE.Theme.models.LPSection.getInstance($section);
                              icons = _objectSpread({}, icons, {}, _this38.icons($section));
                              sections[type] = _objectSpread({
                                id: 0,
                                content: sectionInstance.getContent()
                              }, sectionInstance.getExtra());
                            }
                            /* this is always saved on the template */


                            sections[type].hide = section.classList.contains('hide-section') ? 1 : 0;
                          }
                        });
                        return {
                          'sections': sections,
                          'icons': icons
                        };
                      }
                      /**
                       * Search for icons in the content and return the svg content
                       *
                       * @param {jQuery} $content
                       * @returns {Object}
                       */

                    }, {
                      key: "icons",
                      value: function icons($content) {
                        var icons = {};
                        var _iteratorNormalCompletion3 = true;
                        var _didIteratorError3 = false;
                        var _iteratorError3 = undefined;

                        try {
                          for (var _iterator3 = TVE.Theme.selectors.icons[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
                            var selector = _step3.value;
                            $content.find(selector + ' svg.tcb-icon').each(function (index, svg) {
                              icons[typeof svg.dataset.id === 'undefined' ? svg.dataset.name : svg.dataset.id] = svg.outerHTML;
                            });
                          }
                        } catch (err) {
                          _didIteratorError3 = true;
                          _iteratorError3 = err;
                        } finally {
                          try {
                            if (!_iteratorNormalCompletion3 && _iterator3["return"] != null) {
                              _iterator3["return"]();
                            }
                          } finally {
                            if (_didIteratorError3) {
                              throw _iteratorError3;
                            }
                          }
                        }

                        return icons;
                      }
                    }]);

                    return Content;
                  }();

                  module.exports = Content;
                })(jQuery);
              },
              "lp-section.js": function lpSectionJs(exports, module, require) {
                (function ($) {
                  var ThemeSection = require('../../architect/main/models/section');
                  /**
                   * Landing page section
                   */


                  var LPSection =
                  /*#__PURE__*/
                  function (_ThemeSection) {
                    _inherits(LPSection, _ThemeSection);

                    function LPSection() {
                      _classCallCheck(this, LPSection);

                      return _possibleConstructorReturn(this, _getPrototypeOf(LPSection).apply(this, arguments));
                    }

                    _createClass(LPSection, [{
                      key: "isHorizontal",
                      value: function isHorizontal() {
                        return true;
                      }
                    }, {
                      key: "isVertical",
                      value: function isVertical() {
                        return false;
                      }
                      /**
                       * Return the landing page id where the section is localized
                       *
                       * @returns {Number}
                       */

                    }, {
                      key: "getWidth",

                      /**
                       *
                       * @param area
                       * @returns {jQuery}
                       */
                      value: function getWidth() {
                        var area = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'content';
                        return TVE.Editor_Page.editor.tcbCss("--".concat(this.type, "-").concat(area, "-width"));
                      }
                      /**
                       *
                       * @returns {boolean}
                       */

                    }, {
                      key: "inheritsContent",
                      value: function inheritsContent() {
                        return this.contentWidth.includes(LPSection.contentWidthVariable);
                      }
                      /**
                       * Set content width on the css variable that will automatically be used
                       * @param width
                       * @param writeHeadCss {Boolean} write inline or in head css
                       */

                    }, {
                      key: "setContentWidth",
                      value: function setContentWidth(width) {
                        var writeHeadCss = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

                        if (writeHeadCss) {
                          TVE.head_css("".concat(this.baseSelector, " ").concat(LPSection.contentSelector), {
                            'max-width': "".concat(width, "!important")
                          });
                          this.$content.tcbCss('max-width', '');
                        } else {
                          this.$content.tcbCss('max-width', "".concat(width, "!important"));
                        }
                      }
                      /**
                       * Extra characteristics specific to the landing page section
                       */

                    }, {
                      key: "getExtra",
                      value: function getExtra() {
                        var extra = {
                          decoration: this.getDecoration(),
                          attr: this.getAttributes()
                        };
                        return TVE.apply_filters('theme.section.data.extra', extra, this);
                      }
                      /**
                       * A landing page is always considered a singular template
                       *
                       * @returns {Boolean}
                       */

                    }, {
                      key: "toggle",

                      /**
                       * Landing page section toggle
                       * If there is only the placeholder present, open the sections modal
                       *
                       * @param {Boolean} show
                       */
                      value: function toggle() {
                        var show = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;

                        if (this.isPlaceholder()) {
                          this.constructor.component.sectionSelect.setSection(this).openSectionsModal();
                        } else {
                          _get(_getPrototypeOf(LPSection.prototype), "toggle", this).call(this, show);
                        }
                      }
                      /**
                       * Open the sections modal if we have the placeholder inside
                       */

                    }, {
                      key: "openModal",
                      value: function openModal() {
                        if (this.isPlaceholder()) {
                          this.constructor.component.sectionSelect.setSection(this).openSectionsModal();
                        }
                      }
                      /**
                       * Return if this section is in fact a placeholder
                       *
                       * @returns {*}
                       */

                    }, {
                      key: "isPlaceholder",
                      value: function isPlaceholder() {
                        return this.$element.hasClass('placeholder-section');
                      }
                    }, {
                      key: "toggleFullWidthBackground",
                      value: function toggleFullWidthBackground(toggle) {
                        TVE.inner.$body.toggleClass("tcb-full-".concat(this.type), toggle);
                      }
                    }, {
                      key: "hasFullWidthBackground",
                      value: function hasFullWidthBackground() {
                        return TVE.inner.$body.hasClass("tcb-full-".concat(this.type));
                      }
                      /**
                       * Returns the content width of the editor, from where we sometimes inherit
                       *
                       * @param {Boolean} raw in case we want the result in pixels
                       * @return {String}
                       */

                    }, {
                      key: "hasFullWidthContent",

                      /**
                       * Has full width when we set it to 100% or nothing was set - old stuff
                       * @returns {Boolean}
                       */
                      value: function hasFullWidthContent() {
                        var contentWidth = this.contentWidth;
                        return contentWidth === '100%' || contentWidth.length === 0;
                      }
                      /**
                       * When a LP section, the block target is always the section element
                       */

                    }, {
                      key: "getBlockTarget",
                      value: function getBlockTarget() {
                        return this.$element;
                      }
                      /**
                       * Check if we allow block controls below the section
                       *
                       * @returns {Boolean}
                       */

                    }, {
                      key: "allowBlockControlsBelow",
                      value: function allowBlockControlsBelow() {
                        return this.type !== 'bottom';
                      }
                      /**
                       * Actions done after the section has been added to the page
                       */

                    }, {
                      key: "afterInsert",
                      value: function afterInsert(section) {
                        TVE.Theme.FLAGS.duringImport = false;
                        /* re-initialize the inline shortcodes */

                        TVE.froala.init();
                        this.focus();
                        this.fixTypography();
                        TVE.Theme.content.init_selectors(this.$element);
                        this.constructor.saveTemplate(true);
                        TVE.do_action('theme.section.after_insert', section, this);
                        TVE.do_action("theme.section.after_insert.".concat(this.type), section, this);
                        TVE.Theme.utils.loadingMessage(false);
                        this.bindElementActions();
                      }
                      /**
                       * We need to change the typography rules from the section when this is inserted in a landing page
                       * We are adding the global selector to make them stronger than the typography rules from the landing page
                       *
                       * @param rules
                       */

                    }, {
                      key: "fixTypography",
                      value: function fixTypography(rules) {
                        var typographyTags = [' p', ' li', ' label', ' .tcb-plain-text'];
                        var sectionSelector = "".concat(this.selector, " ").concat(LPSection.contentSelector),
                            selectorMatch = '';
                        /* We need the body class only when the section is not dynamic */

                        if (!this.isDynamic()) {
                          sectionSelector = TVE.Theme.CONST.body_class + ' ' + sectionSelector;
                        }

                        selectorMatch = typographyTags.map(function (tag) {
                          return sectionSelector + tag;
                        }).join(', ');

                        if (typeof rules === 'undefined') {
                          rules = TVE.stylesheet.cssRules;
                        }

                        for (var i = 0; i < rules.length; i++) {
                          if (rules[i].type === CSSRule.MEDIA_RULE) {
                            for (var j = 0; j < rules[i].cssRules.length; j++) {
                              var rule = rules[i].cssRules[j];
                              /* add the global selector for the typography rules set from the section element */

                              if (rule.selectorText.includes(selectorMatch) && !rule.selectorText.includes(TVE.CONST.global_css_prefix)) {
                                /* We always want to replace the first part of the selector, because when the section changes we need to make sure the styles are deleted correctly */
                                var cssText = rule.cssText.replace(TVE.Theme.utils.escapedRegEx("".concat(sectionSelector), 'g'), "".concat(TVE.CONST.global_css_prefix, " ").concat(sectionSelector));
                                rules[i].deleteRule(j);
                                rules[i].insertRule(TVE.remove_extra_spaces(cssText), j);
                              }
                            }
                          }
                        }
                      }
                    }, {
                      key: "baseSelector",
                      get: function get() {
                        return ".".concat(this.type, "-section");
                      }
                    }, {
                      key: "contentWidth",

                      /**
                       * Returns the content width of the section
                       *
                       * @returns {Object|Array}
                       */
                      get: function get() {
                        return TVE.head_css_get("".concat(this.baseSelector, " ").concat(LPSection.contentSelector), 'max-width');
                      }
                    }], [{
                      key: "selectionSelector",

                      /**
                       * We are using that in the selectors for element_click, mouseover, icons etc.
                       *
                       * @returns {String}
                       */
                      value: function selectionSelector() {
                        return '.landingpage-section > div';
                      }
                      /* Check if an element is a landing page section */

                    }, {
                      key: "isLPSection",
                      value: function isLPSection($element) {
                        return $element.is(this.identifier);
                      }
                    }, {
                      key: "getTemplateId",
                      value: function getTemplateId() {
                        return TVE.CONST.post_id;
                      }
                      /**
                       * Get arguments when loading a section
                       *
                       * @returns {{query_vars: {page_id: *, post_type: string}}}
                       */

                    }, {
                      key: "getLoadArguments",
                      value: function getLoadArguments() {
                        return {
                          query_vars: {
                            'post_type': TVE.CONST.post_type,
                            'page_id': TVE.CONST.post_id
                          }
                        };
                      }
                    }, {
                      key: "isOnSingularTemplate",
                      value: function isOnSingularTemplate() {
                        return true;
                      }
                      /**
                       * When we are on a landing page, we will save the landing page
                       *
                       * @param {Boolean} silent
                       * @param {Boolean} generatePreview
                       */

                    }, {
                      key: "saveTemplate",
                      value: function saveTemplate() {
                        var silent = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
                        var generatePreview = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
                        TVE.Editor_Page.save(true, undefined, undefined, silent);
                      }
                    }, {
                      key: "getEditorContentWidth",
                      value: function getEditorContentWidth() {
                        var raw = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
                        var width = TVE.Editor_Page.editor.tcbCss(LPSection.contentWidthVariable);

                        if (raw && (!width || width.includes('%'))) {
                          width = TVE.Editor_Page.editor.css('width');
                        }

                        return width;
                      }
                    }, {
                      key: "identifier",
                      get: function get() {
                        return '.landingpage-section';
                      }
                    }, {
                      key: "component",
                      get: function get() {
                        return TVE.Components['landingpage_section'];
                      }
                    }, {
                      key: "contentSelector",
                      get: function get() {
                        return '.section-content';
                      }
                    }, {
                      key: "backgroundSelector",
                      get: function get() {
                        return '.section-background';
                      }
                    }, {
                      key: "contentWidthVariable",
                      get: function get() {
                        return '--page-section-max-width';
                      }
                    }]);

                    return LPSection;
                  }(ThemeSection);

                  module.exports = LPSection;
                })(jQuery);
              }
            },
            "utils.js": function utilsJs(exports, module, require) {
              var LPSection = require('./models/lp-section');

              module.exports = {
                /**
                 * Return the zone where the new clicked elements will be inserted when the section is in edit mode
                 *
                 * @param {jQuery} $target
                 * @returns {*}
                 */
                getSectionDropzoneTarget: function getSectionDropzoneTarget($target) {
                  /* check the element to be added was clicked in the sidebar */
                  if (typeof TVE.FLAGS.$dragged_element !== 'undefined') {
                    return $target;
                  }

                  var $targetSection,
                      $editModeElement = TVE.main.EditMode.element();

                  if ($editModeElement && $editModeElement.length) {
                    /* if we're editing a section, then we drop it there */
                    if (LPSection.is($editModeElement)) {
                      $targetSection = $editModeElement;
                    }
                  } else {
                    var bottomSection = TVE.Theme.utils.getSectionInstance(TVE.Theme.$sections['bottom']);
                    /* If we have a bottom section in the page, the target should be the element right before it */

                    if (bottomSection) {
                      $target = bottomSection.$element.prev();
                    }
                  }

                  if ($targetSection && $targetSection.length) {
                    var section = TVE.Theme.utils.getSectionInstance($targetSection),
                        $sectionChildren = section.$content.children();
                    /* if the inner section is not empty, find the last child of the section and use it as the drop target */

                    if ($sectionChildren.length) {
                      $target = $sectionChildren.last();
                    } else {
                      /* add this div just so we can insert the element near it. destroy it after */
                      $target = TVE.inner_$('<div></div>').appendTo(section.$content);
                      setTimeout(function () {
                        $target.remove();
                      }, 100);
                    }
                  }

                  return $target;
                },

                /**
                 * Change head css prefix when elements are inside a section
                 *
                 * @param {String} prefix
                 * @param {jQuery} $element
                 * @param {Boolean} forHoverState
                 * @returns {*}
                 */
                sectionHeadCssPrefix: function sectionHeadCssPrefix(prefix, $element) {
                  var forHoverState = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
                  var sectionInstance = TVE.Theme.utils.getSectionInstance($element);

                  if (sectionInstance) {
                    /**
                     * if editing the hover state of an element, or of a child of a hovered element, and this is not applied for the hover state, don't modify the prefix
                     */
                    if (forHoverState === false && TVE.flag_modify_hover_selector && TVE.state_manager.is_hover()) {
                      return prefix;
                    }

                    var newPrefix = TVE.Theme.CONST.body_class;
                    /* Dynamic sections don't need any prefix. Normal ones have the body class */

                    if (sectionInstance.constructor.is($element)) {
                      if (sectionInstance.isDynamic()) {
                        newPrefix = '';
                      }
                      /* for dynamic sections, content and background has only section type in data-selector so we add the section class as prefix.
                      * static sections have the section type in the data selector so we don't need to add anything else, body class was already added. */

                    } else if (sectionInstance.isContent($element) || sectionInstance.isBackground($element)) {
                      if (sectionInstance.isDynamic()) {
                        newPrefix = sectionInstance.selector;
                      }
                    } else {
                      if (sectionInstance.isDynamic()) {
                        newPrefix = sectionInstance.selector;
                      } else {
                        newPrefix = "".concat(newPrefix, " ").concat(sectionInstance.selector);
                      }
                    }
                    /* if we have something set, we will add a space after it, otherwise we leave it as it is */


                    prefix = newPrefix ? newPrefix + ' ' + prefix : prefix;
                  }
                  /* replace double spaces with just one */


                  return prefix.replace(/([ ]{2,})/g, ' ');
                }
              };
            }
          }
        }
      }
    }
  }
})("workspace/inc/assets/js/landingpage/init");
