"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

// This file was generated by modules-webmake (modules for web) project.
// See: https://github.com/medikoo/modules-webmake
(function (modules) {
  'use strict';

  var _resolve,
      getRequire,
      wmRequire,
      notFoundError,
      findFile,
      extensions = {
    ".js": [],
    ".json": [],
    ".css": [],
    ".html": []
  },
      envRequire = typeof require === 'function' ? require : null;

  notFoundError = function notFoundError(path) {
    var error = new Error("Could not find module '" + path + "'");
    error.code = 'MODULE_NOT_FOUND';
    return error;
  };

  findFile = function findFile(scope, name, extName) {
    var i, ext;
    if (typeof scope[name + extName] === 'function') return name + extName;

    for (i = 0; ext = extensions[extName][i]; ++i) {
      if (typeof scope[name + ext] === 'function') return name + ext;
    }

    return null;
  };

  _resolve = function resolve(scope, tree, path, fullPath, state, id) {
    var name, dir, exports, module, fn, found, ext;
    path = path.split('/');
    name = path.pop();

    if (name === '.' || name === '..') {
      path.push(name);
      name = '';
    }

    while ((dir = path.shift()) != null) {
      if (!dir || dir === '.') continue;

      if (dir === '..') {
        scope = tree.pop();
        id = id.slice(0, id.lastIndexOf('/'));
      } else {
        tree.push(scope);
        scope = scope[dir];
        id += '/' + dir;
      }

      if (!scope) throw notFoundError(fullPath);
    }

    if (name && typeof scope[name] !== 'function') {
      found = findFile(scope, name, '.js');
      if (!found) found = findFile(scope, name, '.json');
      if (!found) found = findFile(scope, name, '.css');
      if (!found) found = findFile(scope, name, '.html');

      if (found) {
        name = found;
      } else if (state !== 2 && _typeof(scope[name]) === 'object') {
        tree.push(scope);
        scope = scope[name];
        id += '/' + name;
        name = '';
      }
    }

    if (!name) {
      if (state !== 1 && scope[':mainpath:']) {
        return _resolve(scope, tree, scope[':mainpath:'], fullPath, 1, id);
      }

      return _resolve(scope, tree, 'index', fullPath, 2, id);
    }

    fn = scope[name];
    if (!fn) throw notFoundError(fullPath);
    if (fn.hasOwnProperty('module')) return fn.module.exports;
    exports = {};
    fn.module = module = {
      exports: exports,
      id: id + '/' + name
    };
    fn.call(exports, exports, module, getRequire(scope, tree, id));
    return module.exports;
  };

  wmRequire = function wmRequire(scope, tree, fullPath, id) {
    var name,
        path = fullPath,
        t = fullPath.charAt(0),
        state = 0;

    if (t === '/') {
      path = path.slice(1);
      scope = modules['/'];

      if (!scope) {
        if (envRequire) return envRequire(fullPath);
        throw notFoundError(fullPath);
      }

      id = '/';
      tree = [];
    } else if (t !== '.') {
      name = path.split('/', 1)[0];
      scope = modules[name];

      if (!scope) {
        if (envRequire) return envRequire(fullPath);
        throw notFoundError(fullPath);
      }

      id = name;
      tree = [];
      path = path.slice(name.length + 1);

      if (!path) {
        path = scope[':mainpath:'];

        if (path) {
          state = 1;
        } else {
          path = 'index';
          state = 2;
        }
      }
    }

    return _resolve(scope, tree, path, fullPath, state, id);
  };

  getRequire = function getRequire(scope, tree, id) {
    return function (path) {
      return wmRequire(scope, [].concat(tree), path, id);
    };
  };

  return getRequire(modules, [], '');
})({
  "workspace": {
    "inc": {
      "assets": {
        "js": {
          "frontend": {
            "wizard.js": function wizardJs(exports, module, require) {
              (function ($) {
                var isLandingPage;
                $(function () {
                  isLandingPage = $('#tcb_landing_page').length;

                  if (isLandingPage) {
                    $('body').append('<div class="ttb-wizard-border"></div>');
                  }
                });

                if (!window.parent || !window.parent.TTD || !window.parent.TTD.objects.wizardView) {
                  return;
                }

                window.parent.TTD.$ = $;
                var view = window.parent.TTD.objects.wizardView;
                var wizard = view.model;

                var wizardGet = function wizardGet() {
                  var type = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : wizard.get('active');

                  switch (type) {
                    case 'header':
                    case 'woo_header':
                      return $('.ttb-placeholder.p-header,.thrv_header');

                    case 'footer':
                    case 'woo_footer':
                      return $('.ttb-placeholder.p-footer,.thrv_footer');

                    default:
                      return $();
                  }
                };

                var refreshPosition = window.refreshPosition = function () {
                  if (shouldScroll()) {
                    $('html').scrollTop(10000);
                  }

                  wizard.iframeData = view.iframeData = {
                    headerHeight: wizardGet('header').outerHeight(),
                    footerHeight: wizardGet('footer').outerHeight(),
                    scrollWidth: window.innerWidth - document.documentElement.offsetWidth,

                    /* stores the loaded template id for the current page */
                    templateId: Array.from(document.body.classList).filter(function (cls) {
                      return cls.startsWith('tve-theme-');
                    }).map(function (cls) {
                      return Number(cls.replace('tve-theme-', ''));
                    }).pop(),

                    /* stores the next / previous links for page previews (homepage step, "PAGE" option) */
                    nextPage: thrive_front_localize.wizard.next_page,
                    prevPage: thrive_front_localize.wizard.prev_page
                  };

                  if (isLandingPage) {
                    $('.ttb-wizard-border').css({
                      top: view.iframeData.headerHeight,
                      bottom: view.iframeData.footerHeight
                    });
                  }

                  view.buildOverlay();
                };
                /**
                 * Check if the wizard iframe needs to be scrolled
                 *
                 * @returns {*|boolean}
                 */


                var shouldScroll = function shouldScroll() {
                  return thrive_front_localize && (thrive_front_localize.wizard.step === 'footer' || thrive_front_localize.wizard.step === 'woo_footer');
                };

                view.iframeAPI = {
                  getPreviewElement: wizardGet,
                  inlinePreview: function inlinePreview(template) {
                    var $new = $(template.html);
                    wizardGet().replaceWith($new);
                    var $nodes = $new.find('style,img');
                    var total = $nodes.length;
                    $nodes.on('load', function () {
                      total--;

                      if (total === 0) {
                        requestAnimationFrame(refreshPosition);
                      }
                    });
                    /* The img element doesn't always fire a load event, so we will need to call the refreshPosition manually */

                    setTimeout(function () {
                      if (total !== 0) {
                        requestAnimationFrame(refreshPosition);
                      }
                    }, 500);
                  }
                };
                $(window).on('load', function () {
                  refreshPosition();
                });

                window.onbeforeunload = function () {
                  delete view.iframeAPI;
                };

                $(function () {
                  $('a').on('click', function () {
                    return false;
                  });
                  /* if preview step is footer, scroll to bottom of the page */

                  if (shouldScroll()) {
                    $('html').scrollTop(10000);
                  }

                  requestAnimationFrame(refreshPosition);
                });
              })(jQuery);
            }
          }
        }
      }
    }
  }
})("workspace/inc/assets/js/frontend/wizard");
