<?php

/**
 * Thrive Themes - https://thrivethemes.com
 *
 * @package thrive-theme
 */

namespace Thrive\Theme\Integrations\WooCommerce\Elements;

use Thrive\Theme\Integrations\WooCommerce;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Silence is golden!
}

/**
 * Class Cart_To_Checkout_Button
 * @package Thrive\Theme\Integrations\WooCommerce\Elements
 */
class Cart_To_Checkout_Button extends WooCommerce\Elements\Abstract_Sub_Element {
	/**
	 * @return string
	 */
	public function name() {
		return __( 'Proceed to Checkout', THEME_DOMAIN );
	}

	/**
	 * Whether or not the this element can be edited while under :hover state
	 *
	 * @return bool
	 */
	public function has_hover_state() {
		return true;
	}

	/**
	 * @return string
	 */
	public function identifier() {
		return '.wc-proceed-to-checkout a';
	}
}

return new Cart_To_Checkout_Button( 'wc-cart-to-checkout-button' );
