<?php
/**
 * Thrive Themes - https://thrivethemes.com
 *
 * @package thrive-theme
 */

namespace Thrive\Theme\Integrations\WooCommerce\Elements;

use Thrive\Theme\Integrations\WooCommerce;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Silence is golden!
}

/**
 * Class Additional_Section
 * @package Thrive\Theme\Integrations\WooCommerce\Elements
 */
class Additional_Section extends WooCommerce\Elements\Abstract_Sub_Element {
	/**
	 * @return string
	 */
	public function name() {
		return __( 'Text', THEME_DOMAIN );
	}

	/**
	 * @return string
	 */
	public function identifier() {
		return '.woocommerce-info, .woocommerce-form-coupon > p:first-child, .woocommerce-form-login > p:first-child';
	}

	/**
	 * @return array
	 */
	public function own_components() {
		$components = parent::own_components();

		return $components;
	}
}

return new Additional_Section( 'wc-additional-section' );
