<?php
/**
 * Thrive Themes - https://thrivethemes.com
 *
 * @package thrive-theme
 */

namespace Thrive\Theme\Integrations\WooCommerce\Elements;

use Thrive\Theme\Integrations\WooCommerce;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Silence is golden!
}

/**
 * @package Thrive\Theme\Integrations\WooCommerce\Elements
 */
class Field_Header extends WooCommerce\Elements\Abstract_Sub_Element {
	/**
	 * @return string
	 */
	public function name() {
		return __( 'Text', THEME_DOMAIN );
	}

	/**
	 * @return string
	 */
	public function identifier() {
		return '.woocommerce-checkout h3';
	}

	/**
	 * @return array
	 */
	public function own_components() {
		$components = parent::own_components();
		$components['borders']['config']['Borders']['important'] = true;
		return $components;
	}
}

return new Field_Header( 'wc-field-header' );
